/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Arrays;
import java.util.List;
import org.easymock.EasyMock;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.JoinExtractingVisitor;
import org.geotools.api.data.Join;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoinExtractingVisitorTest {
    private FeatureTypeInfo lakes;
    private FeatureTypeInfo forests;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    private FeatureTypeInfo buildings;

    @Before
    public void setup() {
        this.lakes = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)this.lakes.prefixedName()).andReturn((Object)"gs:Lakes").anyTimes();
        EasyMock.expect((Object)this.lakes.getNativeName()).andReturn((Object)"Lakes").anyTimes();
        EasyMock.expect((Object)this.lakes.getName()).andReturn((Object)"Lakes").anyTimes();
        this.forests = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)this.forests.prefixedName()).andReturn((Object)"gs:Forests").anyTimes();
        EasyMock.expect((Object)this.forests.getNativeName()).andReturn((Object)"Forests").anyTimes();
        EasyMock.expect((Object)this.forests.getName()).andReturn((Object)"Forests").anyTimes();
        this.buildings = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)this.buildings.prefixedName()).andReturn((Object)"gs:Buildings").anyTimes();
        EasyMock.expect((Object)this.buildings.getNativeName()).andReturn((Object)"Buildings").anyTimes();
        EasyMock.expect((Object)this.buildings.getName()).andReturn((Object)"Buildings").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lakes, this.forests, this.buildings});
    }

    @Test
    public void testTwoWayJoin() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.lakes, this.forests), Arrays.asList("a", "b"));
        PropertyIsEqualTo f = this.ff.equals((Expression)this.ff.property("a/FID"), (Expression)this.ff.property("b/FID"));
        f.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)"a", (Object)visitor.getPrimaryAlias());
        Filter primary = visitor.getPrimaryFilter();
        Assert.assertNull((Object)primary);
        List joins = visitor.getJoins();
        Assert.assertEquals((long)1L, (long)joins.size());
        Join join = (Join)joins.get(0);
        Assert.assertEquals((Object)"Forests", (Object)join.getTypeName());
        Assert.assertEquals((Object)"b", (Object)join.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("a.FID"), (Expression)this.ff.property("b.FID")), (Object)join.getJoinFilter());
    }

    @Test
    public void testThreeWayJoinWithAliases() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.lakes, this.forests, this.buildings), Arrays.asList("a", "b", "c"));
        PropertyIsEqualTo f1 = this.ff.equals((Expression)this.ff.property("a/FID"), (Expression)this.ff.property("b/FID"));
        PropertyIsEqualTo f2 = this.ff.equals((Expression)this.ff.property("b/FID"), (Expression)this.ff.property("c/FID"));
        And f = this.ff.and(Arrays.asList(f1, f2));
        this.testThreeWayJoin(visitor, (Filter)f);
    }

    @Test
    public void testThreeWayJoinNoAliasesUnqualified() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.lakes, this.forests, this.buildings), null);
        PropertyIsEqualTo f1 = this.ff.equals((Expression)this.ff.property("Lakes/FID"), (Expression)this.ff.property("Forests/FID"));
        PropertyIsEqualTo f2 = this.ff.equals((Expression)this.ff.property("Forests/FID"), (Expression)this.ff.property("Buildings/FID"));
        And f = this.ff.and(Arrays.asList(f1, f2));
        this.testThreeWayJoin(visitor, (Filter)f);
    }

    @Test
    public void testThreeWayJoinNoAliasesQualified() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.lakes, this.forests, this.buildings), null);
        PropertyIsEqualTo f1 = this.ff.equals((Expression)this.ff.property("gs:Lakes/FID"), (Expression)this.ff.property("gs:Forests/FID"));
        PropertyIsEqualTo f2 = this.ff.equals((Expression)this.ff.property("gs:Forests/FID"), (Expression)this.ff.property("gs:Buildings/FID"));
        And f = this.ff.and(Arrays.asList(f1, f2));
        this.testThreeWayJoin(visitor, (Filter)f);
    }

    private void testThreeWayJoin(JoinExtractingVisitor visitor, Filter f) {
        f.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)"b", (Object)visitor.getPrimaryAlias());
        Filter primary = visitor.getPrimaryFilter();
        Assert.assertNull((Object)primary);
        List joins = visitor.getJoins();
        Assert.assertEquals((long)2L, (long)joins.size());
        Join j1 = (Join)joins.get(0);
        Assert.assertEquals((Object)"Lakes", (Object)j1.getTypeName());
        Assert.assertEquals((Object)"a", (Object)j1.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("a.FID"), (Expression)this.ff.property("b.FID")), (Object)j1.getJoinFilter());
        Join j2 = (Join)joins.get(1);
        Assert.assertEquals((Object)"Buildings", (Object)j2.getTypeName());
        Assert.assertEquals((Object)"c", (Object)j2.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("b.FID"), (Expression)this.ff.property("c.FID")), (Object)j2.getJoinFilter());
    }

    @Test
    public void testThreeWayJoinPrimaryFilters() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.lakes, this.forests, this.buildings), Arrays.asList("a", "b", "c"));
        PropertyIsEqualTo fj1 = this.ff.equals((Expression)this.ff.property("a/FID"), (Expression)this.ff.property("b/FID"));
        PropertyIsEqualTo fj2 = this.ff.equals((Expression)this.ff.property("b/FID"), (Expression)this.ff.property("c/FID"));
        PropertyIsEqualTo f1 = this.ff.equals((Expression)this.ff.property("a/FID"), (Expression)this.ff.literal((Object)"Lakes.10"));
        PropertyIsEqualTo f2 = this.ff.equals((Expression)this.ff.property("b/FID"), (Expression)this.ff.literal((Object)"Forests.10"));
        PropertyIsEqualTo f3 = this.ff.equals((Expression)this.ff.property("c/FID"), (Expression)this.ff.literal((Object)"Buildings.10"));
        And f = this.ff.and(Arrays.asList(f1, f2, f3, fj1, fj2));
        f.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)"b", (Object)visitor.getPrimaryAlias());
        Filter primary = visitor.getPrimaryFilter();
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("FID"), (Expression)this.ff.literal((Object)"Forests.10")), (Object)primary);
        List joins = visitor.getJoins();
        Assert.assertEquals((long)2L, (long)joins.size());
        Join j1 = (Join)joins.get(0);
        Assert.assertEquals((Object)"Lakes", (Object)j1.getTypeName());
        Assert.assertEquals((Object)"a", (Object)j1.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("a.FID"), (Expression)this.ff.property("b.FID")), (Object)j1.getJoinFilter());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("FID"), (Expression)this.ff.literal((Object)"Lakes.10")), (Object)j1.getFilter());
        Join j2 = (Join)joins.get(1);
        Assert.assertEquals((Object)"Buildings", (Object)j2.getTypeName());
        Assert.assertEquals((Object)"c", (Object)j2.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("b.FID"), (Expression)this.ff.property("c.FID")), (Object)j2.getJoinFilter());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("FID"), (Expression)this.ff.literal((Object)"Buildings.10")), (Object)j2.getFilter());
    }

    @Test
    public void testThreeWayJoinWithSelf() {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(Arrays.asList(this.forests, this.lakes, this.lakes), Arrays.asList("a", "b", "c"));
        PropertyIsEqualTo f1 = this.ff.equals((Expression)this.ff.property("a/FID"), (Expression)this.ff.property("b/FID"));
        PropertyIsEqualTo f2 = this.ff.equals((Expression)this.ff.property("b/FID"), (Expression)this.ff.property("c/FID"));
        And f = this.ff.and(Arrays.asList(f1, f2));
        f.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)"b", (Object)visitor.getPrimaryAlias());
        Filter primary = visitor.getPrimaryFilter();
        Assert.assertNull((Object)primary);
        List joins = visitor.getJoins();
        Assert.assertEquals((long)2L, (long)joins.size());
        Join j1 = (Join)joins.get(0);
        Assert.assertEquals((Object)"Forests", (Object)j1.getTypeName());
        Assert.assertEquals((Object)"a", (Object)j1.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("a.FID"), (Expression)this.ff.property("b.FID")), (Object)j1.getJoinFilter());
        Join j2 = (Join)joins.get(1);
        Assert.assertEquals((Object)"Lakes", (Object)j2.getTypeName());
        Assert.assertEquals((Object)"c", (Object)j2.getAlias());
        Assert.assertEquals((Object)this.ff.equals((Expression)this.ff.property("b.FID"), (Expression)this.ff.property("c.FID")), (Object)j2.getJoinFilter());
    }
}

