/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReprojectionTest
extends WFSTestSupport {
    private static final String TARGET_CRS_CODE = "EPSG:900913";
    public static QName NULL_GEOMETRIES = new QName(SystemTestData.CITE_URI, "NullGeometries", SystemTestData.CITE_PREFIX);
    public static QName GOOGLE = new QName(SystemTestData.CITE_URI, "GoogleFeatures", SystemTestData.CITE_PREFIX);
    static MathTransform tx;

    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)TARGET_CRS_CODE);
        CoordinateReferenceSystem epsg32615 = CRS.decode((String)"EPSG:32615");
        tx = CRS.findMathTransform((CoordinateReferenceSystem)epsg32615, (CoordinateReferenceSystem)epsg4326);
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        dataDirectory.addVectorLayer(NULL_GEOMETRIES, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<SystemTestData.LayerProperty, Object> extra = new HashMap<SystemTestData.LayerProperty, Object>();
        extra.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.REPROJECT_TO_DECLARED);
        extra.put(SystemTestData.LayerProperty.SRS, 900913);
        dataDirectory.addVectorLayer(GOOGLE, extra, ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testGetFeatureGet() throws Exception {
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart() + "&srsName=EPSG:900913");
        this.runTest(dom1, dom2, tx);
    }

    @Test
    public void testGetFeatureGetAutoCRS() throws Exception {
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart() + "&srsName=AUTO:42001,9001,-93,0");
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:32615"), (CoordinateReferenceSystem)CRS.decode((String)"AUTO:42001,9001,-93,0"));
        this.runTest(dom1, dom2, tx);
    }

    @Test
    public void testGetFeatureAutoCRSBBox() throws Exception {
        CoordinateReferenceSystem auto = CRS.decode((String)"AUTO:42001,9001,-93,0");
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(this.getLayerId(SystemTestData.POLYGONS));
        ReferencedEnvelope nativeEnv = ftInfo.getFeatureSource(null, null).getBounds();
        ReferencedEnvelope reprojectedEnv = nativeEnv.transform(auto, true);
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + SystemTestData.POLYGONS.getLocalPart() + "&srsName=AUTO:42001,9001,-93,00&bbox=" + reprojectedEnv.getMinX() + "," + reprojectedEnv.getMinY() + "," + reprojectedEnv.getMaxX() + "," + reprojectedEnv.getMaxY() + ",AUTO:42001,9001,-93,0");
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:32615"), (CoordinateReferenceSystem)auto);
        this.runTest(dom1, dom2, tx);
    }

    @Test
    public void testGetFeatureReprojectedFeatureType() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + GOOGLE.getLocalPart() + "&bbox=445000,445000,668000,668000");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:GoogleFeatures)", (Document)dom);
    }

    @Test
    public void testGetFeaturePost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart() + "\"> <wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom1 = this.postAsDOM("wfs", xml);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query srsName=\"EPSG:900913\" typeName=\"" + SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart() + "\"> <wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom2 = this.postAsDOM("wfs", xml);
        this.runTest(dom1, dom2, tx);
    }

    @Test
    public void testReprojectNullGeometries() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query srsName=\"EPSG:900913\" typeName=\"" + NULL_GEOMETRIES.getPrefix() + ":" + NULL_GEOMETRIES.getLocalPart() + "\"> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:FeatureCollection").getLength());
    }

    @Test
    public void testGetFeatureWithProjectedBoxGet() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + SystemTestData.POLYGONS.getLocalPart() + "&bbox=" + cr[0] + "," + cr[1] + "," + cr[2] + "," + cr[3] + ",EPSG:900913";
        Document dom = this.getAsDOM(q);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName(SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart()).getLength());
    }

    @Test
    public void testGetFeatureWithProjectedBoxPost() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:" + SystemTestData.POLYGONS.getPrefix() + "=\"" + SystemTestData.POLYGONS.getNamespaceURI() + "\" xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart() + "\"><wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> <ogc:Filter><ogc:BBOX><ogc:PropertyName>polygonProperty</ogc:PropertyName><gml:Box srsName=\"EPSG:900913\"><gml:coord><gml:X>" + cr[0] + "</gml:X><gml:Y>" + cr[1] + "</gml:Y></gml:coord><gml:coord><gml:X>" + cr[2] + "</gml:X><gml:Y>" + cr[3] + "</gml:Y></gml:coord></gml:Box></ogc:BBOX></ogc:Filter></wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName(SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart()).getLength());
    }

    @Test
    public void testGetFeatureWithProjectedBoxIntersectsPost() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:" + SystemTestData.POLYGONS.getPrefix() + "=\"" + SystemTestData.POLYGONS.getNamespaceURI() + "\" xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart() + "\" srsName=\"EPSG:900913\"><wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> <ogc:Filter><ogc:Intersects><ogc:PropertyName>polygonProperty</ogc:PropertyName><gml:Box><gml:coord><gml:X>" + cr[0] + "</gml:X><gml:Y>" + cr[1] + "</gml:Y></gml:coord><gml:coord><gml:X>" + cr[2] + "</gml:X><gml:Y>" + cr[3] + "</gml:Y></gml:coord></gml:Box></ogc:Intersects></ogc:Filter></wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName(SystemTestData.POLYGONS.getPrefix() + ":" + SystemTestData.POLYGONS.getLocalPart()).getLength());
    }

    private double[] getTransformedPolygonsLayerBBox() throws Exception, TransformException {
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + SystemTestData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element envelope = this.getFirstElementByTagName(dom, "gml:Box");
        String coordinates = this.getFirstElementByTagName(envelope, "gml:coordinates").getFirstChild().getNodeValue();
        String lc = coordinates.split(" ")[0];
        String uc = coordinates.split(" ")[1];
        double[] c = new double[]{Double.parseDouble(lc.split(",")[0]), Double.parseDouble(lc.split(",")[1]), Double.parseDouble(uc.split(",")[0]), Double.parseDouble(uc.split(",")[1])};
        double[] cr = new double[4];
        tx.transform(c, 0, cr, 0, 2);
        return cr;
    }

    private void runTest(Document dom1, Document dom2, MathTransform tx) throws Exception {
        Element box = this.getFirstElementByTagName(dom1.getDocumentElement(), "gml:Box");
        Element coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d1 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        box = this.getFirstElementByTagName(dom2.getDocumentElement(), "gml:Box");
        coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d2 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        double[] d3 = new double[d1.length];
        tx.transform(d1, 0, d3, 0, d1.length / 2);
        for (int i = 0; i < d2.length; ++i) {
            Assert.assertEquals((double)d2[i], (double)d3[i], (double)0.001);
        }
    }

    private double[] coordinates(String string) {
        StringTokenizer st = new StringTokenizer(string, " ");
        double[] coordinates = new double[st.countTokens() * 2];
        int i = 0;
        while (st.hasMoreTokens()) {
            String tuple = st.nextToken();
            coordinates[i++] = Double.parseDouble(tuple.split(",")[0]);
            coordinates[i++] = Double.parseDouble(tuple.split(",")[1]);
        }
        return coordinates;
    }
}

