/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class RetypingTransactionTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo featureType1 = catalog.getFeatureTypeByName(SystemTestData.POLYGONS.getLocalPart());
        featureType1.setName("MyPolygons");
        this.getCatalog().save((ResourceInfo)featureType1);
        FeatureTypeInfo featureType2 = catalog.getFeatureTypeByName(SystemTestData.LINES.getLocalPart());
        featureType2.setName("MyLines");
        this.getCatalog().save((ResourceInfo)featureType2);
        FeatureTypeInfo featureType3 = catalog.getFeatureTypeByName(SystemTestData.POINTS.getLocalPart());
        featureType3.setName("MyPoints");
        this.getCatalog().save((ResourceInfo)featureType3);
    }

    @Before
    public void revert() throws Exception {
        this.revertLayer(SystemTestData.POLYGONS);
        this.revertLayer(SystemTestData.LINES);
        this.revertLayer(SystemTestData.POINTS);
    }

    @Test
    public void testInsert() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyLines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:MyLines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:MyLines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testUpdate() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyPolygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((Object)"t0002", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:MyPolygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((Object)"t0003", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:MyPoints\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:MyPoints\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }
}

