/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;
import org.geotools.jdbc.VirtualTableParameter;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SQLViewTest
extends WFSTestSupport {
    static final String tableTypeName = "gs:pgeo";
    static final String viewTypeName = "gs:pgeo_view";

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("sqlviews");
        WorkspaceInfo ws = cat.getDefaultWorkspace();
        ds.setWorkspace(ws);
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        File dbFile = new File(((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath(), "data/h2test");
        params.put("database", dbFile.getAbsolutePath());
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fsp = this.getFeatureSource(SystemTestData.PRIMITIVEGEOFEATURE);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fsp.getSchema());
        tb.remove("surfaceProperty");
        tb.remove("curveProperty");
        tb.remove("uriProperty");
        tb.setName("pgeo");
        SimpleFeatureType schema = tb.buildFeatureType();
        store.createSchema((FeatureType)schema);
        SimpleFeatureStore featureStore = (SimpleFeatureStore)store.getFeatureSource("pgeo");
        featureStore.addFeatures((FeatureCollection)fsp.getFeatures());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo tft = cb.buildFeatureType((FeatureSource)featureStore);
        cat.add((ResourceInfo)tft);
        JDBCDataStore jds = (JDBCDataStore)ds.getDataStore(null);
        VirtualTable vt = new VirtualTable("pgeo_view", "select \"name\", \"pointProperty\" from \"pgeo\" where \"booleanProperty\" = %bool% and \"name\" = '%name%'");
        vt.addParameter(new VirtualTableParameter("bool", "true"));
        vt.addParameter(new VirtualTableParameter("name", "name-f001"));
        vt.addGeometryMetadatata("pointProperty", Point.class, 4326);
        jds.createVirtualTable(vt);
        FeatureTypeInfo vft = cb.buildFeatureType((FeatureSource)jds.getFeatureSource(vt.getName()));
        vft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        cat.add((ResourceInfo)vft);
    }

    @Test
    public void testStoreSetup() throws Exception {
        FeatureTypeInfo tableTypeInfo = this.getCatalog().getFeatureTypeByName(tableTypeName);
        Assert.assertNotNull((Object)tableTypeInfo);
        Assert.assertEquals((long)5L, (long)tableTypeInfo.getFeatureSource(null, null).getCount(Query.ALL));
        FeatureTypeInfo viewTypeInfo = this.getCatalog().getFeatureTypeByName(viewTypeName);
        Assert.assertNotNull((Object)viewTypeInfo);
        Assert.assertEquals((long)1L, (long)viewTypeInfo.getFeatureSource(null, null).getCount(Query.ALL));
    }

    @Test
    public void testViewParamsGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&request=GetFeature&typename=gs:pgeo_view&version=1.1&viewparams=bool:true;name:name-f003");
        XMLAssert.assertXpathEvaluatesTo((String)"name-f003", (String)"//gs:pgeo_view/gml:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gs:pgeo_view)", (Document)dom);
    }

    @Test
    public void testViewParamsJsonGet() throws Exception {
        JSON json = this.getAsJSON("wfs?service=WFS&request=GetFeature&typename=gs:pgeo_view&version=1.1&viewparams=bool:true;name:name-f003&outputFormat=application/json");
        Assert.assertEquals((long)1L, (long)((JSONObject)json).getInt("totalFeatures"));
    }

    @Test
    public void testPostWithViewParams_v100() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" viewParams=\"bool:true;name:name-f003\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"gs:pgeo_view\"> </wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertNotEquals((long)0L, (long)featureMembers.getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"name-f003", (String)"//gs:pgeo_view/gs:name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gs:pgeo_view)", (Document)doc);
    }

    @Test
    public void testPostWithViewParams_110() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" viewParams=\"bool:true;name:name-f003\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"gs:pgeo_view\"> </wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureCollection = doc.getElementsByTagName("wfs:FeatureCollection");
        Assert.assertNotEquals((long)0L, (long)featureCollection.getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"name-f003", (String)"//gs:pgeo_view/gml:name", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gs:pgeo_view)", (Document)doc);
    }

    @Test
    public void testPostWithViewParams_200() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" viewParams=\"bool:true;name:name-f003\"> <wfs:Query typeNames=\"gs:pgeo_view\"></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName(viewTypeName);
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getFirstChild().getNodeName(), (Object)"gml:name");
        Assert.assertEquals((Object)features.item(0).getFirstChild().getTextContent(), (Object)"name-f003");
    }

    @Test
    public void testXMLViewParamsGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&request=GetFeature&typename=gs:pgeo_view&version=1.1&viewParamsFormat=XML&viewparams=<VP><PS><P n=\"bool\">true</P><P n=\"name\">name-f003</P></PS></VP>");
        XMLAssert.assertXpathEvaluatesTo((String)"name-f003", (String)"//gs:pgeo_view/gml:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gs:pgeo_view)", (Document)dom);
    }

    @Test
    public void testPostWithXMLViewParams_200() throws Exception {
        String xmlViewParams = StringEscapeUtils.escapeXml10((String)"<VP><PS><P n=\"bool\">true</P><P n=\"name\">name-f003</P></PS></VP>");
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" viewParams=\"" + xmlViewParams + "\"> <wfs:Query typeNames=\"gs:pgeo_view\"></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs?viewParamsFormat=XML", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName(viewTypeName);
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getFirstChild().getNodeName(), (Object)"gml:name");
        Assert.assertEquals((Object)features.item(0).getFirstChild().getTextContent(), (Object)"name-f003");
    }
}

