/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.GeoServerTestApplicationContext;
import org.geoserver.wfs.ExceptionThrowingTrigger;
import org.geoserver.wfs.Transaction;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.TransactionRequest;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.DefaultTransaction;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.POINTS);
        this.revertLayer(CiteTestData.FIFTEEN);
        this.revertLayer(CiteTestData.LINES);
        this.revertLayer(CiteTestData.POLYGONS);
        this.revertLayer(CiteTestData.NAMED_PLACES);
        this.revertLayer(CiteTestData.BUILDINGS);
    }

    @Test
    public void testDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Points\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:Points\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cgf:id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testDoubleDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Fifteen\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//gml:featureMember)", (Document)dom);
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.1\"/> </ogc:Filter> </wfs:Delete> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.2\"/> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"13", (String)"count(//gml:featureMember)", (Document)dom);
    }

    @Test
    public void testInsert() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testInsertWithGetFeatureInThePath() throws Exception {
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=cgf:Lines", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
    }

    @Test
    public void testBatchDoubleInsert() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert><wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0003</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testBatchDoubleDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Fifteen\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//gml:featureMember)", (Document)dom);
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.1\"/> </ogc:Filter> </wfs:Delete> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.2\"/> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"13", (String)"count(//gml:featureMember)", (Document)dom);
    }

    @Test
    public void testBatchDoubleDifferentTypesDelete() throws Exception {
        String getFeatureNamedPlaces = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cite:NamedPlaces\"/> </wfs:GetFeature>";
        String getFeatureBuildings = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cite:Buildings\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeatureNamedPlaces);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gml:featureMember)", (Document)dom);
        dom = this.postAsDOM("wfs", getFeatureBuildings);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gml:featureMember)", (Document)dom);
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cite=\"http://www.opengis.net/cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cite:NamedPlaces\"> <ogc:Filter> <ogc:PropertyIsEqualTo>\n        <ogc:PropertyName>cite:NAME</ogc:PropertyName>\n        <ogc:Literal>ASHTON</ogc:Literal>\n</ogc:PropertyIsEqualTo></ogc:Filter> </wfs:Delete> <wfs:Delete typeName=\"cite:Buildings\"> <ogc:Filter> <ogc:PropertyIsEqualTo>\n        <ogc:PropertyName>cite:ADDRESS</ogc:PropertyName>\n        <ogc:Literal>123 Main Street</ogc:Literal>\n</ogc:PropertyIsEqualTo></ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeatureBuildings);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
        dom = this.postAsDOM("wfs", getFeatureBuildings);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMember)", (Document)dom);
    }

    @Test
    public void testBatchDoubleDeleteWithBatchSizeOne() throws Exception {
        System.setProperty("org.geoserver.wfs.deleteBatchSize", "1");
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Fifteen\"/> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//gml:featureMember)", (Document)dom);
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.1\"/> </ogc:Filter> </wfs:Delete> <wfs:Delete typeName=\"cdf:Fifteen\"> <ogc:Filter> <ogc:FeatureId fid=\"Fifteen.2\"/> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        dom = this.postAsDOM("wfs", delete);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        XMLAssert.assertXpathEvaluatesTo((String)"13", (String)"count(//gml:featureMember)", (Document)dom);
    }

    @Test
    public void testBatchInsertAndDelete() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        String insertAndDelete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert><wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0003</cgf:id></cgf:Lines></wfs:Insert><wfs:Delete typeName=\"cgf:Lines\"> <ogc:Filter> <ogc:FeatureId fid=\"new1\"/> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insertAndDelete);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testBatchInsertDeleteAndUpdate() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Lines\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        String insertAndDelete = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert><wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0003</cgf:id></cgf:Lines></wfs:Insert><wfs:Delete typeName=\"cgf:Lines\"> <ogc:Filter> <ogc:FeatureId fid=\"new1\"/> </ogc:Filter> </wfs:Delete> <wfs:Update typeName=\"cgf:Lines\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", insertAndDelete);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertNotNull((Object)dom.getElementsByTagName("<cgf:id>t0003</cgf:id>"));
    }

    @Test
    public void testUpdate() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Polygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((Object)"t0002", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        this.postAsDOM("wfs", update);
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((Object)"t0003", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testUpdateLayerQualified() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"Polygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("cgf/Polygons/wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((Object)"t0002", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("cgf/Lines/wfs", insert);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cgf/Polygons/wfs", insert);
        dom = this.postAsDOM("cgf/Polygons/wfs", getFeature);
        Assert.assertEquals((Object)"t0003", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void testInsertWithBoundedBy() throws Exception {
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:cite=\"http://www.opengis.net/cite\"><wfs:Insert> <cite:BasicPolygons><gml:boundedBy><gml:Box><gml:coordinates cs=\",\" decimal=\".\" ts=\" \">-2,-1 2,6</gml:coordinates></gml:Box></gml:boundedBy>  <cite:the_geom><gml:MultiPolygon><gml:polygonMember><gml:Polygon><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates cs=\",\" decimal=\".\" ts=\" \">-1,0 0,1 1,0 0,-1 -1,0</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></gml:polygonMember></gml:MultiPolygon>  </cite:the_geom>  <cite:ID>foo</cite:ID> </cite:BasicPolygons></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_TransactionResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertTrue((dom.getElementsByTagName("ogc:FeatureId").getLength() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dom.getElementsByTagName("wfs:SUCCESS").getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInsertWorkspaceQualified() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"Lines\"> <ogc:PropertyName>id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("cgf/wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("cgf/wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.postAsDOM("sf/wfs", insert);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cgf/wfs", getFeature);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testInsertLayerQualified() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"Lines\"> <ogc:PropertyName>id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("cgf/Lines/wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Insert > <cgf:Lines><cgf:lineStringProperty><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></cgf:lineStringProperty><cgf:id>t0002</cgf:id></cgf:Lines></wfs:Insert></wfs:Transaction>";
        dom = this.postAsDOM("cgf/Lines/wfs", insert);
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        Assert.assertNotEquals((long)0L, (long)dom.getElementsByTagName("wfs:InsertResult").getLength());
        dom = this.postAsDOM("cgf/Polygons/wfs", insert);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cgf/Lines/wfs", getFeature);
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
    }

    @Test
    public void testUpdateWithDifferentPrefix() throws Exception {
        String getFeature = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cgf=\"http://www.opengis.net/cite/geometry\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cgf:Polygons\"> <ogc:PropertyName>cite:id</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:featureMember").getLength());
        Assert.assertEquals((Object)"t0002", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update xmlns:foo=\"http://www.opengis.net/cite/geometry\" typeName=\"foo:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        dom = this.postAsDOM("wfs", update);
        dom = this.postAsDOM("wfs", getFeature);
        Assert.assertEquals((Object)"t0003", (Object)dom.getElementsByTagName("cgf:id").item(0).getFirstChild().getNodeValue());
    }

    @Test
    public void elementHandlerOrder() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = this.getDataStoreInfo(cat);
        DataStore store = (DataStore)ds.getDataStore(null);
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource("bar");
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        String xml = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:gs='" + SystemTestData.DEFAULT_URI + "'><wfs:Insert idgen='UseExisting'> <gs:bar gml:id='1'>    <gs:name>acme</gs:name> </gs:bar> <gs:bar gml:id='2'>    <gs:name>wiley</gs:name> </gs:bar> <gs:bar gml:id='3'>    <gs:name>bugs</gs:name> </gs:bar> <gs:bar gml:id='4'>    <gs:name>roadrunner</gs:name> </gs:bar> <gs:bar gml:id='5'>    <gs:name>daffy</gs:name> </gs:bar> <gs:bar gml:id='6'>    <gs:name>elmer</gs:name> </gs:bar> <gs:bar gml:id='7'>    <gs:name>tweety</gs:name> </gs:bar> <gs:bar gml:id='8'>    <gs:name>sylvester</gs:name> </gs:bar> <gs:bar gml:id='9'>    <gs:name>marvin</gs:name> </gs:bar> <gs:bar gml:id='10'>    <gs:name>yosemite</gs:name> </gs:bar> <gs:bar gml:id='11'>    <gs:name>porky</gs:name> </gs:bar> <gs:bar gml:id='12'>    <gs:name>speedy</gs:name> </gs:bar> <gs:bar gml:id='13'>    <gs:name>taz</gs:name> </gs:bar></wfs:Insert></wfs:Transaction>";
        Document dom = this.postAsDOM("wfs", xml);
        dom = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeNames=gs:bar");
        NodeList elementsByTagName = dom.getElementsByTagName("gs:bar");
        for (int i = 1; i <= elementsByTagName.getLength(); ++i) {
            String id = elementsByTagName.item(i - 1).getAttributes().item(0).getNodeValue();
            Assert.assertEquals((Object)("bar." + i), (Object)id);
        }
        dom = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&featureId=bar.5");
        XMLAssert.assertXpathEvaluatesTo((String)"daffy", (String)"//gs:name/text()", (Document)dom);
        this.dispose(cat, ds, store, ft);
    }

    @Test
    public void testBuildGeotoolsTransaction() throws IOException {
        TestingAuthenticationToken authentication = null;
        this.testBuildGeotoolsTransaction((Authentication)authentication);
        String principal = "John Smith";
        authentication = new TestingAuthenticationToken((Object)principal, null);
        this.testBuildGeotoolsTransaction((Authentication)authentication);
        principal = new GeoServerUser("Akira Kurosawa");
        authentication = new TestingAuthenticationToken((Object)principal, null);
        this.testBuildGeotoolsTransaction((Authentication)authentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBuildGeotoolsTransaction(Authentication authentication) throws IOException {
        DefaultTransaction gtTransaction;
        String wfsReqHandle = "Request handle";
        final HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("extKey", "extValue");
        TransactionRequest.WFS11 request = new TransactionRequest.WFS11(null){

            public Map<?, ?> getExtendedProperties() {
                return extendedProperties;
            }

            public String getHandle() {
                return "Request handle";
            }
        };
        SecurityContext ctxBackup = SecurityContextHolder.getContext();
        try {
            SecurityContextImpl tmpSecurityCtx = new SecurityContextImpl();
            tmpSecurityCtx.setAuthentication(authentication);
            SecurityContextHolder.setContext((SecurityContext)tmpSecurityCtx);
            GeoServerTestApplicationContext context = GeoServerSystemTestSupport.applicationContext;
            Transaction transaction = new Transaction(this.getWFS(), this.getCatalog(), (ApplicationContext)context);
            gtTransaction = transaction.getDatastoreTransaction((TransactionRequest)request);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)ctxBackup);
        }
        Assert.assertNotNull((Object)gtTransaction);
        Assert.assertEquals((Object)"extValue", (Object)gtTransaction.getProperty((Object)"extKey"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntityExpansionLimitOnTransaction() throws Exception {
        try {
            System.getProperties().setProperty("org.geoserver.wfs.xml.entityExpansionLimit", "1");
            Document dom = this.postAsDOM("wfs", this.xmlEntityExpansionLimitBody());
            NodeList serviceExceptionList = dom.getElementsByTagName("ServiceException");
            Assert.assertEquals((long)1L, (long)serviceExceptionList.getLength());
            Node serviceException = serviceExceptionList.item(0);
            Assert.assertTrue((boolean)serviceException.getTextContent().contains("JAXP00010001"));
        }
        finally {
            System.getProperties().remove("org.geoserver.wfs.xml.entityExpansionLimit");
        }
    }

    private String xmlEntityExpansionLimitBody() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE convert [ <!ENTITY lol \"lol\"><!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;\"> ]>\n<Transaction xmlns=\"http://www.opengis.net/wfs\" service=\"WFS\" xmlns:xxx=\"https://www.be/cbb\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:gml=\"http://www.opengis.net/gml\" version=\"1.0.0\" xsi:schemaLocation=\"\">\n   <Insert xmlns=\"http://www.opengis.net/wfs\">\n    <xxx_all_service_city xmlns=\"https://www.be/cbb\">\n      <NAME xmlns=\"https://www.be/cbb\">GENT PTEST1</NAME>\n      <DESCRIPTION xmlns=\"https://www.be/cbb\">ptest1</DESCRIPTION>\n      <STATUS xmlns=\"https://www.be/cbb\">default</STATUS>\n      <CREATED_BY xmlns=\"https://www.be/cbb\">upload service</CREATED_BY>\n      <CREATED_DT xmlns=\"https://www.be/cbb\">2019-04-04Z</CREATED_DT>\n      <EXTERNAL_ID xmlns=\"https://www.be/cbb\">City1ptest1</EXTERNAL_ID>\n      <EXTERNAL_SOURCE xmlns=\"https://www.be/cbb\">RIAN</EXTERNAL_SOURCE>\n      <TYPE xmlns=\"https://www.be/cbb\">TYPE.CITY</TYPE>\n      <WAVE xmlns=\"https://www.be/cbb\">3</WAVE>\n      <GEOM xmlns=\"https://www.be/cbb\">\n        <gml:Polygon srsName=\"EPSG:31370\">\n          <gml:outerBoundaryIs>\n            <gml:LinearRing>\n              <gml:coordinates cs=\",\" ts=\" \">&lol1;</gml:coordinates>\n            </gml:LinearRing>\n          </gml:outerBoundaryIs>\n        </gml:Polygon>\n      </GEOM>\n    </xxx_all_service_city>\n  </Insert>\n</Transaction>";
    }

    @Test
    public void testBrokenDelete() throws Exception {
        String delete = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"> <wfs:Delete typeName=\"cgf:Points\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>id</ogc:PropertyName> <ogc:Literal>t0000</ogc:Literal> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Delete> </wfs:Transaction>";
        Document resp = this.postAsDOM("wfs", delete);
        this.checkOws10Exception(resp);
        String text = resp.getElementsByTagName("ows:ExceptionText").item(0).getTextContent();
        Assert.assertTrue((boolean)text.contains("Feature type 'Points' is not available"));
        String code = ((Element)resp.getElementsByTagName("ows:Exception").item(0)).getAttribute("exceptionCode");
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)code);
    }

    @Test
    public void testBrokenUpdate() throws Exception {
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:Polygons\" > <wfs:Property><wfs:Name>id</wfs:Name><wfs:Value>t0003</wfs:Value></wfs:Property><ogc:Filter><ogc:PropertyIsEqualTo><ogc:PropertyName>id</ogc:PropertyName><ogc:Literal>t0002</ogc:Literal></ogc:PropertyIsEqualTo></ogc:Filter></wfs:Update></wfs:Transaction>";
        Document resp = this.postAsDOM("wfs", update);
        this.checkOws10Exception(resp);
        String text = resp.getElementsByTagName("ows:ExceptionText").item(0).getTextContent();
        Assert.assertTrue((boolean)text.contains("Feature type 'Polygons' is not available"));
        String code = ((Element)resp.getElementsByTagName("ows:Exception").item(0)).getAttribute("exceptionCode");
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)code);
    }

    @Test
    public void testBadGeometryTypeUpdate() throws Exception {
        String update = "<wfs:Transaction service=\"WFS\" version=\"1.1.0\" xmlns:cgf=\"cite\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"> <wfs:Update typeName=\"cgf:BasicPolygons\" > <wfs:Property><wfs:Name>the_geom</wfs:Name><wfs:Value><gml:LineString><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">494475.71056415,5433016.8189323 494982.70115662,5435041.95096618</gml:coordinates></gml:LineString></wfs:Value></wfs:Property></wfs:Update></wfs:Transaction>";
        Document resp = this.postAsDOM("wfs", update);
        this.checkOws10Exception(resp);
        Node exceptionNode = resp.getElementsByTagName("ows:Exception").item(0);
        Assert.assertEquals((Object)"InvalidValue", (Object)exceptionNode.getAttributes().getNamedItem("exceptionCode").getTextContent());
        Assert.assertEquals((Object)"the_geom", (Object)exceptionNode.getAttributes().getNamedItem("locator").getTextContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionalTransactionCauseNotInException() throws Exception {
        GeoServerInfo gs = this.getGeoServer().getGlobal();
        gs.getSettings().setVerboseExceptions(false);
        this.getGeoServer().save(gs);
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = this.getDataStoreInfo(cat);
        DataStore store = (DataStore)ds.getDataStore(null);
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource("bar");
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        try (Connection conn = ((JDBCDataStore)store).getConnection(org.geotools.api.data.Transaction.AUTO_COMMIT);
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TRIGGER IF NOT EXISTS my_trigger BEFORE INSERT ON \"bar\" FOR EACH ROW CALL \"" + ExceptionThrowingTrigger.class.getName() + "\"");
            String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:gs='" + SystemTestData.DEFAULT_URI + "'><wfs:Insert idgen='UseExisting'> <gs:bar gml:id='1'>    <gs:name>acme</gs:name> </gs:bar></wfs:Insert></wfs:Transaction>";
            this.assertWfs10TransactionFailureContainsText(insert, "Unit test expected: Trigger is not happy with data conditions", false);
        }
        finally {
            this.dispose(cat, ds, store, ft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionalTransactionCauseInException() throws Exception {
        GeoServerInfo gs = this.getGeoServer().getGlobal();
        gs.getSettings().setVerboseExceptions(true);
        this.getGeoServer().save(gs);
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = this.getDataStoreInfo(cat);
        DataStore store = (DataStore)ds.getDataStore(null);
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource("bar");
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        try (Connection conn = ((JDBCDataStore)store).getConnection(org.geotools.api.data.Transaction.AUTO_COMMIT);
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TRIGGER IF NOT EXISTS my_trigger BEFORE INSERT ON \"bar\" FOR EACH ROW CALL \"" + ExceptionThrowingTrigger.class.getName() + "\"");
            String insert = "<wfs:Transaction service=\"WFS\" version=\"1.0.0\"  xmlns:wfs=\"http://www.opengis.net/wfs\"  xmlns:gml=\"http://www.opengis.net/gml\"  xmlns:gs='" + SystemTestData.DEFAULT_URI + "'><wfs:Insert idgen='UseExisting'> <gs:bar gml:id='1'>    <gs:name>acme</gs:name> </gs:bar></wfs:Insert></wfs:Transaction>";
            this.assertWfs10TransactionFailureContainsText(insert, "Unit test expected: Trigger is not happy with data conditions", true);
        }
        finally {
            this.dispose(cat, ds, store, ft);
        }
    }

    private void assertWfs10TransactionFailureContainsText(String wfsTransaction, String pattern, boolean expected) throws Exception {
        Document resp = this.postAsDOM("wfs", wfsTransaction);
        Assert.assertEquals((Object)"WFS_TransactionResponse", (Object)resp.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)resp.getElementsByTagName("wfs:FAILED").getLength());
        Assert.assertEquals((long)1L, (long)resp.getElementsByTagName("wfs:Message").getLength());
        String failureMessage = resp.getElementsByTagName("wfs:Message").item(0).getTextContent();
        if (expected) {
            Assert.assertTrue((boolean)failureMessage.contains(pattern));
        } else {
            Assert.assertFalse((boolean)failureMessage.contains(pattern));
        }
    }

    private DataStoreInfo getDataStoreInfo(Catalog cat) throws IOException {
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("foo");
        ds.setWorkspace(cat.getDefaultWorkspace());
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath());
        cat.add((StoreInfo)ds);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("bar");
        tb.add("name", String.class);
        tb.add("geom", Point.class);
        store.createSchema((FeatureType)tb.buildFeatureType());
        return ds;
    }

    private void dispose(Catalog cat, DataStoreInfo ds, DataStore store, FeatureTypeInfo ft) throws IOException {
        store.removeSchema(ft.getName());
        store.dispose();
        cat.remove((ResourceInfo)ft);
        cat.remove((StoreInfo)ds);
    }
}

