/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.wfs.UpdateElementHandler;
import org.geotools.geometry.jts.WKTReader2;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class UpdateElementHandlerTest {
    @Test
    public void testCheckConsistentGeometryDimensions() throws Exception {
        WKTReader2 wktReader = new WKTReader2();
        Geometry g = wktReader.read("POINT(0 0)");
        Assert.assertTrue((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Point.class));
        Assert.assertTrue((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, MultiPoint.class));
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, LineString.class));
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Polygon.class));
        g = wktReader.read("LINESTRING(0 0, 1 1)");
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Point.class));
        Assert.assertTrue((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, LineString.class));
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Polygon.class));
        g = wktReader.read("POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))");
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Point.class));
        Assert.assertFalse((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, LineString.class));
        Assert.assertTrue((boolean)UpdateElementHandler.checkConsistentGeometryDimensions((Geometry)g, Polygon.class));
    }
}

