/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import net.opengis.wfs20.ReplaceType;
import net.opengis.wfs20.TransactionType;
import net.opengis.wfs20.Wfs20Factory;
import org.easymock.EasyMock;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSWorkspaceQualifier;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.util.Version;
import org.junit.Before;
import org.junit.Test;

public class WFSWorkspaceQualifierTest {
    private static final String WORKSPACE_URI = "http://workspace/namespace";
    private Catalog mockCatalog = (Catalog)EasyMock.createMock(Catalog.class);
    private WorkspaceInfo mockWorkspaceInfo = (WorkspaceInfo)EasyMock.createMock(WorkspaceInfo.class);
    private NamespaceInfo mockNamespaceInfo = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
    private FeatureType mockFeatureType = (FeatureType)EasyMock.createMock(FeatureType.class);
    private Feature mockFeature = (Feature)EasyMock.createMock(Feature.class);
    private Name mockName = (Name)EasyMock.createMock(Name.class);
    private WFSWorkspaceQualifier sut = new WFSWorkspaceQualifier(this.mockCatalog);

    @Before
    public void setup() {
        String workspaceName = "workspacename";
        EasyMock.expect((Object)this.mockCatalog.getNamespaceByPrefix(workspaceName)).andReturn((Object)this.mockNamespaceInfo);
        EasyMock.expect((Object)this.mockWorkspaceInfo.getName()).andReturn((Object)workspaceName);
        EasyMock.expect((Object)this.mockNamespaceInfo.getURI()).andReturn((Object)WORKSPACE_URI);
        EasyMock.expect((Object)this.mockFeature.getType()).andReturn((Object)this.mockFeatureType);
        EasyMock.expect((Object)this.mockFeatureType.getName()).andReturn((Object)this.mockName);
    }

    @Test
    public void testQualifyRequestWithReplaceNamespaceValidationHavingMatchingNamespaces() {
        EasyMock.expect((Object)this.mockName.getNamespaceURI()).andReturn((Object)WORKSPACE_URI).anyTimes();
        this.invokeQualifyRequest();
    }

    @Test(expected=WFSException.class)
    public void testQualifyRequestWithReplaceNamespaceValidationHavingNonMatchingNamespaces() {
        EasyMock.expect((Object)this.mockName.getNamespaceURI()).andReturn((Object)"http://foo").anyTimes();
        this.invokeQualifyRequest();
    }

    private void invokeQualifyRequest() {
        TransactionType transactionType = Wfs20Factory.eINSTANCE.createTransactionType();
        ReplaceType replaceType = Wfs20Factory.eINSTANCE.createReplaceType();
        EList action = transactionType.getAbstractTransactionAction();
        action.add((Object)replaceType);
        replaceType.getAny().add((Object)this.mockFeature);
        Version version = new Version("2.0.0");
        Service service = new Service("id", (Object)"service", version, Collections.singletonList("Transaction"));
        Operation operation = new Operation("id", service, null, new Object[]{transactionType});
        EasyMock.replay((Object[])new Object[]{this.mockCatalog, this.mockFeature, this.mockFeatureType, this.mockName, this.mockNamespaceInfo, this.mockWorkspaceInfo});
        this.sut.qualifyRequest(this.mockWorkspaceInfo, null, operation, null);
    }
}

