/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wfs.json.ComplexGeoJsonWriter;
import org.geoserver.wfs.json.ComplexGeoJsonWriterOptions;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.identity.Identifier;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.junit.Assert;
import org.junit.Test;

public class ComplexGeoJsonWriterTest
extends GeoServerSystemTestSupport {
    private static final ComplexType MINENAMETYPE_TYPE = new FeatureTypeImpl(FakeTypes.Mine.NAME_MineNameType, (Collection)FakeTypes.Mine.MINENAMETYPE_SCHEMA, null, false, Collections.emptyList(), FakeTypes.ANYTYPE_TYPE, null);
    private static final AttributeDescriptor MINENAME_DESCRIPTOR = new AttributeDescriptorImpl((AttributeType)MINENAMETYPE_TYPE, FakeTypes.Mine.NAME_MineName, 1, 1, false, null);

    @Test
    public void testCheckIfFeatureIsLinkedNullSafeAttr() {
        ComplexAttribute property = this.generateTestComplexAttribute();
        boolean checkIfFeatureIsLinked = ComplexGeoJsonWriter.checkIfFeatureIsLinked((Property)property, null);
        Assert.assertFalse((boolean)checkIfFeatureIsLinked);
    }

    private ComplexAttribute generateTestComplexAttribute() {
        return new ComplexAttribute(){

            public void setValue(Object newValue) {
            }

            public boolean isNillable() {
                return false;
            }

            public Map<Object, Object> getUserData() {
                return null;
            }

            public Name getName() {
                return null;
            }

            public Identifier getIdentifier() {
                return null;
            }

            public AttributeDescriptor getDescriptor() {
                return null;
            }

            public void validate() throws IllegalAttributeException {
            }

            public void setValue(Collection<Property> values) {
            }

            public Collection<? extends Property> getValue() {
                return null;
            }

            public ComplexType getType() {
                return null;
            }

            public Property getProperty(String name) {
                return null;
            }

            public Property getProperty(Name name) {
                return null;
            }

            public Collection<Property> getProperties(String name) {
                Property prop = new Property(){

                    public void setValue(Object newValue) {
                    }

                    public boolean isNillable() {
                        return false;
                    }

                    public Object getValue() {
                        return null;
                    }

                    public Map<Object, Object> getUserData() {
                        return null;
                    }

                    public PropertyType getType() {
                        return null;
                    }

                    public Name getName() {
                        return null;
                    }

                    public PropertyDescriptor getDescriptor() {
                        return null;
                    }
                };
                ArrayList<Property> list = new ArrayList<Property>();
                list.add(prop);
                return list;
            }

            public Collection<Property> getProperties(Name name) {
                return null;
            }

            public Collection<Property> getProperties() {
                return null;
            }
        };
    }

    @Test
    public void testGeoJsonWriterOptions() {
        Feature f = this.buildComplexFeature();
        StringWriter w = new StringWriter();
        GeoJSONBuilder jWriter = new GeoJSONBuilder((Writer)w);
        TestComplexGeoJsonWriter testWriter = new TestComplexGeoJsonWriter(jWriter);
        testWriter.encodeFeature(f);
        JSONObject jsonF = (JSONObject)JSONSerializer.toJSON((Object)w.toString());
        JSONObject mineName = jsonF.getJSONObject("properties").getJSONObject("MineName");
        Assert.assertTrue((boolean)mineName.has("id"));
        Assert.assertTrue((boolean)mineName.has("geometry"));
        Assert.assertTrue((boolean)mineName.has("properties"));
        Assert.assertTrue((boolean)mineName.getJSONObject("properties").has("@featureType"));
    }

    @Test
    public void testGeoJsonWriterOptionsCustom() {
        ComplexGeoJsonWriterOptions options = new ComplexGeoJsonWriterOptions(){

            public boolean canHandle(List<FeatureCollection> features) {
                return true;
            }

            public boolean encodeComplexAttributeType() {
                return false;
            }

            public boolean encodeNestedFeatureAsProperty(ComplexType complexType) {
                return true;
            }
        };
        Feature f = this.buildComplexFeature();
        StringWriter w = new StringWriter();
        GeoJSONBuilder jWriter = new GeoJSONBuilder((Writer)w);
        TestComplexGeoJsonWriter testWriter = new TestComplexGeoJsonWriter(jWriter, options);
        testWriter.encodeFeature(f);
        JSONObject jsonF = (JSONObject)JSONSerializer.toJSON((Object)w.toString());
        JSONObject mineName = jsonF.getJSONObject("properties").getJSONObject("MineName");
        Assert.assertFalse((boolean)mineName.has("id"));
        Assert.assertFalse((boolean)mineName.has("geometry"));
        Assert.assertFalse((boolean)mineName.has("properties"));
        Assert.assertFalse((boolean)mineName.has("@dataType"));
    }

    private Feature buildComplexFeature() {
        ComplexFeatureBuilder fBuilder = new ComplexFeatureBuilder(FakeTypes.Mine.MINETYPE_TYPE);
        ComplexAttribute attr = ComplexGeoJsonWriterTest.getNestedFeature("a name", true);
        fBuilder.append(FakeTypes.Mine.NAME_mineName, (Property)attr);
        return fBuilder.buildFeature("id");
    }

    private static ComplexAttribute getNestedFeature(String name, boolean isPreferred) {
        ComplexFeatureBuilder complexFB = new ComplexFeatureBuilder(MINENAME_DESCRIPTOR);
        AttributeBuilder builder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
        builder.setDescriptor(FakeTypes.Mine.ISPREFERRED_DESCRIPTOR);
        Attribute isPrefAttr = builder.buildSimple("isPreferred_testId", (Object)isPreferred);
        builder.setDescriptor(FakeTypes.Mine.mineNAME_DESCRIPTOR);
        Attribute nameAttr = builder.buildSimple("mineName_testId", (Object)name);
        complexFB.append(FakeTypes.Mine.NAME_isPreferred, (Property)isPrefAttr);
        complexFB.append(FakeTypes.Mine.NAME_mineName, (Property)nameAttr);
        return complexFB.buildFeature(null);
    }

    class TestComplexGeoJsonWriter
    extends ComplexGeoJsonWriter {
        public TestComplexGeoJsonWriter(GeoJSONBuilder jsonWriter, ComplexGeoJsonWriterOptions settings) {
            super(jsonWriter, settings);
        }

        public TestComplexGeoJsonWriter(GeoJSONBuilder jsonWriter) {
            super(jsonWriter);
        }

        public void encodeFeature(Feature feature) {
            super.encodeFeature(feature, true);
        }
    }
}

