/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import java.util.HashMap;
import org.geoserver.wfs.json.JSONType;
import org.junit.Assert;
import org.junit.Test;

public class JSONTypeTest {
    @Test
    public void testMimeType() {
        Assert.assertNotSame((Object)"application/json", (Object)"text/javascript");
        Assert.assertTrue((boolean)JSONType.isJsonMimeType((String)"application/json"));
        JSONType.setJsonpEnabled((boolean)true);
        Assert.assertTrue((boolean)JSONType.useJsonp((String)"text/javascript"));
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertFalse((boolean)JSONType.useJsonp((String)"text/javascript"));
    }

    @Test
    public void testJSONType() {
        JSONType json = JSONType.JSON;
        Assert.assertEquals((Object)JSONType.JSON, (Object)json);
        JSONType jsonp = JSONType.JSONP;
        Assert.assertEquals((Object)JSONType.JSONP, (Object)jsonp);
        Assert.assertEquals((Object)JSONType.JSON, (Object)JSONType.getJSONType((String)"application/json"));
        Assert.assertEquals((Object)JSONType.JSONP, (Object)JSONType.getJSONType((String)"text/javascript"));
    }

    @Test
    public void testCallbackFunction() {
        HashMap kvp = new HashMap();
        Assert.assertEquals((Object)"parseResponse", (Object)JSONType.getCallbackFunction(kvp));
        HashMap<String, String> formatOpts = new HashMap<String, String>();
        kvp.put("FORMAT_OPTIONS", formatOpts);
        Assert.assertEquals((Object)"parseResponse", (Object)JSONType.getCallbackFunction(kvp));
        formatOpts.put("callback", "functionName");
        Assert.assertEquals((Object)"functionName", (Object)JSONType.getCallbackFunction(kvp));
    }
}

