/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.net.URLDecoder;
import java.util.List;
import org.geoserver.wfs.kvp.Filter_1_0_0_KvpParser;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.junit.Assert;
import org.junit.Test;

public class Filter_1_0_0_KvpParserTest {
    @Test
    public void test() throws Exception {
        String filter = "%3Cogc%3AFilter+xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22+xmlns%3Acdf%3D%22http%3A%2F%2Fwww.opengis.net%2Fcite%2Fdata%22%3E%3Cogc%3APropertyIsEqualTo%3E%3Cogc%3APropertyName%3Ecdf%3Aintegers%3C%2Fogc%3APropertyName%3E%3Cogc%3AAdd%3E%3Cogc%3ALiteral%3E4%3C%2Fogc%3ALiteral%3E%3Cogc%3ALiteral%3E3%3C%2Fogc%3ALiteral%3E%3C%2Fogc%3AAdd%3E%3C%2Fogc%3APropertyIsEqualTo%3E%3C%2Fogc%3AFilter%3E";
        filter = URLDecoder.decode(filter, "UTF-8");
        List filters = (List)new Filter_1_0_0_KvpParser(null).parse(filter);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)1L, (long)filters.size());
        Filter f = (Filter)filters.get(0);
        Assert.assertTrue((boolean)(f instanceof PropertyIsEqualTo));
    }

    @Test
    public void testMultiFilter() throws Exception {
        String filter = "(%3CFilter%20xmlns=%22http://www.opengis.net/ogc%22%3E%3CFeatureId%20fid=%22states.3%22/%3E%3C/Filter%3E)(%3CFilter%20xmlns=%22http://www.opengis.net/ogc%22%3E%3CFeatureId%20fid=%22tiger_roads.3%22/%3E%3C/Filter%3E)";
        filter = URLDecoder.decode(filter, "UTF-8");
        List filters = (List)new Filter_1_0_0_KvpParser(null).parse(filter);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)2L, (long)filters.size());
        Filter f1 = (Filter)filters.get(0);
        Assert.assertTrue((boolean)(f1 instanceof Id));
        String fid = (String)((Id)f1).getIDs().iterator().next();
        Assert.assertEquals((Object)"states.3", (Object)fid);
        Filter f2 = (Filter)filters.get(1);
        Assert.assertTrue((boolean)(f2 instanceof Id));
        fid = (String)((Id)f2).getIDs().iterator().next();
        Assert.assertEquals((Object)"tiger_roads.3", (Object)fid);
    }

    @Test
    public void testEmptyAndNonEmptyFilter() throws Exception {
        String param = "()(%3CFilter%20xmlns=%22http://www.opengis.net/ogc%22%3E%3CFeatureId%20fid=%22roads.3%22/%3E%3C/Filter%3E)";
        param = URLDecoder.decode(param, "UTF-8");
        List filters = (List)new Filter_1_0_0_KvpParser(null).parse(param);
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)2L, (long)filters.size());
        Filter empty = (Filter)filters.get(0);
        Filter fid = (Filter)filters.get(1);
        Assert.assertNotNull((Object)empty);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)empty);
        Assert.assertNotNull((Object)fid);
        Assert.assertTrue((boolean)(fid instanceof Id));
    }
}

