/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class LockFeatureTest
extends WFSTestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        Service service = (Service)GeoServerExtensions.bean((String)"wfsService-1.1.0");
        service.getOperations().add("ReleaseLock");
    }

    @Test
    public void testLock() throws Exception {
        String xml = "<wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" expiry=\"5\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"1.1.0\"><wfs:Lock handle=\"lock-1\" typeName=\"sf:PrimitiveGeoFeature\"/></wfs:LockFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)5L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "FeatureId").getLength());
        this.releaseLock(dom);
    }

    @Test
    public void testLockGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=LockFeature&typename=sf:GenericEntity", 200);
        this.print(dom);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "FeatureId").getLength());
        this.releaseLock(dom);
    }

    @Test
    public void testLockWithNamespacesGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=LockFeature&typename=ns53:GenericEntity&namespace=xmlns(ns53=http://cite.opengeospatial.org/gmlsf)", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "FeatureId").getLength());
        this.releaseLock(dom);
    }

    public void releaseLock(Document dom) throws Exception {
        String lockId = XMLUnit.newXpathEngine().evaluate("//wfs:LockId", dom);
        this.get("wfs?request=ReleaseLock&version=1.1.0&lockId=" + lockId);
    }

    @Test
    public void testLockByBBOX() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=1.1.0&request=LockFeature&typeName=sf:PrimitiveGeoFeature&BBOX=57.0,-4.5,62.0,1.0,EPSG:4326", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/ogc", "FeatureId").getLength());
        this.releaseLock(dom);
    }
}

