/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.Serializable;
import java.net.URL;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.NullProgressListener;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.NameImpl;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.util.decorate.Wrapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class WfsRemoteStoreTest
extends WFSTestSupport {
    public MockHttpClient httpClient = new MockHttpClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoteWfsLayer20() throws Exception {
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?NAMESPACE=xmlns%28topp%3Dhttp%3A%2F%2Fwww.topp.com%29&TYPENAME=topp%3Aroads22&REQUEST=DescribeFeatureType&VERSION=1.1.0&SERVICE=WFS", "desc_feature.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?REQUEST=DescribeFeatureType&VERSION=1.1.0&SERVICE=WFS", "desc_110.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?PROPERTYNAME=the_geom%2Ccat%2Clabel&FILTER=%3Cogc%3AFilter+xmlns%3Axs%3D%22http%3A%2F%2Fwww.w3.org%2F2001%2FXMLSchema%22+xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22+xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%3Cogc%3ABBOX%3E%3Cogc%3APropertyName%2F%3E%3Cgml%3AEnvelope+srsDimension%3D%222%22+srsName%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2Fsrs%2Fepsg.xml%234326%22%3E%3Cgml%3AlowerCorner%3E-103.73937+43.47669%3C%2Fgml%3AlowerCorner%3E%3Cgml%3AupperCorner%3E-102.739377+44.47536%3C%2Fgml%3AupperCorner%3E%3C%2Fgml%3AEnvelope%3E%3C%2Fogc%3ABBOX%3E%3C%2Fogc%3AFilter%3E&TYPENAME=topp%3Aroads22&REQUEST=GetFeature&RESULTTYPE=HITS&OUTPUTFORMAT=text%2Fxml%3B+subtype%3Dgml%2F3.1.1&SRSNAME=EPSG%3A4326&VERSION=1.1.0&MAXFEATURES=10&SERVICE=WFS", "wfs_response_4326.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?PROPERTYNAME=the_geom%2Ccat%2Clabel&FILTER=%3Cogc%3AFilter+xmlns%3Axs%3D%22http%3A%2F%2Fwww.w3.org%2F2001%2FXMLSchema%22+xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22+xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%3Cogc%3ABBOX%3E%3Cogc%3APropertyName%2F%3E%3Cgml%3AEnvelope+srsDimension%3D%222%22+srsName%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2Fsrs%2Fepsg.xml%234326%22%3E%3Cgml%3AlowerCorner%3E-103.73937+43.47669%3C%2Fgml%3AlowerCorner%3E%3Cgml%3AupperCorner%3E-102.739377+44.47536%3C%2Fgml%3AupperCorner%3E%3C%2Fgml%3AEnvelope%3E%3C%2Fogc%3ABBOX%3E%3C%2Fogc%3AFilter%3E&TYPENAME=topp%3Aroads22&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=text%2Fxml%3B+subtype%3Dgml%2F3.1.1&SRSNAME=EPSG%3A4326&VERSION=1.1.0&MAXFEATURES=10&SERVICE=WFS", "wfs_response_4326.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?PROPERTYNAME=the_geom&FILTER=%3Cogc%3AFilter+xmlns%3Axs%3D%22http%3A%2F%2Fwww.w3.org%2F2001%2FXMLSchema%22+xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22+xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%3Cogc%3ABBOX%3E%3Cogc%3APropertyName%2F%3E%3Cgml%3AEnvelope+srsDimension%3D%222%22+srsName%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2Fsrs%2Fepsg.xml%234326%22%3E%3Cgml%3AlowerCorner%3E-103.73937+43.47669%3C%2Fgml%3AlowerCorner%3E%3Cgml%3AupperCorner%3E-102.739377+44.47536%3C%2Fgml%3AupperCorner%3E%3C%2Fgml%3AEnvelope%3E%3C%2Fogc%3ABBOX%3E%3C%2Fogc%3AFilter%3E&TYPENAME=topp%3Aroads22&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=text%2Fxml%3B+subtype%3Dgml%2F3.1.1&SRSNAME=EPSG%3A4326&VERSION=1.1.0&MAXFEATURES=10&SERVICE=WFS", "wfs_response_4326.xml");
        WfsRemoteStoreTest.registerHttpGetFromResource(this.httpClient, "/wfs?PROPERTYNAME=the_geom&FILTER=%3Cogc%3AFilter+xmlns%3Axs%3D%22http%3A%2F%2Fwww.w3.org%2F2001%2FXMLSchema%22+xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%22+xmlns%3Aogc%3D%22http%3A%2F%2Fwww.opengis.net%2Fogc%22%3E%3Cogc%3ABBOX%3E%3Cogc%3APropertyName%2F%3E%3Cgml%3AEnvelope+srsDimension%3D%222%22+srsName%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2Fsrs%2Fepsg.xml%233857%22%3E%3Cgml%3AlowerCorner%3E-1.15482138436E7+5384812.69673%3C%2Fgml%3AlowerCorner%3E%3Cgml%3AupperCorner%3E-1.14368951321E7+5539302.36519%3C%2Fgml%3AupperCorner%3E%3C%2Fgml%3AEnvelope%3E%3C%2Fogc%3ABBOX%3E%3C%2Fogc%3AFilter%3E&TYPENAME=topp%3Aroads22&REQUEST=GetFeature&RESULTTYPE=RESULTS&OUTPUTFORMAT=text%2Fxml%3B+subtype%3Dgml%2F3.1.1&SRSNAME=EPSG%3A3857&VERSION=1.1.0&MAXFEATURES=10&SERVICE=WFS", "wfs_response_4326.xml");
        try {
            DataStoreInfo storeInfo = WfsRemoteStoreTest.createWfsDataStore(this.getCatalog(), "RemoteWfsStore", "wfs_cap_110.xml");
            DataAccess dataStore = storeInfo.getDataStore((ProgressListener)new NullProgressListener());
            WFSDataStore wfsDatStore = WfsRemoteStoreTest.extractWfsDataStore(dataStore);
            wfsDatStore.getWfsClient().setHttpClient((HTTPClient)this.httpClient);
            WfsRemoteStoreTest.createWfsRemoteLayer(this.getCatalog(), storeInfo, "topp_roads22");
            MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gs:topp_roads22&srsName=EPSG:4326&bbox=-103.73937,43.47669,-102.739377,44.47536,EPSG:4326&maxFeatures=10");
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContentAsString();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.notNullValue());
            MockHttpServletResponse responseURNOGC = this.getAsServletResponse("wfs?service=WFS&version=1.1.0&request=GetFeature&typeName=gs:topp_roads22&srsName=EPSG:3857&bbox=-11548213.8436,5384812.69673,-11436895.1321,5539302.36519&maxFeatures=10");
            MatcherAssert.assertThat((Object)responseURNOGC.getStatus(), (Matcher)Matchers.is((Object)200));
            content = responseURNOGC.getContentAsString();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.notNullValue());
        }
        finally {
            DataStoreInfo dataStoreInfo = (DataStoreInfo)this.getCatalog().getStoreByName("RemoteWfsStore", DataStoreInfo.class);
            if (dataStoreInfo != null) {
                CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(this.getCatalog());
                dataStoreInfo.accept((CatalogVisitor)visitor);
            }
        }
    }

    private static LayerInfo createWfsRemoteLayer(Catalog catalog, DataStoreInfo storeInfo, String name) throws Exception {
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        catalogBuilder.setStore((StoreInfo)storeInfo);
        FeatureTypeInfo featureTypeInfo = catalogBuilder.buildFeatureType((Name)new NameImpl("", name));
        featureTypeInfo.getMetadata().put("OTHER_SRS", (Serializable)((Object)"EPSG:4326,urn:ogc:def:crs:EPSG::3857"));
        catalog.add((ResourceInfo)featureTypeInfo);
        LayerInfo layerInfo = catalogBuilder.buildLayer(featureTypeInfo);
        catalog.add(layerInfo);
        layerInfo = catalog.getLayerByName(name);
        MatcherAssert.assertThat((Object)layerInfo, (Matcher)Matchers.notNullValue());
        return layerInfo;
    }

    private static DataStoreInfo createWfsDataStore(Catalog catalog, String name, String capabilitiesDocument) {
        URL url = WfsRemoteStoreTest.class.getResource(capabilitiesDocument);
        MatcherAssert.assertThat((Object)url, (Matcher)Matchers.notNullValue());
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        DataStoreInfo storeInfo = catalogBuilder.buildDataStore(name);
        storeInfo.setType("Web Feature Server (NG)");
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE);
        storeInfo.getConnectionParameters().put("TESTING", Boolean.TRUE);
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.USEDEFAULTSRS.key, Boolean.FALSE);
        catalog.add((StoreInfo)storeInfo);
        storeInfo = (DataStoreInfo)catalog.getStoreByName(name, DataStoreInfo.class);
        MatcherAssert.assertThat((Object)storeInfo, (Matcher)Matchers.notNullValue());
        return storeInfo;
    }

    private static void registerHttpGetFromResource(MockHttpClient httpClient, String url, String resourceName) throws Exception {
        URL finalUrl = new URL("http://mock.test.geoserver.org" + url);
        URL resourceUrl = WfsRemoteStoreTest.class.getResource(resourceName);
        MatcherAssert.assertThat((Object)resourceUrl, (Matcher)Matchers.notNullValue());
        httpClient.expectGet(finalUrl, (HTTPResponse)new MockHttpResponse(resourceUrl, "text/xml", new String[0]));
    }

    private static WFSDataStore extractWfsDataStore(DataAccess dataStore) {
        MatcherAssert.assertThat((Object)dataStore, (Matcher)Matchers.notNullValue());
        if (dataStore instanceof Wrapper) {
            return (WFSDataStore)((Wrapper)dataStore).unwrap(WFSDataStore.class);
        }
        MatcherAssert.assertThat((Object)dataStore, (Matcher)Matchers.instanceOf(WFSDataStore.class));
        return (WFSDataStore)dataStore;
    }
}

