/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetFeatureCurvesTest
extends WFS20TestSupport {
    QName CURVELINES = new QName(MockData.CITE_URI, "curvelines", MockData.CITE_PREFIX);
    QName CURVEMULTILINES = new QName(MockData.CITE_URI, "curvemultilines", MockData.CITE_PREFIX);
    QName CURVEPOLYGONS = new QName(MockData.CITE_URI, "curvepolygons", MockData.CITE_PREFIX);
    XpathEngine xpath;

    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        super.setUpInternal(testData);
        testData.addWorkspace(MockData.CITE_PREFIX, MockData.CITE_URI, this.getCatalog());
        testData.addVectorLayer(this.CURVELINES, Collections.emptyMap(), "curvelines.properties", MockData.class, this.getCatalog());
        testData.addVectorLayer(this.CURVEMULTILINES, Collections.emptyMap(), "curvemultilines.properties", MockData.class, this.getCatalog());
        testData.addVectorLayer(this.CURVEPOLYGONS, Collections.emptyMap(), "curvepolygons.properties", MockData.class, this.getCatalog());
        FeatureTypeInfo curveLines = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.CURVELINES));
        curveLines.setCircularArcPresent(true);
        curveLines.setLinearizationTolerance(null);
        this.getCatalog().save((ResourceInfo)curveLines);
        FeatureTypeInfo curveMultiLines = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.CURVEMULTILINES));
        curveMultiLines.setCircularArcPresent(true);
        curveMultiLines.setLinearizationTolerance(null);
        this.getCatalog().save((ResourceInfo)curveMultiLines);
    }

    @Before
    public void setXPath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    private int countCoordinates(Document dom, XpathEngine xpath, String path) throws XpathException {
        String coords = xpath.evaluate(path, dom);
        int coordCount = coords.split("\\s+").length;
        return coordCount;
    }

    @Test
    public void testCurveLine() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=2.0&request=GetFeature&typeName=" + this.getLayerId(this.CURVELINES));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:LineStringSegment)", dom));
        Assert.assertEquals((long)8L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.1']/cite:geom/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.2']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.2']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvelines[@gml:id='cp.3']/cite:geom/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((long)10L, (long)this.countCoordinates(dom, this.xpath, "//cite:curvelines[@gml:id='cp.3']/cite:geom/gml:Curve/gml:segments/gml:ArcString/gml:posList"));
    }

    @Test
    public void testCurveMultiLine() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=2.0&request=GetFeature&typeName=" + this.getLayerId(this.CURVEMULTILINES) + "&featureid=cp.1");
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:LineString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//cite:curvemultilines[@gml:id='cp.1']/cite:geom/gml:MultiCurve/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom));
    }

    @Test
    public void testCurvePolygons() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=2.0&request=GetFeature&typeName=" + this.getLayerId(this.CURVEPOLYGONS) + "&featureid=cp.1");
        this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:exterior/gml:Ring/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom);
        this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:exterior/gml:Ring/gml:curveMember/gml:LineString)", dom);
        this.xpath.evaluate("count(//cite:curvepolygons[@gml:id='cp.1']/cite:geom/gml:Polygon/gml:interior/gml:Ring/gml:curveMember/gml:Curve/gml:segments/gml:ArcString)", dom);
    }
}

