/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LockFeatureTest
extends WFS20TestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        this.getServiceDescriptor20().getOperations().add("ReleaseLock");
    }

    @Test
    public void testLock() throws Exception {
        String xml = "<wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"    xmlns:wfs='http://www.opengis.net/wfs/2.0' expiry=\"5\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"2.0.0\"><wfs:Query handle=\"lock-1\" typeNames=\"sf:PrimitiveGeoFeature\"/></wfs:LockFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)5L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testSOAP() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"    xmlns:wfs='http://www.opengis.net/wfs/2.0' expiry=\"5\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"2.0.0\"><wfs:Query handle=\"lock-1\" typeNames=\"sf:PrimitiveGeoFeature\"/></wfs:LockFeature> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:LockFeatureResponse").getLength());
        String lockId = XMLUnit.newXpathEngine().evaluate("//wfs:LockFeatureResponse/@lockId", dom);
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenewLockFail() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            Object xml = "<wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"    xmlns:wfs='http://www.opengis.net/wfs/2.0' expiry=\"1\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"2.0.0\"><wfs:Query handle=\"lock-1\" typeNames=\"sf:PrimitiveGeoFeature\"/></wfs:LockFeature>";
            Document dom = this.postAsDOM("wfs", (String)xml);
            this.print(dom);
            Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
            Assert.assertEquals((long)5L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
            String lockId = XMLUnit.newXpathEngine().evaluate("//wfs:LockFeatureResponse/@lockId", dom);
            Thread.sleep(2000L);
            xml = "<wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"    xmlns:wfs='http://www.opengis.net/wfs/2.0' expiry=\"1\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"2.0.0\" lockId=\"" + lockId + "\"/>";
            MockHttpServletResponse response = this.postAsServletResponse("wfs", (String)xml);
            Assert.assertEquals((long)403L, (long)response.getStatus());
            dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
            this.checkOws11Exception(dom, "2.0.0", "LockHasExpired", "lockId");
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testRenewUnknownLock() throws Exception {
        String xml = "<wfs:LockFeature xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\"    xmlns:wfs='http://www.opengis.net/wfs/2.0' expiry=\"1\" handle=\"LockFeature-tc1\"  lockAction=\"ALL\"  service=\"WFS\"  version=\"2.0.0\" lockId=\"abcd\"/>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        this.checkOws11Exception(dom, "2.0.0", "InvalidLockId", "lockId");
    }

    @Test
    public void testLockWithStoredQuery() throws Exception {
        this.lockWithStoredQuery("wfs");
    }

    @Test
    public void testLockWithStoredQueryWorkspaceSpecific() throws Exception {
        this.lockWithStoredQuery("sf/wfs");
    }

    public void lockWithStoredQuery(String path) throws Exception {
        String xml = "<wfs:LockFeature xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" expiry=\"1\" service=\"WFS\"\n                 version=\"2.0.0\">\n   <wfs:StoredQuery id=\"urn:ogc:def:query:OGC-WFS::GetFeatureById\">\n      <wfs:Parameter name=\"id\">AggregateGeoFeature.f005</wfs:Parameter>\n   </wfs:StoredQuery>\n</wfs:LockFeature>";
        Document dom = this.postAsDOM(path, xml);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get(path + "?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testLockGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&typenames=sf:GenericEntity", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testLockWithNamespacesGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&typenames=ns53:GenericEntity&namespaces=xmlns(ns53,http://cite.opengeospatial.org/gmlsf)", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testLockWithStoredQueryGet() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&storedQueryId=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeature.f001", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testLockByBBOX() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&typeName=sf:PrimitiveGeoFeature&BBOX=57.0,-4.5,62.0,1.0,EPSG:4326", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }

    @Test
    public void testFailLockAll() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&storedQueryId=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeature.f001", 200);
        Assert.assertEquals((Object)"wfs:LockFeatureResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/fes/2.0", "ResourceId").getLength());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=LockFeature&typeNames=sf:PrimitiveGeoFeature", 400);
        this.checkOws11Exception(dom, "2.0.0", "CannotLockAllFeatures", "GeoServer");
        this.get("wfs?request=ReleaseLock&version=2.0&lockId=" + lockId);
    }
}

