/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class SrsNameTest
extends WFS20TestSupport {
    @Test
    public void testSrsNameSyntax() throws Exception {
        this.doTestSrsNameSyntax(GMLInfo.SrsNameStyle.URN2, false);
        this.doTestSrsNameSyntax(GMLInfo.SrsNameStyle.URN, true);
        this.doTestSrsNameSyntax(GMLInfo.SrsNameStyle.URL, true);
        this.doTestSrsNameSyntax(GMLInfo.SrsNameStyle.NORMAL, true);
        this.doTestSrsNameSyntax(GMLInfo.SrsNameStyle.XML, true);
    }

    void doTestSrsNameSyntax(GMLInfo.SrsNameStyle srsNameStyle, boolean doSave) throws Exception {
        if (doSave) {
            WFSInfo wfs = this.getWFS();
            GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_20);
            gml.setSrsNameStyle(srsNameStyle);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
        String q = "wfs?request=getfeature&service=wfs&version=2.0.0&typenames=cgf:Points";
        Document d = this.getAsDOM(q);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)d.getDocumentElement().getNodeName());
        String identifier = srsNameStyle.toSrsSyntax().getSRS("EPSG:32615");
        XMLAssert.assertXpathExists((String)("//gml:Envelope[@srsName = '" + identifier + "']"), (Document)d);
        XMLAssert.assertXpathExists((String)("//gml:Point[@srsName = '" + identifier + "']"), (Document)d);
    }
}

