/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class GMLOutputFormatTest
extends WFSTestSupport {
    private static final QName INVALID_CHARACTER = new QName(MockData.DEFAULT_URI, "invalid_character", MockData.DEFAULT_PREFIX);
    private static final QName INVALID_NAMESPACE = new QName("http://www.w3.org/1999/xhtml", "invalid_namespace", "xhtml");
    private static final QName INVALID_PREFIX = new QName("http://invalid/prefix", "BasicPolygons", "'");
    private int defaultNumDecimals = -1;
    private boolean defaultForceDecimal = false;
    private boolean defaultPadWithZeros = false;

    @Before
    public void saveDefaultFormattingOptions() {
        if (this.defaultNumDecimals < 0) {
            FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
            this.defaultNumDecimals = info.getNumDecimals();
            this.defaultForceDecimal = info.getForcedDecimal();
            this.defaultPadWithZeros = info.getPadWithZeros();
        }
    }

    @After
    public void restoreDefaultFormattingOptions() {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
        info.setNumDecimals(this.defaultNumDecimals);
        info.setForcedDecimal(this.defaultForceDecimal);
        info.setPadWithZeros(this.defaultPadWithZeros);
    }

    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        super.setUpInternal(testData);
        testData.addVectorLayer(INVALID_CHARACTER, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addWorkspace(INVALID_NAMESPACE.getPrefix(), INVALID_NAMESPACE.getNamespaceURI(), this.getCatalog());
        testData.addVectorLayer(INVALID_NAMESPACE, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addWorkspace(INVALID_PREFIX.getPrefix(), INVALID_PREFIX.getNamespaceURI(), this.getCatalog());
        testData.addVectorLayer(INVALID_PREFIX, Collections.emptyMap(), MockData.class, this.getCatalog());
    }

    @Test
    public void testGML2() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=text/xml; subtype%3Dgml/2.1.2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=text/xml; subtype%3Dgml/2.1.2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
    }

    @Test
    public void testGML2CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"-2.0000,-1.0000 2.0000,6.0000", (Object)dom.getElementsByTagName("gml:coordinates").item(0).getTextContent());
    }

    private void enableCoordinatesFormatting() {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
        info.setNumDecimals(4);
        info.setForcedDecimal(true);
        info.setPadWithZeros(true);
        this.getGeoServer().getCatalog().save((ResourceInfo)info);
    }

    @Test
    public void testGML2GZIP() throws Exception {
    }

    @Test
    public void testGML3() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=text/xml; subtype%3Dgml/3.1.1&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=text/xml; subtype%3Dgml/3.1.1&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
    }

    @Test
    public void testGML3CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"-1.0000 0.0000 0.0000 1.0000 1.0000 0.0000 0.0000 -1.0000 -1.0000 0.0000", (Object)dom.getElementsByTagName("gml:posList").item(0).getTextContent());
    }

    @Test
    public void testGML32() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=2.0.0&outputFormat=gml32&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"http://www.opengis.net/wfs/2.0", (Object)dom.getDocumentElement().getNamespaceURI());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
    }

    @Test
    public void testGML32CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=2.0.0&outputFormat=gml32&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"0.0000 -1.0000 1.0000 0.0000 0.0000 1.0000 -1.0000 0.0000 0.0000 -1.0000", (Object)dom.getElementsByTagName("gml:posList").item(0).getTextContent());
    }

    @Test
    public void testGML2InvalidElementName() throws Exception {
        this.testInvalidResponse(INVALID_CHARACTER, 2, "INVALID_CHARACTER_ERR");
    }

    @Test
    public void testGML2InvalidNamespaceUri() throws Exception {
        this.testInvalidResponse(INVALID_NAMESPACE, 2, "NAMESPACE_ERR");
    }

    @Test
    public void testGML2InvalidNamespacePrefix() throws Exception {
        this.testInvalidResponse(INVALID_PREFIX, 2, "INVALID_CHARACTER_ERR");
    }

    @Test
    public void testGML3InvalidElementName() throws Exception {
        this.testInvalidResponse(INVALID_CHARACTER, 3, "INVALID_CHARACTER_ERR");
    }

    @Test
    public void testGML3InvalidNamespaceUri() throws Exception {
        this.testInvalidResponse(INVALID_NAMESPACE, 3, "NAMESPACE_ERR");
    }

    @Test
    public void testGML3InvalidNamespacePrefix() throws Exception {
        this.testInvalidResponse(INVALID_PREFIX, 3, "INVALID_CHARACTER_ERR");
    }

    @Test
    public void testGML32InvalidElementName() throws Exception {
        this.testInvalidResponse(INVALID_CHARACTER, 32, "INVALID_CHARACTER_ERR");
    }

    @Test
    public void testGML32InvalidNamespaceUri() throws Exception {
        this.testInvalidResponse(INVALID_NAMESPACE, 32, "NAMESPACE_ERR");
    }

    @Test
    public void testGML32InvalidNamespacePrefix() throws Exception {
        this.testInvalidResponse(INVALID_PREFIX, 32, "INVALID_CHARACTER_ERR");
    }

    private void testInvalidResponse(QName layer, int version, String message) throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml" + version + "&typename=" + layer.getPrefix() + ":" + layer.getLocalPart());
        XMLAssert.assertXpathValuesEqual((String)"1", (String)"count(/ogc:ServiceExceptionReport/ogc:ServiceException)", (Document)dom);
        String text = dom.getElementsByTagName("ServiceException").item(0).getTextContent();
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.containsString((String)message));
    }
}

