/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.outputformat;

import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geotools.util.logging.Logging;

public class WFSOutputFormatCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(WFSOutputFormatCallback.class);
    private final GeoServer geoserver;
    private static final String WFS = "wfs";
    private static final String GET_FEATURE = "GetFeature";
    private static final String GET_FEATURE_WITH_LOCK = "GetFeatureWithLock";
    public static final String INVALID_PARAMETER_VALUE = "InvalidParameterValue";

    public WFSOutputFormatCallback(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        Service service = operation.getService();
        if (service == null || !WFS.equalsIgnoreCase(service.getId()) || !request.getRequest().equalsIgnoreCase(GET_FEATURE) && !request.getRequest().equalsIgnoreCase(GET_FEATURE_WITH_LOCK)) {
            return operation;
        }
        WFSInfo wfs = (WFSInfo)this.geoserver.getService(WFSInfo.class);
        if (!wfs.isGetFeatureOutputTypeCheckingEnabled()) {
            return operation;
        }
        String outputFormat = request.getOutputFormat();
        if (outputFormat != null && wfs.getGetFeatureOutputTypes() != null && !wfs.getGetFeatureOutputTypes().contains(outputFormat)) {
            LOGGER.fine("Output Format " + outputFormat + " is not enabled for GetFeature due to Global WFS settings");
            throw this.InvalidParameterException(outputFormat);
        }
        return operation;
    }

    public ServiceException InvalidParameterException(String outputFormat) {
        ServiceException e = new ServiceException("Invalid Output Format Parameter " + outputFormat, INVALID_PARAMETER_VALUE);
        return e;
    }
}

