/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.ResultTypeType;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.WFSResponse;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geotools.feature.FeatureIterator;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public class HitsOutputFormat
extends WFSResponse {
    Configuration configuration;

    public HitsOutputFormat(GeoServer gs, Configuration configuration) {
        super(gs, FeatureCollectionResponse.class);
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (operation.getService().getVersion().toString().equals("1.1.0")) {
            return "text/xml; subtype=gml/3.1.1";
        }
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        return request != null && request.getResultType() == ResultTypeType.HITS_LITERAL;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        WFSInfo wfs = this.getInfo();
        FeatureCollectionResponse featureCollection = (FeatureCollectionResponse)value;
        FeatureCollectionResponse hits = featureCollection.create();
        if (GML3OutputFormat.isComplexFeature(featureCollection)) {
            hits.setNumberOfFeatures(this.countFeature(featureCollection));
        } else {
            hits.setNumberOfFeatures(featureCollection.getNumberOfFeatures());
        }
        hits.setTotalNumberOfFeatures(featureCollection.getTotalNumberOfFeatures());
        hits.setNext(featureCollection.getNext());
        hits.setPrevious(featureCollection.getPrevious());
        hits.setTimeStamp(featureCollection.getTimeStamp());
        this.encode(hits, output, wfs);
    }

    private BigInteger countFeature(FeatureCollectionResponse fct) {
        BigInteger count = BigInteger.valueOf(0L);
        for (int fcIndex = 0; fcIndex < fct.getFeature().size(); ++fcIndex) {
            try (FeatureIterator i = fct.getFeature().get(fcIndex).features();){
                while (i.hasNext()) {
                    count = count.add(BigInteger.ONE);
                    i.next();
                }
                continue;
            }
        }
        return count;
    }

    protected void encode(FeatureCollectionResponse hits, OutputStream output, WFSInfo wfs) throws IOException {
        XSDSchema result;
        try {
            result = this.configuration.getXSD().getSchema();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Encoder encoder = new Encoder(this.configuration, result);
        encoder.setEncoding(Charset.forName(wfs.getGeoServer().getSettings().getCharset()));
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String[])new String[]{wfs.getSchemaBaseURL(), "wfs/1.1.0/wfs.xsd"}));
        encoder.encode((Object)hits.getAdaptee(), WFS.FEATURECOLLECTION, output);
    }
}

