/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.template.TemplateUtils;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDumper;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.wfs.v1_1.WFS;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.xsd.Encoder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ShapeZipOutputFormat
extends WFSGetFeatureOutputFormat
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(ShapeZipOutputFormat.class);
    public static final String GS_SHAPEFILE_CHARSET = "GS-SHAPEFILE-CHARSET";
    public static final String SHAPE_ZIP_DEFAULT_PRJ_IS_ESRI = "SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI";
    private static final Configuration templateConfig = TemplateUtils.getSafeConfiguration(null, null, (Integer)3);
    private ApplicationContext applicationContext;
    private Catalog catalog;
    private GeoServerResourceLoader resourceLoader;
    private long maxShpSize = Long.getLong("GS_SHP_MAX_SIZE", Integer.MAX_VALUE);
    private long maxDbfSize = Long.getLong("GS_DBF_MAX_SIZE", Integer.MAX_VALUE);

    public ShapeZipOutputFormat(GeoServer gs, Catalog catalog, GeoServerResourceLoader resourceLoader) {
        super(gs, "SHAPE-ZIP");
        this.catalog = catalog;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/zip";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "SHAPE-ZIP";
    }

    @Override
    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    @Override
    public String getAttachmentFileName(Object value, Operation operation) {
        SimpleFeatureCollection fc = (SimpleFeatureCollection)((FeatureCollectionResponse)value).getFeature().get(0);
        FeatureTypeInfo ftInfo = this.getFeatureTypeInfo((SimpleFeatureType)fc.getSchema());
        String filename = null;
        GetFeatureRequest request = GetFeatureRequest.adapt(operation.getParameters()[0]);
        if (request != null) {
            Map<String, Object> formatOptions = request.getFormatOptions();
            filename = (String)formatOptions.get("FILENAME");
        }
        if (filename == null) {
            filename = new FileNameSource(((Object)((Object)this)).getClass()).getZipName(ftInfo);
        }
        if (filename == null) {
            filename = ftInfo.getName();
        }
        return filename + (filename.endsWith(".zip") ? "" : ".zip");
    }

    @Override
    public void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        ArrayList<SimpleFeatureCollection> collections = new ArrayList<SimpleFeatureCollection>();
        List<FeatureCollection> features = featureCollection.getFeature();
        collections.addAll(features);
        Charset charset = this.getShapefileCharset(getFeature);
        this.write(collections, charset, output, GetFeatureRequest.adapt(getFeature.getParameters()[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<SimpleFeatureCollection> collections, Charset charset, OutputStream output, final GetFeatureRequest request) throws IOException, ServiceException {
        final File tempDir = IOUtils.createTempDirectory((String)"shpziptemp");
        ShapefileDumper dumper = new ShapefileDumper(tempDir){

            protected String getShapeName(SimpleFeatureType schema, String geometryName, String geometryType) {
                FeatureTypeInfo ftInfo = ShapeZipOutputFormat.this.getFeatureTypeInfo(schema);
                String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getShapeName(ftInfo, geometryName, geometryType);
                return fileName;
            }

            protected void shapefileDumped(String fileName, SimpleFeatureType remappedSchema) throws IOException {
                try {
                    ShapeZipOutputFormat.this.changeWKTFormatIfFileFormatIsESRI(tempDir, request, fileName, remappedSchema);
                }
                catch (FactoryException e) {
                    throw new IOException("Failed to write out the ESRI style prj file", e);
                }
            }
        };
        dumper.setMaxDbfSize(this.maxDbfSize);
        dumper.setMaxShpSize(this.maxShpSize);
        dumper.setCharset(charset);
        try {
            boolean shapefileCreated = false;
            for (SimpleFeatureCollection collection : collections) {
                shapefileCreated |= dumper.dump(collection);
            }
            if (!shapefileCreated) {
                this.createEmptyZipWarning(tempDir);
            }
            if (((WFSInfo)this.gs.getService(WFSInfo.class)).getIncludeWFSRequestDumpFile()) {
                this.createRequestDump(tempDir, request, collections.get(0));
            }
            FilenameFilter filter = (dir, name) -> (name = name.toLowerCase()).endsWith(".shp") || name.endsWith(".shx") || name.endsWith(".dbf") || name.endsWith(".prj") || name.endsWith(".cst") || name.endsWith(".txt");
            ZipOutputStream zipOut = new ZipOutputStream(output);
            IOUtils.zipDirectory((File)tempDir, (ZipOutputStream)zipOut, (FilenameFilter)filter);
            zipOut.finish();
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)tempDir);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath() + " due to: " + e.getMessage());
            }
        }
    }

    private void createRequestDump(File tempDir, GetFeatureRequest gft, SimpleFeatureCollection fc) {
        block11: {
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request == null || gft == null) {
                return;
            }
            FeatureTypeInfo ftInfo = this.getFeatureTypeInfo((SimpleFeatureType)fc.getSchema());
            String fileName = new FileNameSource(((Object)((Object)this)).getClass()).getRequestDumpName(ftInfo) + ".txt";
            File target = new File(tempDir, fileName);
            try {
                if (request.isGet()) {
                    HttpServletRequest httpRequest = request.getHttpRequest();
                    String baseUrl = ResponseUtils.baseURL((HttpServletRequest)httpRequest);
                    String path = request.getPath();
                    String mangledUrl = ResponseUtils.buildURL((String)baseUrl, (String)path, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                    StringBuilder url = new StringBuilder();
                    String parameters = httpRequest.getQueryString();
                    url.append(mangledUrl).append("?").append(parameters);
                    FileUtils.writeStringToFile((File)target, (String)url.toString(), (String)"UTF-8");
                    break block11;
                }
                WFSConfiguration cfg = null;
                QName elementName = null;
                if (gft.getVersion().equals("1.1.0")) {
                    cfg = new WFSConfiguration();
                    elementName = WFS.GetFeature;
                } else {
                    cfg = new WFSConfiguration_1_0();
                    elementName = org.geotools.wfs.v1_0.WFS.GetFeature;
                }
                try (FileOutputStream fos = new FileOutputStream(target);){
                    Encoder encoder = new Encoder((org.geotools.xsd.Configuration)cfg);
                    encoder.setIndenting(true);
                    encoder.setIndentSize(2);
                    encoder.encode((Object)gft, elementName, (OutputStream)fos);
                }
            }
            catch (IOException e) {
                throw new WFSException((RequestObject)gft, "Failed to dump the WFS request");
            }
        }
    }

    private void createEmptyZipWarning(File tempDir) throws IOException {
        try (PrintWriter pw = new PrintWriter(new File(tempDir, "README.TXT"));){
            pw.print("The query result is empty, and the geometric type of the features is unknown:an empty point shapefile has been created to fill the zip file");
        }
    }

    private FeatureTypeInfo getFeatureTypeInfo(SimpleFeatureType schema) {
        FeatureTypeInfo ftInfo = this.catalog.getFeatureTypeByName(schema.getName());
        if (ftInfo == null) {
            SimpleFeatureSource featureSource = DataUtilities.source((FeatureCollection)new ListFeatureCollection(schema));
            CatalogBuilder catalogBuilder = new CatalogBuilder(this.catalog);
            catalogBuilder.setStore((StoreInfo)catalogBuilder.buildDataStore(schema.getName().getLocalPart()));
            ftInfo = catalogBuilder.buildFeatureType((FeatureSource)featureSource);
        }
        return ftInfo;
    }

    private void changeWKTFormatIfFileFormatIsESRI(File tempDir, GetFeatureRequest request, String fileName, SimpleFeatureType remappedSchema) throws FactoryException, IOException, FileNotFoundException {
        WFSInfo bean;
        MetadataMap metadata;
        Boolean defaultIsEsri;
        boolean useEsriFormat = false;
        if (request == null) {
            return;
        }
        Map<String, Object> formatOptions = request.getFormatOptions();
        String requestedPrjFileFormat = (String)formatOptions.get("PRJFILEFORMAT");
        useEsriFormat = null == requestedPrjFileFormat ? (defaultIsEsri = (Boolean)(metadata = (bean = (WFSInfo)this.gs.getService(WFSInfo.class)).getMetadata()).get(SHAPE_ZIP_DEFAULT_PRJ_IS_ESRI, Boolean.class)) != null && defaultIsEsri != false : "ESRI".equalsIgnoreCase(requestedPrjFileFormat);
        if (useEsriFormat) {
            this.replaceOGCPrjFileByESRIPrjFile(tempDir, fileName, remappedSchema);
        }
    }

    private void replaceOGCPrjFileByESRIPrjFile(File tempDir, String fileName, SimpleFeatureType remappedSchema) throws FactoryException, IOException, FileNotFoundException {
        Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)remappedSchema.getGeometryDescriptor().getCoordinateReferenceSystem(), (boolean)true);
        if (epsgCode == null) {
            LOGGER.info("Can't find the EPSG code for the shapefile CRS");
            return;
        }
        Resource file = this.resourceLoader.get("user_projections/esri.properties");
        if (file.getType() == Resource.Type.RESOURCE) {
            Properties properties = new Properties();
            try (InputStream fis = file.in();){
                properties.load(fis);
            }
            String data = (String)properties.get(epsgCode.toString());
            if (data != null) {
                File prjShapeFile = new File(tempDir, fileName + ".prj");
                prjShapeFile.delete();
                try (BufferedWriter out = new BufferedWriter(new FileWriter(prjShapeFile));){
                    out.write(data);
                }
            } else {
                LOGGER.info("Requested shapefile with ESRI WKT .prj format but couldn't find an entry for ESPG code " + epsgCode + " in esri.properties");
            }
        } else {
            LOGGER.info("Requested shapefile with ESRI WKT .prj format but the esri.properties file does not exist in the user_projections directory");
        }
    }

    private Charset getShapefileCharset(Operation getFeature) {
        Charset result = null;
        GetFeatureRequest gft = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        if (gft.getFormatOptions() != null && gft.getFormatOptions().get("CHARSET") != null) {
            result = (Charset)gft.getFormatOptions().get("CHARSET");
        } else {
            String charsetName = GeoServerExtensions.getProperty((String)GS_SHAPEFILE_CHARSET, (ApplicationContext)this.applicationContext);
            if (charsetName != null) {
                result = Charset.forName(charsetName);
            }
        }
        return result != null ? result : StandardCharsets.ISO_8859_1;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public long getMaxShpSize() {
        return this.maxShpSize;
    }

    public void setMaxShpSize(long maxShapefileSize) {
        this.maxShpSize = maxShapefileSize;
    }

    public long getMaxDbfSize() {
        return this.maxDbfSize;
    }

    public void setMaxDbfSize(long maxDbfSize) {
        this.maxDbfSize = maxDbfSize;
    }

    class FileNameSource {
        private Class<?> clazz;

        public FileNameSource(Class<?> clazz) {
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties processTemplate(FeatureTypeInfo ftInfo, String geometryName, String geometryType) {
            try {
                GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(this.clazz, ShapeZipOutputFormat.this.resourceLoader);
                templateLoader.setFeatureType(ftInfo);
                Template template = null;
                Configuration configuration = templateConfig;
                synchronized (configuration) {
                    templateConfig.setTemplateLoader((TemplateLoader)templateLoader);
                    template = templateConfig.getTemplate("shapezip.ftl");
                }
                Date timestamp = Dispatcher.REQUEST.get() != null ? ((Request)Dispatcher.REQUEST.get()).getTimestamp() : new Date();
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("typename", this.getTypeName(ftInfo));
                context.put("workspace", ftInfo.getNamespace().getPrefix());
                context.put("geometryName", geometryName == null ? "" : geometryName);
                context.put("geometryType", geometryType == null ? "" : geometryType);
                context.put("timestamp", timestamp);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
                Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
                format.setCalendar(cal);
                context.put("iso_timestamp", format.format(timestamp));
                StringWriter sw = new StringWriter();
                template.process(context, (Writer)sw);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(sw.toString().getBytes()));
                return props;
            }
            catch (Exception e) {
                throw new WFSException("Failed to process the file name template", (Throwable)e);
            }
        }

        private String getTypeName(FeatureTypeInfo ftInfo) {
            return ftInfo.getName().replace(".", "_");
        }

        public String getZipName(FeatureTypeInfo ftInfo) {
            Properties props = this.processTemplate(ftInfo, null, null);
            String filename = props.getProperty("zip");
            if (filename == null) {
                filename = this.getTypeName(ftInfo);
            }
            return filename;
        }

        public String getShapeName(FeatureTypeInfo ftInfo, String geometryName, String geometryType) {
            Properties props = this.processTemplate(ftInfo, geometryName, geometryType);
            Object filename = props.getProperty("shp");
            if (filename == null) {
                filename = this.getTypeName(ftInfo) + geometryType;
            }
            return filename;
        }

        public String getRequestDumpName(FeatureTypeInfo ftInfo) {
            Properties props = this.processTemplate(ftInfo, null, null);
            String filename = props.getProperty("txt");
            if (filename == null) {
                filename = this.getTypeName(ftInfo);
            }
            return filename;
        }
    }
}

