/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.response.ComplexFeatureAwareFormat;
import org.geoserver.wfs.xml.ApplicationSchemaConfiguration;
import org.geoserver.wfs.xml.ApplicationSchemaXSD;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.wfs.WFS;
import org.geotools.wfs.WFSConfiguration;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;

public class GML2OutputFormat2
extends WFSGetFeatureOutputFormat
implements ComplexFeatureAwareFormat {
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;

    public GML2OutputFormat2(GeoServer gs) {
        super(gs, new HashSet<String>(Arrays.asList("gml2", "text/xml; subtype=gml/2.1.2")));
        this.catalog = gs.getCatalog();
        this.resourceLoader = this.catalog.getResourceLoader();
    }

    @Override
    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/2.1.2";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "GML2";
    }

    @Override
    protected void write(FeatureCollectionResponse results, OutputStream output, Operation getFeature) throws ServiceException, IOException {
        NamespaceInfo ns;
        GetFeatureRequest gft = GetFeatureRequest.adapt(getFeature.getParameters()[0]);
        List<FeatureCollection> featureCollections = results.getFeature();
        HashSetValuedHashMap ns2metas = new HashSetValuedHashMap();
        for (FeatureCollection featureCollection : featureCollections) {
            SimpleFeatureCollection features = (SimpleFeatureCollection)featureCollection;
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            String namespaceURI = featureType.getName().getNamespaceURI();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(namespaceURI, featureType.getTypeName());
            if (meta == null) {
                throw new WFSException((RequestObject)gft, "Could not find feature type " + namespaceURI + ":" + featureType.getTypeName() + " in the GeoServer catalog");
            }
            ns = this.catalog.getNamespaceByURI(namespaceURI);
            ns2metas.put((Object)ns, (Object)meta);
        }
        Collection featureTypes = ns2metas.values();
        ApplicationSchemaXSD xsd = new ApplicationSchemaXSD(null, this.catalog, gft.getBaseUrl(), (WFS)org.geotools.wfs.v1_0.WFS.getInstance(), featureTypes);
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(xsd, (WFSConfiguration)new WFSConfiguration_1_0());
        Encoder encoder = new Encoder((Configuration)configuration);
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)gft.getBaseUrl(), (String)"wfs/1.0.0/WFS-basic.xsd"));
        Map params = ResponseUtils.params((String[])new String[]{"service", "WFS", "version", "1.0.0", "request", "DescribeFeatureType"});
        MapIterator i = ns2metas.mapIterator();
        while (i.hasNext()) {
            ns = (NamespaceInfo)i.next();
            String namespaceURI = ns.getURI();
            Collection metas = (Collection)i.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator m = metas.iterator();
            while (m.hasNext()) {
                FeatureTypeInfo meta = (FeatureTypeInfo)m.next();
                typeNames.append(meta.prefixedName());
                if (!m.hasNext()) continue;
                typeNames.append(",");
            }
            params.put("typeName", typeNames.toString());
            encoder.setSchemaLocation(namespaceURI, ResponseUtils.buildURL((String)gft.getBaseUrl(), (String)"wfs", (Map)params, (URLMangler.URLType)URLMangler.URLType.RESOURCE));
        }
        encoder.encode((Object)results.getAdaptee(), org.geotools.wfs.v1_0.WFS.FeatureCollection, output);
    }

    @Override
    public boolean supportsComplexFeatures(Object value, Operation operation) {
        return true;
    }
}

