/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class QueryTypeBinding
extends AbstractComplexBinding {
    WfsFactory wfsfactory;

    public QueryTypeBinding(WfsFactory wfsfactory) {
        this.wfsfactory = wfsfactory;
    }

    public QName getTarget() {
        return WFS.QUERYTYPE;
    }

    public Class<QueryType> getType() {
        return QueryType.class;
    }

    public void initializeChildContext(ElementInstance childInstance, Node node, MutablePicoContainer context) {
        if (node.hasAttribute("srsName")) {
            try {
                CoordinateReferenceSystem crs = GML2ParsingUtils.crs((Node)node);
                if (crs != null) {
                    context.registerComponentInstance(CoordinateReferenceSystem.class, (Object)crs);
                }
            }
            catch (Exception e) {
                throw new WFSException(e, "InvalidParameterValue");
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        QueryType query = this.wfsfactory.createQueryType();
        if (node.hasChild("PropertyName")) {
            for (Object property : node.getChildValues("PropertyName")) {
                String propertyName = property instanceof String ? (String)property : ((PropertyName)property).getPropertyName();
                query.getPropertyName().add((Object)propertyName);
            }
        }
        if (node.hasChild("Function")) {
            query.getFunction().add((Object)node.getChildValues("Function"));
        }
        if (node.hasChild(Filter.class)) {
            query.setFilter((Filter)node.getChildValue(Filter.class));
        }
        if (node.hasChild(SortBy[].class)) {
            SortBy[] sortBy;
            for (SortBy by : sortBy = (SortBy[])node.getChildValue(SortBy[].class)) {
                query.getSortBy().add((Object)by);
            }
        }
        if (node.hasAttribute("handle")) {
            query.setHandle((String)node.getAttributeValue("handle"));
        }
        query.setTypeName((List)node.getAttributeValue("typeName"));
        if (node.hasAttribute("featureVersion")) {
            query.setFeatureVersion((String)node.getAttributeValue("featureVersion"));
        }
        if (node.hasAttribute("srsName")) {
            query.setSrsName((URI)node.getAttributeValue("srsName"));
        }
        if (node.hasChild("XlinkPropertyName")) {
            query.getXlinkPropertyName().addAll((Collection)node.getChildValues("XlinkPropertyName"));
        }
        return query;
    }
}

