/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.junit.Assert;
import org.junit.Test;

public class CatalogNamespaceSupportTest {
    @Test
    public void testGetURI() {
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getURI()).andReturn((Object)"http://foo.org");
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)cat.getNamespaceByPrefix("foo")).andReturn((Object)ns);
        EasyMock.replay((Object[])new Object[]{ns, cat});
        CatalogNamespaceSupport nsSupport = new CatalogNamespaceSupport(cat);
        Assert.assertEquals((Object)"http://foo.org", (Object)nsSupport.getURI("foo"));
        EasyMock.verify((Object[])new Object[]{ns, cat});
    }

    @Test
    public void testGetDefaultURI() {
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getURI()).andReturn((Object)"http://foo.org");
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)cat.getDefaultNamespace()).andReturn((Object)ns);
        EasyMock.replay((Object[])new Object[]{ns, cat});
        CatalogNamespaceSupport nsSupport = new CatalogNamespaceSupport(cat);
        Assert.assertEquals((Object)"http://foo.org", (Object)nsSupport.getURI(""));
        EasyMock.verify((Object[])new Object[]{ns, cat});
    }

    @Test
    public void testGetPrefix() {
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)"foo");
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)cat.getNamespaceByURI("http://foo.org")).andReturn((Object)ns);
        EasyMock.replay((Object[])new Object[]{ns, cat});
        CatalogNamespaceSupport nsSupport = new CatalogNamespaceSupport(cat);
        Assert.assertEquals((Object)"foo", (Object)nsSupport.getPrefix("http://foo.org"));
        EasyMock.verify((Object[])new Object[]{ns, cat});
    }

    @Test
    public void testGetDefaultPrefix() {
        NamespaceInfo ns = (NamespaceInfo)EasyMock.createMock(NamespaceInfo.class);
        EasyMock.expect((Object)ns.getPrefix()).andReturn((Object)"foo");
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)cat.getDefaultNamespace()).andReturn((Object)ns);
        EasyMock.replay((Object[])new Object[]{ns, cat});
        CatalogNamespaceSupport nsSupport = new CatalogNamespaceSupport(cat);
        Assert.assertEquals((Object)"foo", (Object)nsSupport.getPrefix(""));
        EasyMock.verify((Object[])new Object[]{ns, cat});
    }

    @Test
    public void testNulls() {
        Catalog cat = (Catalog)EasyMock.createMock(Catalog.class);
        EasyMock.expect((Object)cat.getNamespaceByURI(null)).andReturn(null);
        EasyMock.expect((Object)cat.getNamespaceByPrefix(null)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{cat});
        CatalogNamespaceSupport nsSupport = new CatalogNamespaceSupport(cat);
        Assert.assertNull((Object)nsSupport.getPrefix(null));
        Assert.assertNull((Object)nsSupport.getURI(null));
        EasyMock.verify((Object[])new Object[]{cat});
    }
}

