/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Arrays;
import java.util.List;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredObjects;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wfs.FeatureSizeFeatureCollection;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class FeatureCollectionDelegationTest
extends GeoServerSystemTestSupport {
    private final WrapperPolicy policy = WrapperPolicy.readOnlyHide((AccessLimits)new AccessLimits(CatalogMode.HIDE));
    private static final String FEATURE_TYPE_NAME = "testType";
    private FeatureVisitor lastVisitor = null;
    private List<SimpleFeatureCollection> maxVisitorCollections;
    private List<SimpleFeatureCollection> countVisitorCollections;

    @Before
    public void setUp() throws Exception {
        this.lastVisitor = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(8.0, 9.0));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        ListFeatureCollection visitorCollection = new ListFeatureCollection(ft){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) {
                FeatureCollectionDelegationTest.this.lastVisitor = visitor;
            }

            public SimpleFeatureCollection subCollection(Filter filter) {
                if (filter == Filter.INCLUDE) {
                    return this;
                }
                return super.subCollection(filter);
            }
        };
        SimpleFeatureSource featureSource = DataUtilities.source((FeatureCollection)visitorCollection);
        this.maxVisitorCollections = Arrays.asList(new FeatureSizeFeatureCollection((SimpleFeatureCollection)visitorCollection, featureSource, Query.ALL), new FilteringSimpleFeatureCollection((SimpleFeatureCollection)visitorCollection, (Filter)Filter.INCLUDE));
        this.countVisitorCollections = Arrays.asList(new FeatureSizeFeatureCollection((SimpleFeatureCollection)visitorCollection, featureSource, Query.ALL), new FilteringSimpleFeatureCollection((SimpleFeatureCollection)visitorCollection, (Filter)Filter.INCLUDE), new RetypingFeatureCollection((SimpleFeatureCollection)visitorCollection, visitorCollection.getSchema()), (SimpleFeatureCollection)SecuredObjects.secure((Object)visitorCollection, (WrapperPolicy)this.policy));
    }

    @Test
    public void testMaxVisitorDelegation() {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory().property("value"));
        this.assertOptimalVisit((FeatureVisitor)visitor, this.maxVisitorCollections);
    }

    @Test
    public void testCountVisitorDelegation() {
        CountVisitor visitor = new CountVisitor();
        this.assertOptimalVisit((FeatureVisitor)visitor, this.countVisitorCollections);
    }

    private void assertOptimalVisit(FeatureVisitor visitor, List<SimpleFeatureCollection> collections) {
        collections.forEach(simpleFeatureCollection -> {
            try {
                this.lastVisitor = null;
                simpleFeatureCollection.accepts(visitor, null);
            }
            catch (Exception e) {
                Assert.fail();
            }
            Assert.assertSame((Object)this.lastVisitor, (Object)visitor);
        });
    }
}

