/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.File;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureMissingTypesTest
extends WFSTestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(CiteTestData.BUILDINGS);
    }

    @Test
    public void testPostMissingType10() throws Exception {
        File root = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        File nsDirectory = new File(root, SystemTestData.BUILDINGS.getPrefix());
        File buildings = new File(nsDirectory, SystemTestData.BUILDINGS.getLocalPart() + ".properties");
        Assert.assertTrue((boolean)buildings.delete());
        Object xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:PropertyName>cdf:string2</ogc:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        Assert.assertNotEquals((long)0L, (long)featureMembers.getLength());
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + this.getLayerId(SystemTestData.BUILDINGS) + "\"/> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testPostMissingType11() throws Exception {
        File root = ((SystemTestData)this.getTestData()).getDataDirectoryRoot();
        File nsDirectory = new File(root, SystemTestData.BUILDINGS.getPrefix());
        File buildings = new File(nsDirectory, SystemTestData.BUILDINGS.getLocalPart() + ".properties");
        Assert.assertTrue((boolean)buildings.delete());
        Object xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + this.getLayerId(SystemTestData.BUILDINGS) + "\"/> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }
}

