/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.junit.Before;

public class WFSCurvesTestSupport
extends WFSTestSupport {
    protected QName CURVELINES = new QName(MockData.CITE_URI, "curvelines", MockData.CITE_PREFIX);
    protected QName CURVEMULTILINES = new QName(MockData.CITE_URI, "curvemultilines", MockData.CITE_PREFIX);
    protected QName CURVEPOLYGONS = new QName(MockData.CITE_URI, "curvepolygons", MockData.CITE_PREFIX);
    protected XpathEngine xpath;

    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        super.setUpInternal(testData);
        testData.addWorkspace(MockData.CITE_PREFIX, MockData.CITE_URI, this.getCatalog());
        testData.addVectorLayer(this.CURVELINES, Collections.emptyMap(), "curvelines.properties", MockData.class, this.getCatalog());
        testData.addVectorLayer(this.CURVEMULTILINES, Collections.emptyMap(), "curvemultilines.properties", MockData.class, this.getCatalog());
        testData.addVectorLayer(this.CURVEPOLYGONS, Collections.emptyMap(), "curvepolygons.properties", MockData.class, this.getCatalog());
        FeatureTypeInfo curveLines = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.CURVELINES));
        curveLines.setCircularArcPresent(true);
        curveLines.setLinearizationTolerance(null);
        this.getCatalog().save((ResourceInfo)curveLines);
        FeatureTypeInfo curveMultiLines = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.CURVEMULTILINES));
        curveMultiLines.setCircularArcPresent(true);
        curveMultiLines.setLinearizationTolerance(null);
        this.getCatalog().save((ResourceInfo)curveMultiLines);
    }

    @Before
    public void setXPath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }
}

