/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.json.JSONType;
import org.junit.Assert;
import org.junit.Test;

public class GeoJsonDescribeTest
extends WFSTestSupport {
    @Test
    public void testDescribePrimitiveGeoFeatureJSON() throws Exception {
        String output = this.getAsString("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0&outputFormat=application/json&typeName=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        this.testOutput(output);
    }

    private void testOutput(String output) {
        JSONObject description = JSONObject.fromObject((Object)output);
        Assert.assertEquals((Object)description.get("elementFormDefault"), (Object)"qualified");
        Assert.assertEquals((Object)description.get("targetNamespace"), (Object)"http://cite.opengeospatial.org/gmlsf");
        Assert.assertEquals((Object)description.get("targetPrefix"), (Object)"sf");
        JSONArray array = description.getJSONArray("featureTypes");
        Assert.assertEquals((long)1L, (long)array.size());
        JSONObject feature = array.getJSONObject(0);
        Assert.assertEquals((Object)feature.get("typeName"), (Object)"PrimitiveGeoFeature");
        JSONArray props = feature.getJSONArray("properties");
        Assert.assertNotNull((Object)props);
        int i = 0;
        Assert.assertEquals((Object)"description", (Object)props.getJSONObject(i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:string", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"string", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"name", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:string", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"string", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"surfaceProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"gml:Polygon", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"Polygon", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"pointProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:Point", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"Point", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"curveProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:LineString", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"LineString", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"intProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:int", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"int", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"uriProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:string", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"string", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"measurand", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:string", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"string", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"dateTimeProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:date-time", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"date-time", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"dateProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:date", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"date", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"decimalProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:number", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"number", (Object)props.getJSONObject(i).get("localType"));
        Assert.assertEquals((Object)"booleanProperty", (Object)props.getJSONObject(++i).get("name"));
        Assert.assertEquals((Object)0, (Object)props.getJSONObject(i).get("minOccurs"));
        Assert.assertEquals((Object)1, (Object)props.getJSONObject(i).get("maxOccurs"));
        Assert.assertEquals((Object)true, (Object)props.getJSONObject(i).get("nillable"));
        Assert.assertEquals((Object)"xsd:boolean", (Object)props.getJSONObject(i).get("type"));
        Assert.assertEquals((Object)"boolean", (Object)props.getJSONObject(i).get("localType"));
    }

    @Test
    public void testDescribePrimitiveGeoFeatureJSONP() throws Exception {
        JSONType.setJsonpEnabled((boolean)true);
        String output = this.getAsString("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0&outputFormat=text/javascript&typeName=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        JSONType.setJsonpEnabled((boolean)false);
        output = output.substring(0, output.length() - 2);
        output = output.substring("parseResponse".length() + 1, output.length());
        this.testOutput(output);
    }

    @Test
    public void testDescribePrimitiveGeoFeatureJSONPCustom() throws Exception {
        JSONType.setJsonpEnabled((boolean)true);
        String output = this.getAsString("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0&outputFormat=text/javascript&typeName=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE) + "&format_options=callback:custom");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertTrue((boolean)output.startsWith("custom("));
        output = output.substring(0, output.length() - 2);
        output = output.substring("custom".length() + 1, output.length());
        this.testOutput(output);
    }
}

