/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.xml.namespace.QName;
import net.sf.json.JSONObject;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public final class GeoJsonOutputFormatTest
extends WFSTestSupport {
    private static final QName LINESTRING_ZM = new QName(MockData.DEFAULT_URI, "lineStringZm", MockData.DEFAULT_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(LINESTRING_ZM, Collections.emptyMap(), "lineStringZm.properties", GeoJsonOutputFormatTest.class, this.getCatalog());
    }

    @Before
    public void beforeTest() {
        GeoJsonOutputFormatTest.setMeasuresEncoding(this.getCatalog(), LINESTRING_ZM.getLocalPart(), false);
    }

    @Test
    public void testMeasuresEncoding() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:lineStringZm&version=2.0.0&service=wfs&outputFormat=application/json");
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"[[120,50,20],[90,80,35]]"));
        GeoJsonOutputFormatTest.setMeasuresEncoding(this.getCatalog(), LINESTRING_ZM.getLocalPart(), true);
        response = this.getAsServletResponse("wfs?request=GetFeature&typenames=gs:lineStringZm&version=2.0.0&service=wfs&outputFormat=application/json");
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"[[120,50,20,15],[90,80,35,5]]"));
    }

    @Test
    public void testCountZero() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?version=2.0.0&request=GetFeature&typeName=sf:PrimitiveGeoFeature&outputFormat=json&count=0", StandardCharsets.UTF_8.name());
        Assert.assertEquals((Object)"application/json", (Object)this.getBaseMimeType(response.getContentType()));
        Assert.assertEquals((Object)StandardCharsets.UTF_8.name(), (Object)response.getCharacterEncoding());
        Assert.assertEquals((Object)"inline; filename=PrimitiveGeoFeature.json", (Object)response.getHeader("Content-Disposition"));
        JSONObject collection = (JSONObject)this.json(response);
        MatcherAssert.assertThat((Object)collection.getInt("totalFeatures"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)collection.getInt("numberMatched"), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)collection.getInt("numberReturned"), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)collection.getJSONArray("features"), (Matcher)Matchers.empty());
    }
}

