/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.response.WfsXmlWriter;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WfsXmlWriterTest
extends WFSTestSupport {
    @Test
    public void test() throws Exception {
        File tmp = File.createTempFile("wfs", "xml");
        tmp.deleteOnExit();
        WfsXmlWriter.WFS1_0 writer = new WfsXmlWriter.WFS1_0(this.getWFS(), (OutputStream)new FileOutputStream(tmp));
        writer.openTag("wfs", "FeatureCollection");
        writer.openTag("gml", "Feature", new String[]{"id", "foo", "srs", "4326"});
        writer.text("some text");
        writer.closeTag("gml", "Feature");
        writer.closeTag("wfs", "FeatureCollection");
        writer.close();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(tmp);
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("gml:Feature");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Element feature = (Element)features.item(0);
        Assert.assertEquals((Object)"foo", (Object)feature.getAttribute("id"));
        Assert.assertEquals((Object)"4326", (Object)feature.getAttribute("srs"));
    }
}

