/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.RunTestSetup;
import org.geoserver.util.XmlTestUtil;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.wfs.v1_1.WFS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFeatureTest
extends WFSTestSupport {
    XmlTestUtil xmlUtil;

    @Before
    public void setupXmlUtil() {
        this.xmlUtil = new XmlTestUtil();
        this.xmlUtil.addNamespace("wfs", "http://www.opengis.net/wfs");
        this.xmlUtil.addNamespace("sf", "http://cite.opengeospatial.org/gmlsf");
    }

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        data.addVectorLayer(new QName(SystemTestData.SF_URI, "WithGMLProperties", SystemTestData.SF_PREFIX), Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testGet() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
    }

    @Test
    public void testGetPropertyNameEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&propertyname=");
    }

    @Test
    public void testGetPropertyNameStar() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&propertyname=*");
    }

    @Test
    public void testGetPropertyNameOneValueServiceNotSet() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Ponds&version=1.1.0&cql_filter=TYPE%3D%27Stock%20Pond%27&propertyname=TYPE");
        NodeList features = doc.getElementsByTagName("cite:Ponds");
        Assert.assertNotEquals((long)0L, (long)features.getLength());
        int count = 0;
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            for (int j = 0; j < feature.getChildNodes().getLength(); ++j) {
                if (feature.getChildNodes().item(j).getNodeName().equals("cite:TYPE")) {
                    ++count;
                }
                if (!feature.getChildNodes().item(j).getNodeName().equals("cite:NAME")) continue;
                Assert.fail((String)"Unexpected property found");
            }
        }
        Assert.assertEquals((long)features.getLength(), (long)count);
        Document docSlashBeforeQuestion = this.getAsDOM("wfs/?request=GetFeature&typename=cite:Ponds&version=1.1.0&cql_filter=TYPE%3D%27Stock%20Pond%27&propertyname=TYPE");
        features = docSlashBeforeQuestion.getElementsByTagName("cite:Ponds");
        Assert.assertNotEquals((long)0L, (long)features.getLength());
        count = 0;
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            for (int j = 0; j < feature.getChildNodes().getLength(); ++j) {
                if (feature.getChildNodes().item(j).getNodeName().equals("cite:TYPE")) {
                    ++count;
                }
                if (!feature.getChildNodes().item(j).getNodeName().equals("cite:NAME")) continue;
                Assert.fail((String)"Unexpected property found");
            }
        }
        Assert.assertEquals((long)features.getLength(), (long)count);
    }

    private void testGetFifteenAll(String request) throws Exception {
        Document doc = this.getAsDOM(request);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertNotEquals((long)0L, (long)features.getLength());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    @RunTestSetup
    public void testGetWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=1.1.0&service=wfs&featureid=Fifteen.2");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen/@gml:id", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=1.1.0&service=wfs&featureId=NamedPlaces.1107531895891");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cite:NamedPlaces)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/gml:featureMembers/cite:NamedPlaces/@gml:id", (Document)doc);
    }

    @Test
    public void testGetWithTwoFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&&version=1.1.0&service=wfs&featureid=Fifteen.1,Fifteen.2");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen[@gml:id='Fifteen.1']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen[@gml:id='Fifteen.2']", (Document)doc);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Other");
        Assert.assertNotEquals((long)0L, (long)features.getLength());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    public void testPostSOAP12() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature></soap:Body></soap:Envelope>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)response.getContentType());
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        this.print(doc);
        XMLAssert.assertXpathExists((String)"/soap12:Envelope", (Document)doc);
        XMLAssert.assertXpathExists((String)"/soap12:Envelope/soap12:Body/wfs:FeatureCollection", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/soap12:Envelope/soap12:Body/wfs:FeatureCollection/gml:featureMembers/cdf:Other)", (Document)doc);
    }

    @Test
    public void testPostFormEncoded() throws Exception {
        String request = "wfs?service=WFS&version=1.1.0&request=GetFeature&typename=sf:PrimitiveGeoFeature&namespace=xmlns(" + URLEncoder.encode("sf=http://cite.opengeospatial.org/gmlsf", "UTF-8") + ")";
        Document doc = this.postAsDOM(request);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)5L, (long)doc.getElementsByTagName("sf:PrimitiveGeoFeature").getLength());
    }

    @Test
    public void testPostWithFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cdf:integers</ogc:PropertyName> <ogc:Add> <ogc:Literal>4</ogc:Literal> <ogc:Literal>3</ogc:Literal> </ogc:Add> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Other");
        Assert.assertNotEquals((long)0L, (long)features.getLength());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    public void testPostWithBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"EPSG:4326\">      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)1L, (long)features.getLength());
    }

    @Test
    public void testPostWithFailingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)0L, (long)features.getLength());
    }

    @Test
    public void testPostWithMatchingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">      <gml:lowerCorner>-4.5 57.0</gml:lowerCorner>      <gml:upperCorner>1.0 62.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.xmlUtil.hasNode("wfs:FeatureCollection"));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.xmlUtil.hasNode("//sf:PrimitiveGeoFeature"));
    }

    @Test
    public void testResultTypeHitsGet() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&resultType=hits&service=wfs");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertEquals((long)0L, (long)features.getLength());
        Assert.assertEquals((Object)"15", (Object)doc.getDocumentElement().getAttribute("numberOfFeatures"));
    }

    @Test
    public void testResultTypeHitsPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" resultType=\"hits\"> <wfs:Query typeName=\"cdf:Seven\"/> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertEquals((long)0L, (long)features.getLength());
        Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberOfFeatures"));
    }

    @Test
    public void testWithSRS() throws Exception {
        String xml = "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" version=\"1.1.0\" service=\"WFS\"><wfs:Query xmlns:cdf=\"http://www.opengis.net/cite/data\" typeName=\"cdf:Other\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cdf:Other").getLength());
    }

    @Test
    public void testWithSillyLiteral() throws Exception {
        String xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Other\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"><ogc:Filter>  <ogc:PropertyIsEqualTo>   <ogc:PropertyName>description</ogc:PropertyName>   <ogc:Literal>       <wfs:Native vendorId=\"foo\" safeToIgnore=\"true\"/>   </ogc:Literal>   </ogc:PropertyIsEqualTo> </ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("cdf:Other").getLength());
    }

    @Test
    public void testWithGmlObjectId() throws Exception {
        Object xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Seven\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"></wfs:Query></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)7L, (long)dom.getElementsByTagName("cdf:Seven").getLength());
        NodeList others = dom.getElementsByTagName("cdf:Seven");
        String id = ((Element)others.item(0)).getAttributeNS("http://www.opengis.net/gml", "id");
        Assert.assertNotNull((Object)id);
        xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Seven\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"><ogc:Filter><ogc:GmlObjectId gml:id=\"" + id + "\"/></ogc:Filter></wfs:Query></wfs:GetFeature>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cdf:Seven").getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostWithBoundsEnabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
            Document doc = this.postAsDOM("wfs", xml);
            Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
            NodeList features = doc.getElementsByTagName("cdf:Other");
            Assert.assertNotEquals((long)0L, (long)features.getLength());
            for (int i = 0; i < features.getLength(); ++i) {
                Element feature = (Element)features.item(i);
                Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
                NodeList boundList = feature.getElementsByTagName("gml:boundedBy");
                Assert.assertEquals((long)1L, (long)boundList.getLength());
                Element boundedBy = (Element)boundList.item(0);
                NodeList boxList = boundedBy.getElementsByTagName("gml:Envelope");
                Assert.assertEquals((long)1L, (long)boxList.getLength());
                Element box = (Element)boxList.item(0);
                Assert.assertTrue((boolean)box.hasAttribute("srsName"));
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testAfterFeatureTypeAdded() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:new");
        Assert.assertEquals((Object)"ExceptionReport", (Object)dom.getDocumentElement().getLocalName());
        ((SystemTestData)this.getTestData()).addVectorLayer(new QName(SystemTestData.SF_URI, "new", SystemTestData.SF_PREFIX), Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:new");
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
    }

    @Test
    public void testWithGMLProperties() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)1L, (long)features.getLength());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertEquals((Object)"one", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
            Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
            Element location = this.getFirstElementByTagName(feature, "gml:location");
            Assert.assertNotNull((Object)this.getFirstElementByTagName(location, "gml:Point"));
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
        Document dom = this.getAsDOM("cdf/Seven/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
    }

    @Test
    public void testUserSuppliedNamespacePrefix() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=myPrefix:Fifteen&version=1.1.0&service=wfs&namespace=xmlns(myPrefix%3D" + URLEncoder.encode(SystemTestData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    @Test
    public void testUserSuppliedDefaultNamespace() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=Fifteen&version=1.1.0&service=wfs&namespace=xmlns(" + URLEncoder.encode(SystemTestData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    @Test
    public void testGML32OutputFormat() throws Exception {
        this.testGetFifteenAll("wfs?request=getfeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&outputFormat=gml32");
    }

    @Test
    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=GetFeature&typename=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:description", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=GetFeature&typename=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:description", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testSortedAscending() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"114", (String)"//cite:Buildings[2]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS&maxFeatures=1&startIndex=0");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS&maxFeatures=1&startIndex=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"114", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
    }

    @Test
    public void testSortedDescending() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS D");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"114", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:Buildings[2]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS D&maxFeatures=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"114", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS D&maxFeatures=1&startIndex=0");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"114", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS D&maxFeatures=1&startIndex=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:Buildings)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"113", (String)"//cite:Buildings[1]/cite:FID", (Document)dom);
    }

    @Test
    public void testSortedInvalidAttribute() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=GODOT");
        this.checkOws10Exception(dom, "InvalidParameterValue");
        XMLAssert.assertXpathEvaluatesTo((String)("Illegal property name: GODOT for feature type " + this.getLayerId(SystemTestData.BUILDINGS)), (String)"//ows:ExceptionText", (Document)dom);
    }

    @Test
    public void testEncodeSrsDimension() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typename=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//gml:Point[@srsDimension = '2']", (Document)dom);
        this.setCiteCompliant(true);
        dom = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typename=" + this.getLayerId(SystemTestData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//gml:Point[@srsDimension = '2']", (Document)dom);
    }

    @Test
    public void testWfs20AndGML31() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=2.0.0&service=wfs&featureid=Fifteen.2&outputFormat=gml3");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen/@gml:id", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureMembers() throws Exception {
        WFSInfo wfs = this.getWFS();
        GeoServer gs = this.getGeoServer();
        try {
            wfs.setEncodeFeatureMember(false);
            gs.save((ServiceInfo)wfs);
            Document dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//gml:featureMembers)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gml:featureMember)", (Document)dom);
            wfs.setEncodeFeatureMember(true);
            gs.save((ServiceInfo)wfs);
            dom = this.getAsDOM("wfs?request=GetFeature&typename=" + this.getLayerId(SystemTestData.BUILDINGS) + "&version=1.1.0&service=wfs&sortBy=ADDRESS");
            XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//gml:featureMembers)", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//gml:featureMember)", (Document)dom);
        }
        finally {
            wfs.setEncodeFeatureMember(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testVirtualServicesInvocation() throws Exception {
        XpathEngine xpath = XMLUnit.newXpathEngine();
        WFS.getInstance().dispose();
        String response = this.getAsServletResponse(String.format("%s/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=%s", SystemTestData.CGF_PREFIX, this.getLayerId(SystemTestData.MLINES))).getContentAsString();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.contains("null:MLines"), (Matcher)Matchers.is((Object)false));
        Document document = this.dom(new ByteArrayInputStream(response.getBytes()), true);
        String count = xpath.evaluate("count(//gml:featureMembers/cgf:MLines)", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(count), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        response = this.getAsServletResponse(String.format("%s/ows?service=WFS&version=1.1.0&request=GetFeature&typeName=%s", SystemTestData.CITE_PREFIX, this.getLayerId(SystemTestData.BUILDINGS))).getContentAsString();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)response.contains("null:Buildings"), (Matcher)Matchers.is((Object)false));
        document = this.dom(new ByteArrayInputStream(response.getBytes()), true);
        count = xpath.evaluate("count(//gml:featureMembers/cite:Buildings)", document);
        MatcherAssert.assertThat((Object)Integer.parseInt(count), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNPEOnPaginationLinks() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"EPSG:4326\">      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < 100; ++i) {
                Future future = executorService.submit(() -> {
                    Document doc = this.postAsDOM("wfs", xml);
                    Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
                    return null;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testGetWithCountAndStartIndex0() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("wfs?request=GetFeature&typenames=cdf:Fifteen&version=1.1.0&service=wfs&maxFeatures=5&startIndex=0&outputFormat=JSON");
        Assert.assertEquals((long)5L, (long)json.getJSONArray("features").size());
        Assert.assertEquals((long)15L, (long)json.getInt("totalFeatures"));
    }

    @Test
    public void testGetWithCountAndStartIndexMiddle() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("wfs?request=GetFeature&typenames=cdf:Fifteen&version=1.1.0&service=wfs&maxFeatures=5&startIndex=7&outputFormat=JSON");
        Assert.assertEquals((long)5L, (long)json.getJSONArray("features").size());
        Assert.assertEquals((long)15L, (long)json.getInt("totalFeatures"));
    }

    @Test
    public void testGetWithCountAndStartIndexEnd() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("wfs?request=GetFeature&typenames=cdf:Fifteen&version=1.1.0&service=wfs&maxFeatures=5&startIndex=11&outputFormat=JSON");
        Assert.assertEquals((long)4L, (long)json.getJSONArray("features").size());
        Assert.assertEquals((long)15L, (long)json.getInt("totalFeatures"));
    }

    @Test
    public void testNoGmlIdOnGeometry() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=1.1.0&service=wfs&featureId=NamedPlaces.1107531895891");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cite:NamedPlaces/cite:the_geom/gml:MultiSurface/gml:surfaceMember/gml:Polygon[@gml:id])", (Document)doc);
    }

    @Test
    public void testGetIAULayer() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=iau:MarsPoi&version=1.1.0&service=wfs");
        this.print(doc);
        XMLAssert.assertXpathExists((String)"/wfs:FeatureCollection", (Document)doc);
        XpathEngine xp = XMLUnit.newXpathEngine();
        Integer count = Integer.valueOf(xp.evaluate("/wfs:FeatureCollection/@numberOfFeatures", doc));
        String srs = "urn:x-ogc:def:crs:IAU:49900";
        for (int i = 0; i < count; ++i) {
            XMLAssert.assertXpathEvaluatesTo((String)srs, (String)"//iau:MarsPoi/iau:geom/gml:Point/@srsName", (Document)doc);
        }
    }

    @Test
    public void testGetIAULayerReproject() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=iau:MarsPoi&version=1.1.0&service=wfs&srsName=urn:x-ogc:def:crs:IAU:0:49910");
        this.print(doc);
        XMLAssert.assertXpathExists((String)"/wfs:FeatureCollection", (Document)doc);
        XpathEngine xp = XMLUnit.newXpathEngine();
        Integer count = Integer.valueOf(xp.evaluate("/wfs:FeatureCollection/@numberOfFeatures", doc));
        String srs = "urn:x-ogc:def:crs:IAU:49910";
        for (int i = 0; i < count; ++i) {
            XMLAssert.assertXpathEvaluatesTo((String)srs, (String)"//iau:MarsPoi/iau:geom/gml:Point/@srsName", (Document)doc);
        }
    }
}

