/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.MockTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WFS20TestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Before
    public void revert() throws Exception {
        this.revertLayer(MockData.MPOLYGONS);
    }

    @Test
    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        this.print(doc);
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"2.0.0", (Object)doc.getDocumentElement().getAttribute("version"));
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength() > 0 ? 1 : 0) != 0);
        XMLAssert.assertXpathEvaluatesTo((String)"TRUE", (String)"//ows:OperationsMetadata/ows:Constraint[@name='KVPEncoding']/ows:DefaultValue", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"TRUE", (String)"//ows:OperationsMetadata/ows:Constraint[@name='XMLEncoding']/ows:DefaultValue", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"TRUE", (String)"//ows:OperationsMetadata/ows:Constraint[@name='SOAPEncoding']/ows:DefaultValue", (Document)doc);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\"  xmlns=\"http://www.opengis.net/wfs/2.0\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0  http://schemas.opengis.net/wfs/2.0/wfs.xsd\"/>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"2.0.0", (Object)doc.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testNamespaceFilter() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities&namespace=sf");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&namespace=NotThere");
        e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testPostNoSchemaLocation() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\" version='2.0.0'  xmlns=\"http://www.opengis.net/wfs/2.0\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" />";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"2.0.0", (Object)doc.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testOutputFormats() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList formats = engine.getMatchingNodes("//ows:Operation[@name=\"GetFeature\"]/ows:Parameter[@name=\"outputFormat\"]/ows:AllowedValues/ows:Value", doc);
        TreeSet<String> s1 = new TreeSet<String>();
        for (int i = 0; i < formats.getLength(); ++i) {
            String format = formats.item(i).getFirstChild().getNodeValue();
            s1.add(format);
        }
        List extensions = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        TreeSet s2 = new TreeSet();
        for (WFSGetFeatureOutputFormat extension : extensions) {
            s2.addAll(extension.getOutputFormats());
        }
        Assert.assertEquals(s1, s2);
    }

    @Test
    public void testResolveParameter() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        String xpathTemplate = "//ows:Operation[@name=\"%s\"]/ows:Parameter[@name=\"resolve\"]/ows:AllowedValues[ows:Value='%s']";
        for (String op : new String[]{"GetFeature", "GetFeatureWithLock", "GetPropertyValue"}) {
            for (String value : new String[]{"none", "local"}) {
                String xpath = String.format(xpathTemplate, op, value);
                XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            }
        }
    }

    @Test
    public void testSupportedSpatialOperators() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        XpathEngine engine = XMLUnit.newXpathEngine();
        NodeList spatialOperators = engine.getMatchingNodes("//fes:Spatial_Capabilities/fes:SpatialOperators/fes:SpatialOperator/@name", doc);
        TreeSet<String> ops = new TreeSet<String>();
        for (int i = 0; i < spatialOperators.getLength(); ++i) {
            String format = spatialOperators.item(i).getFirstChild().getNodeValue();
            ops.add(format);
        }
        List<String> expectedSpatialOperators = this.getSupportedSpatialOperatorsList(false);
        Assert.assertEquals((long)expectedSpatialOperators.size(), (long)ops.size());
        Assert.assertTrue((boolean)ops.containsAll(expectedSpatialOperators));
    }

    @Test
    public void testBasicWFSFesConstraints() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        String xpathTemplate = "//fes:Constraint[@name='%s']/ows:DefaultValue";
        for (String constraint : new String[]{"ImplementsAdHocQuery", "ImplementsResourceId", "ImplementsMinStandardFilter", "ImplementsStandardFilter", "ImplementsMinSpatialFilter", "ImplementsSpatialFilter", "ImplementsSorting", "ImplementsMinimumXPath"}) {
            String xpath = String.format(xpathTemplate, constraint);
            XMLAssert.assertXpathEvaluatesTo((String)"TRUE", (String)xpath, (Document)doc);
        }
    }

    @Test
    public void testFunctionArgCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        this.print(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//fes:Function[@name=\"abs\"]/fes:Arguments/fes:Argument)", (Document)doc);
    }

    @Test
    public void testTypeNameCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        List enabledTypes = this.getCatalog().getFeatureTypes();
        Iterator it = enabledTypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
            if (ft.isEnabled()) continue;
            it.remove();
        }
        int enabledCount = enabledTypes.size();
        Assert.assertEquals((long)enabledCount, (long)xpath.getMatchingNodes("/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType", doc).getLength());
    }

    @Test
    public void testTypeNames() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        List enabledTypes = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo ft : enabledTypes) {
            if (!ft.isEnabled()) continue;
            String prefixedName = ft.prefixedName();
            String xpathExpr = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[text()=\"" + prefixedName + "\"]";
            XMLAssert.assertXpathExists((String)xpathExpr, (Document)doc);
        }
    }

    @Test
    public void testOperationsMetadata() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)doc.getDocumentElement().getLocalName());
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='GetCapabilities']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='DescribeFeatureType']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='GetFeature']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='LockFeature']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='GetFeatureWithLock']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='Transaction']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='ListStoredQueries']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='DescribeStoredQueries']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='CreateStoredQuery']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//ows:Operation[@name='DropStoredQuery']", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperationsMetadataWithDisabledStoredQueryManagement() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            wfsInfo.setDisableStoredQueriesManagement(true);
            geoServer.save((ServiceInfo)wfsInfo);
            Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
            Assert.assertEquals((Object)"WFS_Capabilities", (Object)doc.getDocumentElement().getLocalName());
            XMLAssert.assertXpathExists((String)"//ows:Operation[@name='ListStoredQueries']", (Document)doc);
            XMLAssert.assertXpathExists((String)"//ows:Operation[@name='DescribeStoredQueries']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='CreateStoredQuery']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='DropStoredQuery']", (Document)doc);
        }
        finally {
            wfsInfo.setDisableStoredQueriesManagement(false);
            geoServer.save((ServiceInfo)wfsInfo);
        }
    }

    @Test
    public void testValidCapabilitiesDocument() throws Exception {
        this.print(this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities"));
        try (InputStream in = this.get("wfs?service=WFS&version=2.0.0&request=getCapabilities");){
            Parser p = new Parser((Configuration)new WFSConfiguration());
            p.setValidating(true);
            p.validate(in);
            for (Exception e : p.getValidationErrors()) {
                LOGGER.info(e.getLocalizedMessage());
            }
            Assert.assertTrue((boolean)p.getValidationErrors().isEmpty());
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        Document doc = this.getAsDOM("sf/PrimitiveGeoFeature/wfs?service=WFS&version=2.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        Assert.assertEquals((Object)"WFS_Capabilities", (Object)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength());
        Assert.assertEquals((long)0L, (long)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
    }

    @Test
    public void testSOAP() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><GetCapabilities service=\"WFS\"  xmlns=\"http://www.opengis.net/wfs/2.0\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0  http://schemas.opengis.net/wfs/2.0/wfs.xsd\"/> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:WFS_Capabilities").getLength());
    }

    @Test
    public void testAcceptVersions11() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetCapabilities&acceptversions=1.1.0,1.0.0");
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.0", (Object)dom.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testAcceptVersions11WithVersion() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetCapabilities&version=2.0.0&acceptversions=1.1.0,1.0.0");
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.0", (Object)dom.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testAcceptFormats() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetCapabilities&version=2.0.0");
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        response = this.getAsServletResponse("wfs?request=GetCapabilities&version=2.0.0&acceptformats=text/xml");
        Assert.assertEquals((Object)"text/xml", (Object)response.getContentType());
    }

    @Test
    public void testGetPropertyValueFormat() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetCapabilities&version=2.0.0&acceptformats=text/xml");
        XMLAssert.assertXpathEvaluatesTo((String)"application/gml+xml; version=3.2", (String)"//ows:Operation[@name='GetPropertyValue']/ows:Parameter[@name='outputFormat']/ows:AllowedValues/ows:Value[1]", (Document)dom);
    }

    @Test
    public void testCreateStoredQuery() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetCapabilities&version=2.0.0&acceptformats=text/xml");
        XMLAssert.assertXpathEvaluatesTo((String)"urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression", (String)"//ows:Operation[@name='CreateStoredQuery']/ows:Parameter[@name='language']/ows:AllowedValues/ows:Value[1]", (Document)dom);
    }

    @Test
    public void testMetadataLinks() throws Exception {
        FeatureTypeInfo mpolys = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockTestData.MPOLYGONS));
        MetadataLinkInfo ml = this.getCatalog().getFactory().createMetadataLink();
        ml.setMetadataType("FGDC");
        ml.setType("text/html");
        ml.setContent("http://www.geoserver.org");
        mpolys.getMetadataLinks().add(ml);
        this.getCatalog().save((ResourceInfo)mpolys);
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@xlink:href='http://www.geoserver.org']", doc).getLength());
    }

    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        FeatureTypeInfo mpolys = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockTestData.MPOLYGONS));
        MetadataLinkInfo ml = this.getCatalog().getFactory().createMetadataLink();
        ml.setMetadataType("FGDC");
        ml.setType("text/html");
        ml.setContent("/metadata?key=value");
        mpolys.getMetadataLinks().add(ml);
        this.getCatalog().save((ResourceInfo)mpolys);
        String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL", doc).getLength());
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes("//wfs:FeatureType[wfs:Name='cgf:MPolygons']/wfs:MetadataURL[@xlink:href='" + proxyBaseUrl + "/metadata?key=value']", doc).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherCRS() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.getSRS().add("4326");
        wfs.getSRS().add("3857");
        wfs.getSRS().add("3003");
        try {
            this.getGeoServer().save((ServiceInfo)wfs);
            Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
            List enabledTypes = this.getCatalog().getFeatureTypes();
            for (FeatureTypeInfo ft : enabledTypes) {
                if (!ft.enabled()) continue;
                String prefixedName = ft.prefixedName();
                String base = "//wfs:FeatureType[wfs:Name =\"" + prefixedName + "\"]";
                XMLAssert.assertXpathExists((String)base, (Document)doc);
                boolean wgs84Native = "EPSG:4326".equals(ft.getSRS());
                if (wgs84Native) {
                    XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(" + base + "/wfs:OtherCRS)"), (Document)doc);
                } else {
                    XMLAssert.assertXpathEvaluatesTo((String)"3", (String)("count(" + base + "/wfs:OtherCRS)"), (Document)doc);
                    XMLAssert.assertXpathExists((String)(base + "[wfs:OtherCRS = 'urn:ogc:def:crs:EPSG::4326']"), (Document)doc);
                }
                XMLAssert.assertXpathExists((String)(base + "[wfs:OtherCRS = 'urn:ogc:def:crs:EPSG::3003']"), (Document)doc);
                XMLAssert.assertXpathExists((String)(base + "[wfs:OtherCRS = 'urn:ogc:def:crs:EPSG::3857']"), (Document)doc);
            }
        }
        finally {
            wfs.getSRS().clear();
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOtherSRSSingleTypeOverride() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.getSRS().add("4326");
        wfs.getSRS().add("3857");
        wfs.getSRS().add("3003");
        String polygonsName = this.getLayerId(MockData.POLYGONS);
        FeatureTypeInfo polygons = this.getCatalog().getFeatureTypeByName(polygonsName);
        polygons.getResponseSRS().add("32632");
        polygons.setOverridingServiceSRS(true);
        try {
            this.getGeoServer().save((ServiceInfo)wfs);
            this.getCatalog().save((ResourceInfo)polygons);
            Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getCapabilities");
            String base = "//wfs:FeatureType[wfs:Name =\"" + polygonsName + "\"]";
            XMLAssert.assertXpathExists((String)base, (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(" + base + "/wfs:OtherCRS)"), (Document)doc);
            XMLAssert.assertXpathExists((String)(base + "[wfs:OtherCRS = 'urn:ogc:def:crs:EPSG::32632']"), (Document)doc);
        }
        finally {
            wfs.getSRS().clear();
            this.getGeoServer().save((ServiceInfo)wfs);
            polygons.setOverridingServiceSRS(false);
            polygons.getResponseSRS().clear();
            this.getCatalog().save((ResourceInfo)polygons);
        }
    }

    @Test
    public void testGetSections() throws Exception {
        this.testSections("", 1, 1, 1, 1, 1);
        this.testSections("All", 1, 1, 1, 1, 1);
        this.testSections("ServiceIdentification", 1, 0, 0, 0, 0);
        this.testSections("ServiceProvider", 0, 1, 0, 0, 0);
        this.testSections("OperationsMetadata", 0, 0, 1, 0, 0);
        this.testSections("FeatureTypeList", 0, 0, 0, 1, 0);
        this.testSections("Filter_Capabilities", 0, 0, 0, 0, 1);
        this.testSections("ServiceIdentification,Filter_Capabilities", 1, 0, 0, 0, 1);
        this.testSections("ServiceIdentification,Filter_Capabilities,All", 1, 1, 1, 1, 1);
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetCapabilities&sections=FooBar");
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "sections");
    }

    protected void testSections(String sections, int serviceIdentification, int serviceProvider, int operationsMetadata, int featureTypeList, int filterCapabilities) throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetCapabilities&sections=" + sections);
        XMLAssert.assertXpathEvaluatesTo((String)("" + serviceIdentification), (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + serviceProvider), (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + operationsMetadata), (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + featureTypeList), (String)"count(//wfs:FeatureTypeList)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + filterCapabilities), (String)"count(//fes:Filter_Capabilities)", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableLocking() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setServiceLevel(WFSInfo.ServiceLevel.TRANSACTIONAL);
        gs.save((ServiceInfo)wfs);
        try {
            Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
            XMLAssert.assertXpathEvaluatesTo((String)"TRUE", (String)"//ows:Constraint[@name='ImplementsTransactionalWFS']/ows:DefaultValue", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"FALSE", (String)"//ows:Constraint[@name='ImplementsLockingWFS']/ows:DefaultValue", (Document)doc);
            XMLAssert.assertXpathExists((String)"//ows:Operation[@name='Transaction']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='LockFeature']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='GetFeatureWithLock']", (Document)doc);
        }
        finally {
            wfs.setServiceLevel(WFSInfo.ServiceLevel.COMPLETE);
            gs.save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableTransaction() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setServiceLevel(WFSInfo.ServiceLevel.BASIC);
        gs.save((ServiceInfo)wfs);
        try {
            Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
            XMLAssert.assertXpathEvaluatesTo((String)"FALSE", (String)"//ows:Constraint[@name='ImplementsTransactionalWFS']/ows:DefaultValue", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"FALSE", (String)"//ows:Constraint[@name='ImplementsLockingWFS']/ows:DefaultValue", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='Transaction']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='LockFeature']", (Document)doc);
            XMLAssert.assertXpathNotExists((String)"//ows:Operation[@name='GetFeatureWithLock']", (Document)doc);
        }
        finally {
            wfs.setServiceLevel(WFSInfo.ServiceLevel.COMPLETE);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testInternationalContent() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for fti fifteen");
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        fti.setInternationalTitle((InternationalString)title);
        fti.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("english keyword");
        keywordInfo.setLanguage(Locale.ENGLISH.getLanguage());
        Keyword keywordInfo2 = new Keyword("parola chiave");
        keywordInfo2.setLanguage(Locale.ITALIAN.getLanguage());
        fti.getKeywords().add(keywordInfo);
        fti.getKeywords().add(keywordInfo2);
        catalog.save((ResourceInfo)fti);
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WFS service");
        title.add(Locale.ITALIAN, "titolo italiano servizio WFS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WFS service");
        _abstract.add(Locale.ITALIAN, "abstract italiano servizio WFS");
        wfs.setInternationalTitle((InternationalString)title);
        wfs.setInternationalAbstract((InternationalString)_abstract);
        gs.save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0&acceptLanguages=it");
        String service = "//ows:ServiceIdentification";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano servizio WFS", (String)(service + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano servizio WFS", (String)(service + "/ows:Abstract"), (Document)doc);
        String fifteenLayer = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType[wfs:Name='cdf:Fifteen']";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano", (String)(fifteenLayer + "/wfs:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano", (String)(fifteenLayer + "/wfs:Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"parola chiave", (String)(fifteenLayer + "/ows:Keywords/ows:Keyword"), (Document)doc);
    }

    @Test
    public void testAcceptLanguagesInvalid() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for fti fifteen");
        _abstract.add(Locale.ITALIAN, "abstract italiano");
        fti.setInternationalTitle((InternationalString)title);
        fti.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("english keyword");
        keywordInfo.setLanguage(Locale.ENGLISH.getLanguage());
        Keyword keywordInfo2 = new Keyword("parola chiave");
        keywordInfo2.setLanguage(Locale.ITALIAN.getLanguage());
        fti.getKeywords().add(keywordInfo);
        fti.getKeywords().add(keywordInfo2);
        catalog.save((ResourceInfo)fti);
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WFS service");
        title.add(Locale.ITALIAN, "titolo italiano servizio WFS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WFS service");
        _abstract.add(Locale.ITALIAN, "abstract italiano servizio WFS");
        wfs.setInternationalTitle((InternationalString)title);
        wfs.setInternationalAbstract((InternationalString)_abstract);
        gs.save((ServiceInfo)wfs);
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&request=getCapabilities&version=2.0.0&acceptLanguages=fre");
        String responseMsg = response.getContentAsString();
        Assert.assertTrue((boolean)responseMsg.contains("Content has been requested in one of the following languages: fre. But supported languages are: en,it"));
    }

    @Test
    public void testInternationalContentMultipleLanguages() throws Exception {
        GeoServer gs = this.getGeoServer();
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        GrowableInternationalString _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for fti fifteen");
        _abstract.add(Locale.FRENCH, "resum\u00e9");
        fti.setInternationalTitle((InternationalString)title);
        fti.setInternationalAbstract((InternationalString)_abstract);
        Keyword keywordInfo = new Keyword("english keyword");
        keywordInfo.setLanguage(Locale.ENGLISH.getLanguage());
        Keyword keywordInfo2 = new Keyword("parola chiave");
        keywordInfo2.setLanguage(Locale.ITALIAN.getLanguage());
        fti.getKeywords().add(keywordInfo);
        fti.getKeywords().add(keywordInfo2);
        catalog.save((ResourceInfo)fti);
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for WFS service");
        title.add(Locale.ITALIAN, "titolo italiano servizio WFS");
        _abstract = new GrowableInternationalString();
        _abstract.add(Locale.ENGLISH, "a i18n abstract for WFS service");
        _abstract.add(Locale.ITALIAN, "abstract italiano servizio WFS");
        wfs.setInternationalTitle((InternationalString)title);
        wfs.setInternationalAbstract((InternationalString)_abstract);
        gs.save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0&acceptLanguages=it,fr", StandardCharsets.UTF_8.name());
        String service = "//ows:ServiceIdentification";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano servizio WFS", (String)(service + "/ows:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"abstract italiano servizio WFS", (String)(service + "/ows:Abstract"), (Document)doc);
        String fifteenLayer = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType[wfs:Name='cdf:Fifteen']";
        XMLAssert.assertXpathEvaluatesTo((String)"titolo italiano", (String)(fifteenLayer + "/wfs:Title"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"resum\u00e9", (String)(fifteenLayer + "/wfs:Abstract"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"parola chiave", (String)(fifteenLayer + "/ows:Keywords/ows:Keyword"), (Document)doc);
    }

    @Test
    public void testAcceptLanguagesParameter() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(Locale.ITALIAN, "titolo italiano");
        fti.setInternationalTitle((InternationalString)title);
        catalog.save((ResourceInfo)fti);
        Document dom = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0&acceptLanguages=it");
        XMLAssert.assertXpathEvaluatesTo((String)"src/test/resources/geoserver/wfs?Language=it", (String)"//ows:DCP/ows:HTTP/ows:Get/@xlink:href", (Document)dom);
    }

    @Test
    public void testNullLocale() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(this.getLayerId(MockData.FIFTEEN));
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ENGLISH, "a i18n title for fti fifteen");
        title.add(null, "null locale");
        fti.setInternationalTitle((InternationalString)title);
        catalog.save((ResourceInfo)fti);
        Document dom = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0");
        XMLAssert.assertXpathEvaluatesTo((String)"src/test/resources/geoserver/wfs", (String)"//ows:DCP/ows:HTTP/ows:Get/@xlink:href", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInternationalContentContact() throws Exception {
        ContactInfo old = this.getGeoServer().getSettings().getContact();
        try {
            GrowableInternationalString person = new GrowableInternationalString();
            person.add(Locale.ITALIAN, "I'm an italian person");
            person.add(Locale.ENGLISH, "I'm an english person");
            ContactInfoImpl contactInfo = new ContactInfoImpl();
            contactInfo.setInternationalContactPerson((InternationalString)person);
            GrowableInternationalString org = new GrowableInternationalString();
            org.add(Locale.ITALIAN, "I'm an italian organization");
            org.add(Locale.ENGLISH, "I'm an english organization");
            contactInfo.setInternationalContactOrganization((InternationalString)org);
            GrowableInternationalString email = new GrowableInternationalString();
            email.add(Locale.ITALIAN, "italian@person.it");
            email.add(Locale.ENGLISH, "english@person.com");
            contactInfo.setInternationalContactEmail((InternationalString)email);
            GrowableInternationalString position = new GrowableInternationalString();
            position.add(Locale.ITALIAN, "Cartografo");
            position.add(Locale.ENGLISH, "Cartographer");
            contactInfo.setInternationalContactPosition((InternationalString)position);
            GrowableInternationalString tel = new GrowableInternationalString();
            tel.add(Locale.ITALIAN, "0558077333");
            tel.add(Locale.ENGLISH, "02304566607");
            contactInfo.setInternationalContactVoice((InternationalString)tel);
            GrowableInternationalString fax = new GrowableInternationalString();
            fax.add(Locale.ITALIAN, "0557777333");
            fax.add(Locale.ENGLISH, "0023030948");
            contactInfo.setInternationalContactFacsimile((InternationalString)fax);
            GrowableInternationalString address = new GrowableInternationalString();
            address.add(Locale.ITALIAN, "indirizzo");
            address.add(Locale.ENGLISH, "address");
            contactInfo.setInternationalAddressDeliveryPoint((InternationalString)address);
            GrowableInternationalString country = new GrowableInternationalString();
            country.add(Locale.ITALIAN, "Italia");
            country.add(Locale.ENGLISH, "England");
            contactInfo.setInternationalAddressCountry((InternationalString)country);
            GrowableInternationalString city = new GrowableInternationalString();
            city.add(Locale.ITALIAN, "Roma");
            city.add(Locale.ENGLISH, "London");
            contactInfo.setInternationalAddressCity((InternationalString)city);
            GrowableInternationalString postalCode = new GrowableInternationalString();
            postalCode.add(Locale.ITALIAN, "50021");
            postalCode.add(Locale.ENGLISH, "34234");
            contactInfo.setInternationalAddressPostalCode((InternationalString)postalCode);
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact((ContactInfo)contactInfo);
            this.getGeoServer().save(global);
            Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=2.0.0&AcceptLanguages=en");
            String serviceProv = "//ows:ServiceProvider";
            String pers = serviceProv + "/ows:ServiceContact";
            String contactInf = pers + "/ows:ContactInfo";
            String addrInfo = contactInf + "/ows:Address";
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an english organization", (String)(serviceProv + "/ows:ProviderName"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"I'm an english person", (String)(pers + "/ows:IndividualName"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Cartographer", (String)(pers + "/ows:PositionName"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"02304566607", (String)(contactInf + "/ows:Phone/ows:Voice"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"0023030948", (String)(contactInf + "/ows:Phone/ows:Facsimile"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"english@person.com", (String)(addrInfo + "/ows:ElectronicMailAddress"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"address", (String)(addrInfo + "/ows:DeliveryPoint"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"London", (String)(addrInfo + "/ows:City"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"England", (String)(addrInfo + "/ows:Country"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"34234", (String)(addrInfo + "/ows:PostalCode"), (Document)doc);
        }
        finally {
            GeoServerInfo global = this.getGeoServer().getGlobal();
            global.getSettings().setContact(old);
            this.getGeoServer().save(global);
        }
    }

    @Test
    public void testIauFeatureTypes() throws Exception {
        Document doc = this.getAsDOM("iau/wfs?service=WFS&version=2.0.0&request=getCapabilities");
        this.print(doc);
        String poiXPath = "//wfs:FeatureTypeList/wfs:FeatureType[wfs:Name = 'iau:MarsPoi']";
        XMLAssert.assertXpathExists((String)poiXPath, (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"urn:ogc:def:crs:IAU::49900", (String)(poiXPath + "/wfs:DefaultCRS "), (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCiteCompliant() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            Document dom = this.getAsDOM("wfs?service=WFS&request=GetCapabilities");
            Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)dom.getDocumentElement().getNodeName());
            MockHttpServletResponse response = this.getAsServletResponse("wfs?request=GetCapabilities&version=2.0.0");
            Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
            Assert.assertEquals((long)400L, (long)response.getStatus());
            dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
            Element root = dom.getDocumentElement();
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)root.getNodeName());
            Assert.assertEquals((Object)"2.0.0", (Object)root.getAttribute("version"));
            Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:Exception").getLength());
            Element ex = (Element)dom.getElementsByTagName("ows:Exception").item(0);
            Assert.assertEquals((Object)"MissingParameterValue", (Object)ex.getAttribute("exceptionCode"));
            Assert.assertEquals((Object)"service", (Object)ex.getAttribute("locator"));
            Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("ows:ExceptionText").getLength());
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }
}

