/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetPropertyValueTest
extends WFS20TestSupport {
    @Test
    public void testPOST() throws Exception {
        String xml = "<wfs:GetPropertyValue service='WFS' version='2.0.0' xmlns:sf='" + MockData.SF_URI + "'    xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' valueReference='pointProperty'> <wfs:Query typeNames='sf:PrimitiveGeoFeature'/> </wfs:GetPropertyValue>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:ValueCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member/sf:pointProperty/gml:Point)", (Document)dom);
    }

    @Test
    public void testGET() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetPropertyValue&typeNames=sf:PrimitiveGeoFeature&valueReference=pointProperty");
        Assert.assertEquals((Object)"wfs:ValueCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member/sf:pointProperty/gml:Point)", (Document)dom);
    }

    @Test
    public void testGETAlternateNamespace() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetPropertyValue&typeNames=abcd:PrimitiveGeoFeature&valueReference=pointProperty&namespaces=xmlns(abcd," + MockData.SF_URI + ")");
        Assert.assertEquals((Object)"wfs:ValueCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:member/sf:pointProperty/gml:Point)", (Document)dom);
    }

    @Test
    public void testEmptyValueReference() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetPropertyValue&typeNames=sf:PrimitiveGeoFeature&valueReference=");
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "valueReference");
    }

    @Test
    public void testGmlId() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetPropertyValue&typeNames=sf:PrimitiveGeoFeature&valueReference=@gml:id");
        this.print(dom);
        Assert.assertEquals((Object)"wfs:ValueCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//wfs:member/gml:identifier)", (Document)dom);
    }
}

