/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.net.URL;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geotools.api.feature.type.Name;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class MultiDimensionTest
extends WFS20TestSupport {
    private XpathEngine xpath;

    @Before
    public void setupXPathEngine() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        DataStoreInfo storeInfo = MultiDimensionTest.createShapefileDataStore(this.getCatalog(), "tasmania_roads", "tasmania_roads.shp");
        MultiDimensionTest.createShapeLayer(this.getCatalog(), storeInfo);
    }

    @Test
    public void testGetZDimension() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=gs:tasmania_roads&version=2.0.0&service=wfs");
        this.print(dom);
        Assert.assertEquals((Object)"tasmania_roads.1", (Object)this.xpath.evaluate("//gs:tasmania_roads/@gml:id", dom));
        Assert.assertEquals((Object)"3", (Object)this.xpath.evaluate("//gs:tasmania_roads/gs:the_geom/gml:MultiCurve/@srsDimension", dom));
    }

    private static DataStoreInfo createShapefileDataStore(Catalog catalog, String name, String file) {
        URL url = MultiDimensionTest.class.getResource(file);
        MatcherAssert.assertThat((Object)url, (Matcher)Matchers.notNullValue());
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        DataStoreInfo storeInfo = catalogBuilder.buildDataStore(name);
        storeInfo.setType("Shapefile");
        storeInfo.getConnectionParameters().put(ShapefileDataStoreFactory.URLP.key, url);
        catalog.add((StoreInfo)storeInfo);
        storeInfo = (DataStoreInfo)catalog.getStoreByName(name, DataStoreInfo.class);
        MatcherAssert.assertThat((Object)storeInfo, (Matcher)Matchers.notNullValue());
        return storeInfo;
    }

    private static LayerInfo createShapeLayer(Catalog catalog, DataStoreInfo storeInfo) throws Exception {
        CatalogBuilder catalogBuilder = new CatalogBuilder(catalog);
        catalogBuilder.setStore((StoreInfo)storeInfo);
        Name typeName = (Name)storeInfo.getDataStore(null).getNames().get(0);
        FeatureTypeInfo featureTypeInfo = catalogBuilder.buildFeatureType(typeName);
        catalog.add((ResourceInfo)featureTypeInfo);
        LayerInfo layerInfo = catalogBuilder.buildLayer(featureTypeInfo);
        catalog.add(layerInfo);
        layerInfo = catalog.getLayerByName(typeName.getLocalPart());
        MatcherAssert.assertThat((Object)layerInfo, (Matcher)Matchers.notNullValue());
        return layerInfo;
    }
}

