/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class SrsNameRequestTest
extends WFS20TestSupport {
    private static final String EPSG_CODE_SRSNAME = "EPSG:4326";
    private static final String HTTP_URL_SRSNAME = "http://www.opengis.net/gml/srs/epsg.xml#4326";
    private static final String URN_EXPERIMENTAL_SRSNAME = "urn:x-ogc:def:crs:EPSG::4326";
    private static final String URN_SRSNAME = "urn:ogc:def:crs:EPSG::4326";
    private static final String HTTP_URI_SRSNAME = "http://www.opengis.net/def/crs/EPSG/0/4326";
    private static final String TYPE_NAME = "sf:PrimitiveGeoFeature";
    private static final String GML_ID = "PrimitiveGeoFeature.f015";
    private static final String LON_LAT_BBOX = "34.939,-10.521,34.941,-10.519";
    private static final String LAT_LON_BBOX = "-10.521,34.939,-10.519,34.941";
    private static final String LON_LAT_DATA = "34.94 -10.52";
    private static final String LAT_LON_DATA = "-10.52 34.94";
    private static final String NUMBER_RETURNED_XPATH = "//wfs:FeatureCollection/@numberReturned";
    private static final String GML_ID_XPATH = "//sf:PrimitiveGeoFeature[@gml:id=\"PrimitiveGeoFeature.f015\"]/@gml:id";
    private static final String DATA_XPATH = "//sf:PrimitiveGeoFeature[@gml:id=\"PrimitiveGeoFeature.f015\"]/sf:pointProperty/gml:Point/gml:pos";
    private static final String SRSNAME_XPATH = "//sf:PrimitiveGeoFeature[@gml:id=\"PrimitiveGeoFeature.f015\"]/sf:pointProperty/gml:Point/@srsName";

    private void runTest(String requestSrsName, String requestBbox, int expectedNumberReturned, String expectedSrsName, String expectedData) throws Exception {
        StringBuilder requestBuilder = new StringBuilder("wfs");
        requestBuilder.append("?version=2.0.0");
        requestBuilder.append("&request=GetFeature");
        requestBuilder.append("&typenames=");
        requestBuilder.append(TYPE_NAME);
        if (requestSrsName != null) {
            requestBuilder.append("&srsname=");
            requestBuilder.append(this.encodeSrsName(requestSrsName));
        }
        if (requestBbox != null) {
            requestBuilder.append("&bbox=");
            requestBuilder.append(this.encodeSrsName(requestBbox));
        }
        Document response = this.getAsDOM(requestBuilder.toString());
        XMLAssert.assertXpathEvaluatesTo((String)Integer.toString(expectedNumberReturned), (String)NUMBER_RETURNED_XPATH, (Document)response);
        if (expectedNumberReturned > 0) {
            XMLAssert.assertXpathEvaluatesTo((String)GML_ID, (String)GML_ID_XPATH, (Document)response);
            XMLAssert.assertXpathEvaluatesTo((String)expectedSrsName, (String)SRSNAME_XPATH, (Document)response);
            XMLAssert.assertXpathEvaluatesTo((String)expectedData, (String)DATA_XPATH, (Document)response);
        }
    }

    private String encodeSrsName(String srsName) {
        return srsName.replace("#", "%23");
    }

    private String buildBbox(String bbox, String srsName) {
        StringBuilder bboxBuilder = new StringBuilder(bbox);
        bboxBuilder.append(",");
        bboxBuilder.append(srsName);
        return bboxBuilder.toString();
    }

    @Test
    public void testEpsgCode() throws Exception {
        this.runTest(EPSG_CODE_SRSNAME, null, 5, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testEpsgCodeNativeBbox() throws Exception {
        this.runTest(EPSG_CODE_SRSNAME, LAT_LON_BBOX, 1, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testEpsgCodeNativeBboxWrongAxisOrder() throws Exception {
        this.runTest(EPSG_CODE_SRSNAME, LON_LAT_BBOX, 0, null, null);
    }

    @Test
    public void testEpsgCodeBbox() throws Exception {
        this.runTest(EPSG_CODE_SRSNAME, this.buildBbox(LON_LAT_BBOX, EPSG_CODE_SRSNAME), 1, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testEpsgCodeBboxWrongAxisOrder() throws Exception {
        this.runTest(EPSG_CODE_SRSNAME, this.buildBbox(LAT_LON_BBOX, EPSG_CODE_SRSNAME), 0, null, null);
    }

    @Test
    public void testHttpUrl() throws Exception {
        this.runTest(HTTP_URL_SRSNAME, null, 5, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testHttpUrlNativeBbox() throws Exception {
        this.runTest(HTTP_URL_SRSNAME, LAT_LON_BBOX, 1, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testHttpUrlNativeBboxWrongAxisOrder() throws Exception {
        this.runTest(HTTP_URL_SRSNAME, LON_LAT_BBOX, 0, null, null);
    }

    @Test
    public void testHttpUrlBbox() throws Exception {
        this.runTest(HTTP_URL_SRSNAME, this.buildBbox(LON_LAT_BBOX, HTTP_URL_SRSNAME), 1, HTTP_URL_SRSNAME, LON_LAT_DATA);
    }

    @Test
    public void testHttpUrlBboxWrongAxisOrder() throws Exception {
        this.runTest(HTTP_URL_SRSNAME, this.buildBbox(LAT_LON_BBOX, HTTP_URL_SRSNAME), 0, null, null);
    }

    @Test
    public void testUrnExperimental() throws Exception {
        this.runTest(URN_EXPERIMENTAL_SRSNAME, null, 5, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnExperimentalNativeBbox() throws Exception {
        this.runTest(URN_EXPERIMENTAL_SRSNAME, LAT_LON_BBOX, 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnExperimentalNativeBboxWrongAxisOrder() throws Exception {
        this.runTest(URN_EXPERIMENTAL_SRSNAME, LON_LAT_BBOX, 0, null, null);
    }

    @Test
    public void testUrnExperimentalBbox() throws Exception {
        this.runTest(URN_EXPERIMENTAL_SRSNAME, this.buildBbox(LAT_LON_BBOX, URN_EXPERIMENTAL_SRSNAME), 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnExperimentalBboxWrongAxisOrder() throws Exception {
        this.runTest(URN_EXPERIMENTAL_SRSNAME, this.buildBbox(LON_LAT_BBOX, URN_EXPERIMENTAL_SRSNAME), 0, null, null);
    }

    @Test
    public void testUrn() throws Exception {
        this.runTest(URN_SRSNAME, null, 5, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnNativeBbox() throws Exception {
        this.runTest(URN_SRSNAME, LAT_LON_BBOX, 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnNativeBboxWrongAxisOrder() throws Exception {
        this.runTest(URN_SRSNAME, LON_LAT_BBOX, 0, null, null);
    }

    @Test
    public void testUrnBbox() throws Exception {
        this.runTest(URN_SRSNAME, this.buildBbox(LAT_LON_BBOX, URN_SRSNAME), 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testUrnBboxWrongAxisOrder() throws Exception {
        this.runTest(URN_SRSNAME, this.buildBbox(LON_LAT_BBOX, URN_SRSNAME), 0, null, null);
    }

    @Test
    public void testHttpUri() throws Exception {
        this.runTest(HTTP_URI_SRSNAME, null, 5, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testHttpUriNativeBbox() throws Exception {
        this.runTest(HTTP_URI_SRSNAME, LAT_LON_BBOX, 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testHttpUriNativeBboxWrongAxisOrder() throws Exception {
        this.runTest(HTTP_URI_SRSNAME, LON_LAT_BBOX, 0, null, null);
    }

    @Test
    public void testHttpUriBbox() throws Exception {
        this.runTest(HTTP_URI_SRSNAME, this.buildBbox(LAT_LON_BBOX, HTTP_URI_SRSNAME), 1, URN_SRSNAME, LAT_LON_DATA);
    }

    @Test
    public void testHttpUriBboxWrongAxisOrder() throws Exception {
        this.runTest(HTTP_URI_SRSNAME, this.buildBbox(LON_LAT_BBOX, HTTP_URI_SRSNAME), 0, null, null);
    }
}

