/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class StoredQueryTest
extends WFS20TestSupport {
    @Before
    public void clearQueries() {
        WFSInfo wfsInfo = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        new StoredQueryProvider(this.getCatalog(), wfsInfo, true).removeAll();
    }

    @Test
    public void testListStoredQueries() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wfs?request=ListStoredQueries&service=wfs&version=2.0.0");
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        XMLAssert.assertXpathExists((String)("//wfs:StoredQuery[@id = '" + StoredQuery.DEFAULT.getName() + "']"), (Document)dom);
        FeatureTypeSchemaBuilder.GML3 sb = new FeatureTypeSchemaBuilder.GML3(this.getGeoServer());
        WFSConfiguration configuration = new WFSConfiguration(this.getGeoServer(), (FeatureTypeSchemaBuilder)sb, new WFS((FeatureTypeSchemaBuilder)sb));
        Parser parser = new Parser((Configuration)configuration);
        parser.parse((InputStream)new ByteArrayInputStream(response.getContentAsByteArray()));
        Assert.assertEquals((long)0L, (long)parser.getValidationErrors().size());
    }

    @Test
    public void testListStoredQueries2() throws Exception {
        this.testCreateStoredQuery();
        Document dom = this.getAsDOM("wfs?request=ListStoredQueries&service=wfs&version=2.0.0");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
        XMLAssert.assertXpathExists((String)("//wfs:StoredQuery[@id = '" + StoredQuery.DEFAULT.getName() + "']"), (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
    }

    @Test
    public void testCreateUnknownLanguage() throws Exception {
        String xml = "<CreateStoredQuery xmlns=\"http://www.opengis.net/wfs/2.0\" service=\"WFS\" version=\"2.0.0\">\n  <StoredQueryDefinition xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                          id=\"urn:example:wfs2-query:InvalidLang\">\n      <Title>GetFeatureByTypeName</Title>\n      <Abstract>Returns feature representations by type name.</Abstract>\n      <Parameter name=\"typeName\" type=\"xsd:QName\">\n         <Abstract>Qualified name of feature type (required).</Abstract>\n      </Parameter>\n      <QueryExpressionText isPrivate=\"false\" language=\"http://qry.example.org\" returnFeatureTypes=\"\">\n         <Query typeNames=\"${typeName}\"/>\n      </QueryExpressionText>\n  </StoredQueryDefinition>\n</CreateStoredQuery>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "language");
    }

    @Test
    public void testCreateStoredQuery() throws Exception {
        String xml = "<wfs:ListStoredQueries service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'/>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:ListStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
        xml = this.getCreatePrimitiveWithinQuery(false);
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=ListStoredQueries");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:ReturnFeatureType[text() = 'sf:PrimitiveGeoFeature']", (Document)dom);
    }

    @Test
    public void testDuplicateStoredQuery() throws Exception {
        String xml = this.getCreatePrimitiveWithinQuery(false);
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        this.checkOws11Exception(dom, "2.0.0", "DuplicateStoredQueryIdValue", "myStoredQuery");
    }

    public String getCreatePrimitiveWithinQuery(boolean emptyReturnFeatureTypes) {
        return this.getCreatePrimitiveWithinQuery(emptyReturnFeatureTypes, "myStoredQuery");
    }

    public String getCreatePrimitiveWithinQuery(boolean emptyReturnFeatureTypes, String id) {
        String returnFeatureTypes = emptyReturnFeatureTypes ? "" : "sf:PrimitiveGeoFeature";
        return "<wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:myns='http://www.someserver.com/myns'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='" + id + "'>       <wfs:Parameter name='AreaOfInterest' type='gml:Polygon'/>       <wfs:QueryExpressionText            returnFeatureTypes='" + returnFeatureTypes + "'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'>          <wfs:Query typeNames='sf:PrimitiveGeoFeature'>             <fes:Filter>                <fes:Within>                   <fes:ValueReference>pointProperty</fes:ValueReference>                   ${AreaOfInterest}                </fes:Within>             </fes:Filter>          </wfs:Query>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery>";
    }

    @Test
    public void testCreateStoredQueryMismatchingTypes() throws Exception {
        Object xml = "<wfs:ListStoredQueries service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'/>";
        Document dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"wfs:ListStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
        xml = "<wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='myStoredQuery'>       <wfs:Parameter name='AreaOfInterest' type='gml:Polygon'/>       <wfs:QueryExpressionText            returnFeatureTypes='sf:PrimitiveGeoFeature'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'>          <wfs:Query typeNames='sf:AggregateGeoFeature'>             <fes:Filter>                <fes:Within>                   <fes:ValueReference>pointProperty</fes:ValueReference>                   ${AreaOfInterest}                </fes:Within>             </fes:Filter>          </wfs:Query>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery>";
        dom = this.postAsDOM("wfs", (String)xml);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wfs?request=ListStoredQueries");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
    }

    @Test
    public void testDescribeStoredQueries() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DescribeStoredQueries&storedQueryId=myStoredQuery", 400);
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "STOREDQUERY_ID");
        this.testCreateStoredQuery();
        String xml = "<wfs:DescribeStoredQueries xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS'><wfs:StoredQueryId>myStoredQuery</wfs:StoredQueryId></wfs:DescribeStoredQueries>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:DescribeStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//wfs:StoredQueryDescription[@id='myStoredQuery']", (Document)dom);
    }

    @Test
    public void testDescribeStoredQueries2() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DescribeStoredQueries&storedQuery_Id=myStoredQuery");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.testCreateStoredQuery();
        dom = this.getAsDOM("wfs?request=DescribeStoredQueries&storedQuery_Id=myStoredQuery");
        Assert.assertEquals((Object)"wfs:DescribeStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//wfs:StoredQueryDescription[@id='myStoredQuery']", (Document)dom);
    }

    @Test
    public void testDescribeDefaultStoredQuery() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DescribeStoredQueries&storedQueryId=" + StoredQuery.DEFAULT.getName());
        Assert.assertEquals((Object)"wfs:DescribeStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)("//wfs:StoredQueryDescription[@id = '" + StoredQuery.DEFAULT.getName() + "']"), (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:Parameter[@name = 'ID']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:QueryExpressionText[@isPrivate = 'true']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//wfs:QueryExpressionText/*", (Document)dom);
    }

    @Test
    public void testDropStoredQuery() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DropStoredQuery&id=myStoredQuery");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.testCreateStoredQuery();
        String xml = "<wfs:DropStoredQuery xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS' id='myStoredQuery'/>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:DropStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=DropStoredQuery&id=myStoredQuery");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testDropStoredQuery2() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DropStoredQuery&storedQuery_id=myStoredQuery");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        this.testCreateStoredQuery();
        dom = this.getAsDOM("wfs?request=DropStoredQuery&storedQuery_id=myStoredQuery");
        Assert.assertEquals((Object)"wfs:DropStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=DropStoredQuery&storedQuery_id=myStoredQuery");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testCreateStoredQuerySOAP() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:myns='http://www.someserver.com/myns'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='myStoredQuery'>       <wfs:Parameter name='AreaOfInterest' type='gml:Polygon'/>       <wfs:QueryExpressionText            returnFeatureTypes='sf:PrimitiveGeoFeature'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'>          <wfs:Query typeNames='sf:PrimitiveGeoFeature'>             <fes:Filter>                <fes:Within>                   <fes:ValueReference>pointProperty</fes:ValueReference>                   ${AreaOfInterest}                </fes:Within>             </fes:Filter>          </wfs:Query>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:CreateStoredQueryResponse").getLength());
    }

    @Test
    public void testDescribeStoredQueriesSOAP() throws Exception {
        this.testCreateStoredQuery();
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:DescribeStoredQueries xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS'><wfs:StoredQueryId>myStoredQuery</wfs:StoredQueryId></wfs:DescribeStoredQueries> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:DescribeStoredQueriesResponse").getLength());
    }

    @Test
    public void testListStoredQueriesSOAP() throws Exception {
        this.testCreateStoredQuery();
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:ListStoredQueries service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'/> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:ListStoredQueriesResponse").getLength());
    }

    @Test
    public void testDropStoredQuerySOAP() throws Exception {
        this.testCreateStoredQuery();
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:DropStoredQuery service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0' id='myStoredQuery'/> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:DropStoredQueryResponse").getLength());
    }

    @Test
    public void testDropUnknownStoredQuery() throws Exception {
        Document dom = this.getAsDOM("wfs?request=DropStoredQuery&storedQuery_Id=myStoredQuery", 400);
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "id");
    }

    @Test
    public void testCreateParametrizedOnTypename() throws Exception {
        String xml = "<CreateStoredQuery xmlns=\"http://www.opengis.net/wfs/2.0\" service=\"WFS\" version=\"2.0.0\">\n  <StoredQueryDefinition xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                          id=\"urn:example:wfs2-query:GetFeatureByTypeName\">\n      <Title>GetFeatureByTypeName</Title>\n      <Abstract>Returns feature representations by type name.</Abstract>\n      <Parameter name=\"typeName\" type=\"xsd:QName\">\n         <Abstract>Qualified name of feature type (required).</Abstract>\n      </Parameter>\n      <QueryExpressionText isPrivate=\"false\"\n                           language=\"urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression\"\n                           returnFeatureTypes=\"\">\n         <Query typeNames=\"${typeName}\"/>\n      </QueryExpressionText>\n</StoredQueryDefinition>\n</CreateStoredQuery>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=ListStoredQueries");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'urn:example:wfs2-query:GetFeatureByTypeName']", (Document)dom);
        dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetFeature&storedQuery_id=urn:example:wfs2-query:GetFeatureByTypeName&typename=tns:Fifteen", 200);
        XMLAssert.assertXpathExists((String)"/wfs:FeatureCollection", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//cdf:Fifteen)", (Document)dom);
    }

    @Test
    public void testCreateWithLocalNamespaceDeclaration() throws Exception {
        String xml = "<CreateStoredQuery xmlns=\"http://www.opengis.net/wfs/2.0\" service=\"WFS\" version=\"2.0.0\">\n  <StoredQueryDefinition xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n                          id=\"urn:example:wfs2-query:GetFeatureByName\">\n      <Title>GetFeatureByName</Title>\n      <Abstract>Returns feature representations by name. The name value must occur in a gml:name property.</Abstract>\n      <Parameter name=\"name\" type=\"xsd:string\">\n         <Abstract>Name of feature instance (required)</Abstract>\n      </Parameter>\n      <QueryExpressionText xmlns:fes=\"http://www.opengis.net/fes/2.0\"\n                           xmlns:gml=\"http://www.opengis.net/gml/3.2\"\n                           xmlns:ns42=\"http://cite.opengeospatial.org/gmlsf\"\n                           isPrivate=\"false\"\n                           language=\"urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression\"\n                           returnFeatureTypes=\"ns42:Entit\u00e9G\u00e9n\u00e9rique\">\n         <Query typeNames=\"ns42:Entit\u00e9G\u00e9n\u00e9rique\">\n            <fes:Filter>\n               <fes:PropertyIsLike escapeChar=\"\\\" singleChar=\"?\" wildCard=\"*\">\n                  <fes:ValueReference>gml:name</fes:ValueReference>\n                  <fes:Literal>*${name}*</fes:Literal>\n               </fes:PropertyIsLike>\n            </fes:Filter>\n         </Query>\n      </QueryExpressionText>\n  </StoredQueryDefinition>\n</CreateStoredQuery>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=ListStoredQueries");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'urn:example:wfs2-query:GetFeatureByName']", (Document)dom);
    }

    @Test
    public void testCreateStoredQueryWithEmptyReturnFeatureTypes() throws Exception {
        String xml = "<wfs:ListStoredQueries service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'/>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:ListStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
        xml = this.getCreatePrimitiveWithinQuery(true);
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
        dom = this.getAsDOM("wfs?request=ListStoredQueries");
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:ReturnFeatureType[text() = 'sf:PrimitiveGeoFeature']", (Document)dom);
        xml = "<wfs:DescribeStoredQueries xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS'><wfs:StoredQueryId>myStoredQuery</wfs:StoredQueryId></wfs:DescribeStoredQueries>";
        dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:DescribeStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//wfs:StoredQueryDescription[@id='myStoredQuery']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//wfs:QueryExpressionText/@returnFeatureTypes", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wfs:QueryExpressionText/@returnFeatureTypes", (Document)dom);
        xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:gml='http://www.opengis.net/gml/3.2'       xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'>   <wfs:StoredQuery id='myStoredQuery'>       <wfs:Parameter name='AreaOfInterest'>   <gml:Envelope srsName='EPSG:4326'>      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope>      </wfs:Parameter>    </wfs:StoredQuery> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", xml);
        this.assertGML32(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature/gml:name[text() = 'name-f002']", (Document)dom);
    }

    @Test
    public void testCreateStoredQueryXXE() throws Exception {
        String xml = "<wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:myns='http://www.someserver.com/myns'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='testXXE'>       <wfs:Parameter name='AreaOfInterest' type='gml:Polygon'/>       <wfs:QueryExpressionText            returnFeatureTypes='sf:PrimitiveGeoFeature'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'><![CDATA[<?xml version='1.0' encoding='UTF-8'?>          <!DOCTYPE Query [          <!ELEMENT Query ANY>          <!ENTITY xxe SYSTEM \"file:///this/file/does/not/exist\">]>          <wfs:Query typeNames='sf:PrimitiveGeoFeature'>             <fes:Filter>                <fes:Within>                   <fes:ValueReference>&xxe;</fes:ValueReference>                   ${AreaOfInterest}                </fes:Within>             </fes:Filter>          </wfs:Query>]]>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery>";
        Document dom = this.postAsDOM("wfs", xml);
        String message = this.checkOws11Exception(dom, "2.0.0", "OperationProcessingFailed", "CreateStoredQuery");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
    }

    @Test
    public void testCreateLocalStoredQuery() throws Exception {
        try {
            String xml = "<wfs:ListStoredQueries service='WFS' version='2.0.0'  xmlns:wfs='http://www.opengis.net/wfs/2.0'/>";
            Document dom = this.postAsDOM("sf/wfs", xml);
            Assert.assertEquals((Object)"wfs:ListStoredQueriesResponse", (Object)dom.getDocumentElement().getNodeName());
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
            xml = this.getCreatePrimitiveWithinQuery(false);
            dom = this.postAsDOM("sf/wfs", xml);
            Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
            Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
            dom = this.getAsDOM("sf/wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:ReturnFeatureType[text() = 'sf:PrimitiveGeoFeature']", (Document)dom);
            dom = this.getAsDOM("wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathNotExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
            xml = "<wfs:DropStoredQuery xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS' id='myStoredQuery'/>";
            dom = this.postAsDOM("sf/wfs", xml);
            Assert.assertEquals((Object)"wfs:DropStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
            Assert.assertEquals((Object)"OK", (Object)dom.getDocumentElement().getAttribute("status"));
            dom = this.getAsDOM("sf/wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathNotExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
        }
        finally {
            this.removeAllLocalStoredQueries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowGlobalQueries() throws Exception {
        WFSInfo wfsInfo;
        GeoServer geoServer = this.getGeoServer();
        try {
            wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setAllowGlobalQueries(Boolean.valueOf(false));
            geoServer.save((ServiceInfo)wfsInfo);
            String xml = this.getCreatePrimitiveWithinQuery(false);
            Document dom = this.postAsDOM("sf/wfs", xml);
            xml = this.getCreatePrimitiveWithinQuery(false, "otherQuery");
            dom = this.postAsDOM("wfs", xml);
            dom = this.getAsDOM("sf/wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
            XMLAssert.assertXpathNotExists((String)"//wfs:StoredQuery[@id = 'otherQuery']", (Document)dom);
            dom = this.getAsDOM("wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'otherQuery']", (Document)dom);
        }
        finally {
            wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setAllowGlobalQueries(Boolean.valueOf(true));
            geoServer.save((ServiceInfo)wfsInfo);
            this.removeAllLocalStoredQueries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowPerWorkspaceQueries() throws Exception {
        WFSInfo wfsInfo;
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo geoServerInfo = geoServer.getGlobal();
        geoServerInfo.setAllowStoredQueriesPerWorkspace(Boolean.valueOf(false));
        geoServer.save(geoServerInfo);
        try {
            wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setAllowGlobalQueries(Boolean.valueOf(false));
            geoServer.save((ServiceInfo)wfsInfo);
            String xml = this.getCreatePrimitiveWithinQuery(false);
            Document dom = this.postAsDOM("sf/wfs", xml);
            xml = this.getCreatePrimitiveWithinQuery(false, "otherQuery");
            dom = this.postAsDOM("wfs", xml);
            dom = this.getAsDOM("sf/wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'otherQuery']", (Document)dom);
            dom = this.getAsDOM("wfs?request=ListStoredQueries");
            XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//wfs:StoredQuery)", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'myStoredQuery']", (Document)dom);
            XMLAssert.assertXpathExists((String)"//wfs:StoredQuery[@id = 'otherQuery']", (Document)dom);
        }
        finally {
            wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setAllowGlobalQueries(Boolean.valueOf(true));
            geoServer.save((ServiceInfo)wfsInfo);
            geoServerInfo = geoServer.getGlobal();
            geoServerInfo.setAllowStoredQueriesPerWorkspace(Boolean.valueOf(false));
            geoServer.save(geoServerInfo);
        }
    }

    @Test
    public void testDisabledStoredQueriesManagement() {
        GeoServer geoServer = this.getGeoServer();
        try {
            WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setDisableStoredQueriesManagement(true);
            geoServer.save((ServiceInfo)wfsInfo);
            String xml = this.getCreatePrimitiveWithinQuery(false);
            Document dom = this.postAsDOM("sf/wfs", xml);
            dom.getDocumentElement();
            XMLAssert.assertXpathEvaluatesTo((String)"Stored queries management is disabled", (String)"string(//ows:ExceptionText)", (Document)dom);
            xml = "<wfs:DropStoredQuery xmlns:wfs='http://www.opengis.net/wfs/2.0' service='WFS' id='myStoredQuery'/>";
            dom = this.postAsDOM("wfs", xml);
            XMLAssert.assertXpathEvaluatesTo((String)"Stored queries management is disabled", (String)"string(//ows:ExceptionText)", (Document)dom);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
            wfsInfo.setDisableStoredQueriesManagement(false);
            geoServer.save((ServiceInfo)wfsInfo);
        }
    }

    private void removeAllLocalStoredQueries() {
        WorkspaceInfo workspaceInfo;
        GeoServer geoServer = this.getGeoServer();
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(workspaceInfo = geoServer.getCatalog().getWorkspaceByName("sf"), WFSInfo.class);
        if (wfsInfo == null) {
            wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
        }
        new StoredQueryProvider(this.getCatalog(), wfsInfo, true, "sf").removeAll();
    }
}

