/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.XlinkPropertyNameType;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.request.Query;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

class AliasedQuery
extends Query {
    private List<String> aliases;
    private Query delegate;
    private Filter filter;
    private List<String> propertyNames;

    static Query fixAliases(List<FeatureTypeInfo> metas, Query query) throws IOException {
        ArrayList<Object> aliases;
        HashSet<String> reservedWords = new HashSet<String>();
        for (FeatureTypeInfo meta : metas) {
            reservedWords.add(meta.getName());
            reservedWords.add(meta.prefixedName());
            FeatureType featureType = meta.getFeatureType();
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                reservedWords.add(pd.getName().getLocalPart());
                reservedWords.add(pd.getName().getURI());
            }
        }
        List<String> originalAliases = query.getAliases();
        boolean replaced = false;
        if (query.getAliases() != null && !query.getAliases().isEmpty()) {
            aliases = new ArrayList<String>(query.getAliases());
        } else {
            replaced = true;
            aliases = new ArrayList();
            for (int i = 0; i < metas.size(); ++i) {
                aliases.add(String.valueOf((char)(97 + i)));
            }
        }
        for (int i = 0; i < aliases.size(); ++i) {
            Object alias = (String)aliases.get(i);
            String base = alias;
            int j = 0;
            while (reservedWords.contains(alias)) {
                replaced = true;
                alias = base + j++;
            }
            aliases.set(i, alias);
        }
        if (replaced) {
            return new AliasedQuery(query, originalAliases, aliases);
        }
        return query;
    }

    public AliasedQuery(Query query, List<String> originalAliases, List<String> aliases) {
        super(null);
        this.delegate = query;
        this.aliases = aliases;
        if (originalAliases != null && !originalAliases.isEmpty()) {
            Map<String, String> renameMap = this.buildRenameMap(originalAliases, aliases);
            this.filter = (Filter)query.getFilter().accept((FilterVisitor)new AliasRenameVisitor(renameMap), null);
            if (query.getPropertyNames() != null) {
                this.propertyNames = new ArrayList<String>();
                for (String name : query.getPropertyNames()) {
                    this.propertyNames.add(this.rename(renameMap, name));
                }
            }
        } else {
            List<QName> typeNames = query.getTypeNames();
            this.filter = typeNames.size() == 2 && new HashSet<QName>(typeNames).size() == 1 ? (Filter)query.getFilter().accept((FilterVisitor)new SelfJoinRenameVisitor(aliases), null) : query.getFilter();
            this.propertyNames = query.getPropertyNames();
        }
    }

    private Map<String, String> buildRenameMap(List<String> originalAliases, List<String> newAliases) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < originalAliases.size(); ++i) {
            String a2;
            String a1 = originalAliases.get(i);
            if (a1.equals(a2 = newAliases.get(i))) continue;
            map.put(a1, a2);
        }
        return map;
    }

    String rename(Map<String, String> renameMap, String name) {
        String prefix;
        String renamed;
        int idx = ((String)name).indexOf(47);
        if (idx > 0 && (renamed = renameMap.get(prefix = ((String)name).substring(0, idx))) != null) {
            name = renamed + ((String)name).substring(idx);
        }
        return name;
    }

    String rename(String renamedPrefix, String name) {
        int idx = ((String)name).indexOf(47);
        if (idx > 0) {
            name = renamedPrefix + ((String)name).substring(idx);
        }
        return name;
    }

    @Override
    public List<QName> getTypeNames() {
        return this.delegate.getTypeNames();
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public void setPropertyNames(List<String> names) {
        this.propertyNames = names;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public List<SortBy> getSortBy() {
        return this.delegate.getSortBy();
    }

    @Override
    public void setSortBy(List<SortBy> sortBy) {
        this.delegate.setSortBy(sortBy);
    }

    @Override
    public List<XlinkPropertyNameType> getXlinkPropertyNames() {
        return this.delegate.getXlinkPropertyNames();
    }

    class SelfJoinRenameVisitor
    extends DuplicatingFilterVisitor {
        private List<String> aliases;

        public SelfJoinRenameVisitor(List<String> aliases) {
            this.aliases = aliases;
        }

        public Object visit(Beyond filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            double distance = filter.getDistance();
            String units = filter.getDistanceUnits();
            return this.getFactory(extraData).beyond(geometry1, geometry2, distance, units, filter.getMatchAction());
        }

        public Object visit(Contains filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).contains(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(Crosses filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).crosses(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(Disjoint filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).disjoint(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(DWithin filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            double distance = filter.getDistance();
            String units = filter.getDistanceUnits();
            return this.getFactory(extraData).dwithin(geometry1, geometry2, distance, units, filter.getMatchAction());
        }

        public Object visit(Equals filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).equal(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(Intersects filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).intersects(geometry1, geometry2, filter.getMatchAction());
        }

        private Expression visitBinaryChild(Expression ex, Object extraData, int idx) {
            if (ex instanceof PropertyName) {
                String name = ((PropertyName)ex).getPropertyName();
                String renamed = AliasedQuery.this.rename(this.aliases.get(idx), name);
                return this.ff.property(renamed);
            }
            return super.visit(ex, extraData);
        }

        public Object visit(Overlaps filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).overlaps(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(Touches filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).touches(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(Within filter, Object extraData) {
            Expression geometry1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression geometry2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).within(geometry1, geometry2, filter.getMatchAction());
        }

        public Object visit(PropertyIsEqualTo filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            boolean matchCase = filter.isMatchingCase();
            return this.getFactory(extraData).equal(expr1, expr2, matchCase, filter.getMatchAction());
        }

        public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            boolean matchCase = filter.isMatchingCase();
            return this.getFactory(extraData).notEqual(expr1, expr2, matchCase, filter.getMatchAction());
        }

        public Object visit(PropertyIsGreaterThan filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).greater(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
        }

        public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).greaterOrEqual(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
        }

        public Object visit(PropertyIsLessThan filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).less(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
        }

        public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
            Expression expr1 = this.visitBinaryChild(filter.getExpression1(), extraData, 0);
            Expression expr2 = this.visitBinaryChild(filter.getExpression2(), extraData, 1);
            return this.getFactory(extraData).lessOrEqual(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
        }
    }

    class AliasRenameVisitor
    extends DuplicatingFilterVisitor {
        private Map<String, String> renameMap;

        public AliasRenameVisitor(Map<String, String> renameMap) {
            this.renameMap = renameMap;
        }

        public Object visit(PropertyName expression, Object extraData) {
            String name = expression.getPropertyName();
            String renamed = AliasedQuery.this.rename(this.renameMap, name);
            return this.ff.property(renamed);
        }
    }
}

