/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.util.logging.Logging;

public class CatalogFeatureTypeCache
extends FeatureTypeCache {
    static final Logger LOGGER = Logging.getLogger(CatalogFeatureTypeCache.class);
    Catalog catalog;

    public CatalogFeatureTypeCache(Catalog catalog) {
        this.catalog = catalog;
    }

    public FeatureType get(Name name) {
        FeatureTypeInfo meta;
        FeatureType featureType = super.get(name);
        if (featureType == null && (meta = this.catalog.getFeatureTypeByName(name)) != null) {
            try {
                featureType = meta.getFeatureType();
                this.put(featureType);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not load underlying feature type for type " + meta.getName(), e);
            }
        }
        return featureType;
    }
}

