/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.RequestObject;

public class WFSException
extends ServiceException {
    public static final String NOT_FOUND = "NotFound";
    public static final String OPERATION_PROCESSING_FAILED = "OperationProcessingFailed";
    public static final String INVALID_VALUE = "InvalidValue";
    public static final String DUPLICATE_STORED_QUERY_ID_VALUE = "DuplicateStoredQueryIdValue";
    public static final String LOCK_HAS_EXPIRED = "LockHasExpired";
    public static final String OPERATION_PARSING_FAILED = "OperationParsingFailed";
    public static final String INVALID_LOCK_ID = "InvalidLockId";
    public static final String CANNOT_LOCK_ALL_FEATURES = "CannotLockAllFeatures";

    public WFSException(RequestObject request, String message) {
        this(message);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, String code) {
        this(message, code);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, Throwable cause, String code) {
        this(message, cause, code);
        this.init(request);
    }

    public WFSException(RequestObject request, String message, Throwable cause) {
        this(message, cause);
        this.init(request);
    }

    public WFSException(RequestObject request, Throwable cause, String code) {
        this(cause, code);
        this.init(request);
    }

    public WFSException(RequestObject request, Throwable cause) {
        this(cause);
        this.init(request);
    }

    public WFSException(EObject request, String message) {
        this(message);
        this.init(request);
    }

    public WFSException(EObject request, String message, String code) {
        this(message, code);
        this.init(request);
    }

    public WFSException(EObject request, String message, Throwable cause, String code) {
        this(message, cause, code);
        this.init(request);
    }

    public WFSException(EObject request, String message, Throwable cause) {
        this(message, cause);
        this.init(request);
    }

    public WFSException(EObject request, Throwable cause, String code) {
        this(cause, code);
        this.init(request);
    }

    public WFSException(EObject request, Throwable cause) {
        this(cause);
        this.init(request);
    }

    public WFSException init(Object request) {
        if (request != null) {
            Object ver;
            WFSInfo.Version version;
            if (OwsUtils.has((Object)request, (String)"version") && (version = WFSInfo.Version.negotiate((ver = OwsUtils.get((Object)request, (String)"version")) != null ? ver.toString() : null)) != null && version.compareTo(WFSInfo.Version.V_20) < 0) {
                return this;
            }
            if (this.locator == null && OwsUtils.has((Object)request, (String)"handle")) {
                this.locator = (String)OwsUtils.get((Object)request, (String)"handle");
            }
            if (this.locator == null) {
                this.locator = this.determineDefaultLocator(request);
            }
            if (this.code == null) {
                this.code = Code.OperationProcessingFailed.name();
            }
        }
        return this;
    }

    private String determineDefaultLocator(Object request) {
        String className = request.getClass().getSimpleName();
        if (request instanceof RequestObject) {
            className = request.getClass().getSuperclass().getSimpleName();
            if (className.endsWith("Request")) {
                return className.substring(0, className.length() - "Request".length());
            }
            RequestObject requestObject = (RequestObject)request;
            EObject adaptee = requestObject.getAdaptee();
            if (adaptee.getClass().getName().contains("wfs20")) {
                return className;
            }
            return null;
        }
        if (className.endsWith("TypeImpl")) {
            return className.substring(0, className.length() - "TypeImpl".length());
        }
        return null;
    }

    public WFSException(String message) {
        super(message);
    }

    public WFSException(Throwable cause) {
        super(cause);
    }

    public WFSException(String message, String code, String locator) {
        super(message, code, locator);
    }

    public WFSException(String message, String code) {
        super(message, code);
    }

    public WFSException(String message, Throwable cause, String code, String locator) {
        super(message, cause, code, locator);
    }

    public WFSException(String message, Throwable cause, String code) {
        super(message, cause, code);
    }

    public WFSException(String message, Throwable cause) {
        super(message, cause);
    }

    public WFSException(Throwable cause, String code, String locator) {
        super(cause, code, locator);
    }

    public WFSException(Throwable cause, String code) {
        super(cause, code);
    }

    public static enum Code {
        OperationProcessingFailed;

    }
}

