/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.xsd.BindingWalkerFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.geotools.xsd.SchemaIndex;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public final class GMLAbstractFeatureTypeBinding
extends org.geotools.gml2.bindings.GMLAbstractFeatureTypeBinding {
    GeometryFactory geometryFactory;
    Catalog catalog;

    public GMLAbstractFeatureTypeBinding(FeatureTypeCache featureTypeCache, BindingWalkerFactory bwFactory, SchemaIndex schemaIndex, GeometryFactory geometryFactory, Catalog catalog, Configuration configuration) {
        super(featureTypeCache, bwFactory, schemaIndex, configuration);
        this.geometryFactory = geometryFactory;
        this.catalog = catalog;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(instance.getNamespace(), instance.getName());
        if (meta != null) {
            FeatureType featureType = meta.getFeatureType();
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                Node boundedByNode;
                if (!(pd instanceof AttributeDescriptor)) continue;
                AttributeDescriptor attributeType = (AttributeDescriptor)pd;
                String name = attributeType.getLocalName();
                Class type = attributeType.getType().getBinding();
                if (!"boundedBy".equals(name) || !((boundedByNode = node.getChild("boundedBy")).getValue() instanceof Envelope)) continue;
                Envelope bounds = (Envelope)boundedByNode.getValue();
                if (type.isAssignableFrom(Polygon.class)) {
                    Polygon polygon = this.polygon(bounds);
                    boundedByNode.setValue((Object)polygon);
                    continue;
                }
                if (!type.isAssignableFrom(MultiPolygon.class)) continue;
                MultiPolygon multiPolygon = this.geometryFactory.createMultiPolygon(new Polygon[]{this.polygon(bounds)});
                boundedByNode.setValue((Object)multiPolygon);
            }
        }
        return super.parse(instance, node, value);
    }

    Polygon polygon(Envelope bounds) {
        return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(bounds.getMinX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMaxY()), new Coordinate(bounds.getMaxX(), bounds.getMinY()), new Coordinate(bounds.getMinX(), bounds.getMinY())}), null);
    }
}

