/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultWebMapServiceTest
extends WMSTestSupport {
    @Test
    public void testBasic() throws Exception {
        GetMapRequest mockGMR = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setLayers(mockGMR.getLayers());
        request.setFormat(DefaultWebMapService.FORMAT);
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        Assert.assertTrue((boolean)"EPSG:WGS 84".equalsIgnoreCase(crsString));
        Assert.assertTrue((boolean)"EPSG:4326".equalsIgnoreCase(srs));
        Assert.assertTrue((bbox.getMinX() == -180.0 && bbox.getMaxX() == 180.0 && bbox.getMinY() == -90.0 && bbox.getMaxY() == 90.0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"image/png", (Object)format);
        Assert.assertEquals((long)width, (long)768L);
        Assert.assertEquals((long)height, (long)384L);
    }

    @Test
    public void testReprojection() throws Exception {
        GetMapRequest mockGMR = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setSRS("EPSG:41001");
        request.setCrs(CRS.decode((String)"EPSG:41001"));
        request.setLayers(mockGMR.getLayers());
        request.setFormat("image/gif");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        Assert.assertTrue((boolean)"WGS84 / Simple Mercator".equalsIgnoreCase(crsString));
        Assert.assertTrue((boolean)"EPSG:41001".equalsIgnoreCase(srs));
        Assert.assertTrue((Math.abs(bbox.getMinX() + 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMinY() + 2.2026354993694823E7) < 1.0E-4 && Math.abs(bbox.getMaxX() - 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMaxY() - 2.2026354993694823E7) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"image/gif", (Object)format);
        Assert.assertEquals((long)670L, (long)width);
        Assert.assertEquals((long)768L, (long)height);
    }

    @Test
    public void testAutoSetWidthHeight() throws Exception {
        GetMapRequest mockStreams = this.createGetMapRequest(MockData.BRIDGES);
        GetMapRequest mockBridges = this.createGetMapRequest(MockData.STREAMS);
        ArrayList<MapLayerInfo> mls = new ArrayList<MapLayerInfo>(2);
        mls.add((MapLayerInfo)mockBridges.getLayers().get(0));
        mls.add((MapLayerInfo)mockStreams.getLayers().get(0));
        GetMapRequest request = new GetMapRequest();
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        request.setSRS("EPSG:41001");
        request.setCrs(CRS.decode((String)"EPSG:41001"));
        request.setLayers(mls);
        request.setFormat("image/gif");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        CoordinateReferenceSystem crs = request.getCrs();
        String srs = request.getSRS();
        Envelope bbox = request.getBbox();
        String format = request.getFormat();
        int width = request.getWidth();
        int height = request.getHeight();
        String crsString = crs.getName().toString();
        Assert.assertTrue((boolean)"WGS84 / Simple Mercator".equalsIgnoreCase(crsString));
        Assert.assertTrue((boolean)"EPSG:41001".equalsIgnoreCase(srs));
        Assert.assertTrue((Math.abs(bbox.getMinX() + 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMinY() + 2.2026354993694823E7) < 1.0E-4 && Math.abs(bbox.getMaxX() - 1.9236008009077676E7) < 1.0E-4 && Math.abs(bbox.getMaxY() - 2.2026354993694823E7) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"image/gif", (Object)format);
        Assert.assertEquals((long)670L, (long)width);
        Assert.assertEquals((long)768L, (long)height);
    }

    @Test
    public void testAutoSetWidthHeightOL() throws Exception {
        DefaultWebMapService reflector = new DefaultWebMapService(this.getWMS());
        GetMapRequest request = this.createGetMapRequest(MockData.BRIDGES);
        request.setBbox(new Envelope(-180.0, 180.0, 0.0, 10.0));
        request.setFormat("application/openlayers");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        Assert.assertEquals((long)768L, (long)request.getWidth());
        Assert.assertEquals((long)330L, (long)request.getHeight());
        request = this.createGetMapRequest(MockData.BRIDGES);
        request.setBbox(new Envelope(0.0, 10.0, -90.0, 90.0));
        request.setFormat("application/openlayers");
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
        Assert.assertEquals((long)330L, (long)request.getWidth());
        Assert.assertEquals((long)768L, (long)request.getHeight());
    }

    @Test
    public void testAdvancedProjectionEnabled() {
        Assert.assertTrue((boolean)this.getWMS().isAdvancedProjectionHandlingEnabled());
    }
}

