/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.GetMap;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geotools.data.FeatureSource;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetMapCallbackTest
extends WMSDimensionsTestSupport {
    private GetMap getMap;

    @Before
    public void cleanupCallbacks() {
        this.getMap = (GetMap)applicationContext.getBean(GetMap.class);
        this.getMap.setGetMapCallbacks(Collections.EMPTY_LIST);
    }

    @Test
    public void testStandardWorkflow() throws Exception {
        TestCallback callback = new TestCallback();
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)2L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
    }

    @Test
    public void testBreakRequest() throws Exception {
        String message = "This layer is not allowed";
        TestCallback callback = new TestCallback(){

            @Override
            public Layer beforeLayer(WMSMapContent content, Layer layer) {
                throw new RuntimeException("This layer is not allowed");
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"/ServiceExceptionReport", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)0L, (long)callback.layers.size());
        Assert.assertEquals((long)0L, (long)callback.mapContents.size());
        Assert.assertEquals((long)0L, (long)callback.maps.size());
        Assert.assertEquals((long)1L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)"This layer is not allowed", (Object)((Throwable)callback.exceptions.get(0)).getMessage());
    }

    @Test
    public void testAddLayer() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BRIDGES));
        FeatureSource fs = ft.getFeatureSource(null, null);
        Style style = this.getCatalog().getStyleByName("point").getStyle();
        final FeatureLayer layer = new FeatureLayer(fs, style);
        layer.setTitle("extra");
        TestCallback callback = new TestCallback(){

            @Override
            public WMSMapContent beforeRender(WMSMapContent mapContent) {
                mapContent.addLayer((Layer)layer);
                return super.beforeRender(mapContent);
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Lakes,cite:Forests,extra']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)3L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)layer, callback.layers.get(2));
    }

    @Test
    public void testRemoveLayer() throws Exception {
        TestCallback callback = new TestCallback(){

            @Override
            public Layer beforeLayer(WMSMapContent content, Layer layer) {
                if ("cite:Lakes".equals(layer.getTitle())) {
                    return null;
                }
                return super.beforeLayer(content, layer);
            }
        };
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        Document dom = this.getAsDOM("wms?request=reflect&layers=nature&format=rss&version=1.1.0");
        XMLAssert.assertXpathExists((String)"rss/channel/title[text() = 'cite:Forests']", (Document)dom);
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)1L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)1L, (long)callback.layers.size());
        Assert.assertEquals((long)1L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
        Assert.assertEquals((Object)"cite:Forests", (Object)((Layer)callback.layers.get(0)).getTitle());
    }

    @Test
    public void testAnimator() throws Exception {
        TestCallback callback = new TestCallback();
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        String requestURL = "wms/animate?layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&aparam=fake_param&avalues=val0,val1,val2";
        MockHttpServletResponse resp = this.getAsServletResponse(requestURL);
        Assert.assertEquals((Object)"image/gif", (Object)resp.getContentType());
        Assert.assertEquals((long)4L, (long)callback.requests.size());
        Assert.assertEquals((long)4L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)4L, (long)callback.layers.size());
        Assert.assertEquals((long)4L, (long)callback.mapContents.size());
        Assert.assertEquals((long)4L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
    }

    @Test
    public void testAnimatedGifDimensions() throws Exception {
        TestCallback callback = new TestCallback();
        this.getMap.setGetMapCallbacks(Arrays.asList(callback));
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&styles=&Format=image/png&width=80&height=40&srs=EPSG:4326&layers=" + this.getLayerId(this.V_TIME_ELEVATION) + "&time=2011-05-02,2011-05-04,2011-05-10&format=" + "image/gif;subtype=animated");
        Assert.assertEquals((Object)"image/gif", (Object)response.getContentType());
        Assert.assertEquals((long)1L, (long)callback.requests.size());
        Assert.assertEquals((long)3L, (long)callback.mapContentsInited.size());
        Assert.assertEquals((long)3L, (long)callback.layers.size());
        Assert.assertEquals((long)3L, (long)callback.mapContents.size());
        Assert.assertEquals((long)1L, (long)callback.maps.size());
        Assert.assertEquals((long)0L, (long)callback.exceptions.size());
    }

    private class TestCallback
    implements GetMapCallback {
        private List<GetMapRequest> requests = new ArrayList<GetMapRequest>();
        private List<WMSMapContent> mapContentsInited = new ArrayList<WMSMapContent>();
        private List<Layer> layers = new ArrayList<Layer>();
        private List<WMSMapContent> mapContents = new ArrayList<WMSMapContent>();
        private List<WebMap> maps = new ArrayList<WebMap>();
        private List<Throwable> exceptions = new ArrayList<Throwable>();

        private TestCallback() {
        }

        public synchronized GetMapRequest initRequest(GetMapRequest request) {
            this.requests.add(request);
            return request;
        }

        public synchronized void initMapContent(WMSMapContent mapContent) {
            this.mapContentsInited.add(mapContent);
        }

        public synchronized Layer beforeLayer(WMSMapContent content, Layer layer) {
            this.layers.add(layer);
            return layer;
        }

        public synchronized WMSMapContent beforeRender(WMSMapContent mapContent) {
            this.mapContents.add(mapContent);
            return mapContent;
        }

        public synchronized WebMap finished(WebMap map) {
            this.maps.add(map);
            return map;
        }

        public synchronized void failed(Throwable t) {
            this.exceptions.add(t);
        }
    }
}

