/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class LegendNonValidCapabilitiesTest
extends WMSTestSupport {
    private static final String CAPABILITIES_REQUEST_1_3_0 = "wms?request=getCapabilities&version=1.3.0";
    private static final String CAPABILITIES_REQUEST_1_1_1 = "wms?request=getCapabilities&version=1.1.1";
    private static final String LAYER_NAME = "watertemp";
    private static final QName LAYER_QNAME = new QName(MockData.DEFAULT_URI, "watertemp", MockData.DEFAULT_PREFIX);
    private static final String LAYER_FILE = "custwatertemp.zip";
    private static final String STYLE_NAME = "temperature";
    private static final String STYLE_FILE = "temperature.sld";
    private static final String LEGEND_FORMAT = "image/png";
    private static final int LEGEND_WIDTH = 22;
    private static final int LEGEND_HEIGHT = 121;
    private static final String BASE = "http://127.0.0.1:8080/geoserver";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        LegendInfoImpl legend = new LegendInfoImpl();
        legend.setWidth(0);
        legend.setHeight(0);
        legend.setFormat(LEGEND_FORMAT);
        legend.setOnlineResource(null);
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        this.getResourceLoader().copyFromClassPath("legend.png", resource.file(), ((Object)((Object)this)).getClass());
        testData.addStyle(null, STYLE_NAME, STYLE_FILE, ((Object)((Object)this)).getClass(), this.getCatalog(), (LegendInfo)legend);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME);
        testData.addRasterLayer(LAYER_QNAME, LAYER_FILE, null, propertyMap, SystemTestData.class, this.getCatalog());
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl(BASE);
        this.getGeoServer().save(global);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        this.getGeoServer().save((ServiceInfo)wms);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("", "http://www.opengis.net/wms");
        namespaces.put("wms", "http://www.opengis.net/wms");
        SystemTestData cfr_ignored_0 = (SystemTestData)this.getTestData();
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void testCapabilities_1_3_0() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST_1_3_0), false);
        String legendUrlPath = "//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/@width", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(121), (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/@height", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)LEGEND_FORMAT, (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/wms:Format", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://127.0.0.1:8080/geoserver/ows?service=WMS&request=GetLegendGraphic&format=image%2Fpng&width=20&height=20&layer=gs%3Awatertemp", (String)"//wms:Layer[wms:Name='gs:watertemp']/wms:Style/wms:LegendURL/wms:OnlineResource/@xlink:href", (Document)dom);
    }

    @Test
    public void testCapabilities_1_1_1() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST_1_1_1), true);
        String legendUrlPath = "//Layer[Name='gs:watertemp']/Style/LegendURL";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(22), (String)"//Layer[Name='gs:watertemp']/Style/LegendURL/@width", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(121), (String)"//Layer[Name='gs:watertemp']/Style/LegendURL/@height", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)LEGEND_FORMAT, (String)"//Layer[Name='gs:watertemp']/Style/LegendURL/Format", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://127.0.0.1:8080/geoserver/wms?request=GetLegendGraphic&format=image%2Fpng&width=20&height=20&layer=gs%3Awatertemp", (String)"//Layer[Name='gs:watertemp']/Style/LegendURL/OnlineResource/@xlink:href", (Document)dom);
    }
}

