/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.junit.Before;

public abstract class WMSCascadeTestSupport
extends WMSTestSupport {
    protected static final String WORLD4326_130 = "world4326_130";
    protected static final String WORLD4326_110 = "world4326_110";
    protected static final String WORLD4326_110_NFI = "world4326_110_NFI";
    protected MockHttpClient wms13Client;
    protected URL wms13BaseURL;
    protected MockHttpClient wms11Client;
    protected URL wms11BaseURL;
    protected MockHttpClient wms11ClientNfi;
    protected URL wms11BaseNfiURL;
    protected XpathEngine xpath;

    @Before
    public void setupXpathEngine() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        this.setupWMS130Layer();
        this.setupWMS110Layer();
        this.setupWMS110NfiLayer();
    }

    private void setupWMS130Layer() throws MalformedURLException, IOException {
        this.wms13Client = new MockHttpClient();
        this.wms13BaseURL = new URL("http://mock.test.geoserver.org/wms13");
        URL capsDocument = WMSTestSupport.class.getResource("caps130.xml");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&request=GetCapabilities&version=1.3.0"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&version=1.3.0&request=GetMap&layers=world4326&styles&bbox=-90.0,-180.0,90.0,180.0&crs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=180&height=90"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        String caps = this.wms13BaseURL + "?service=WMS&request=GetCapabilities&version=1.3.0";
        TestHttpClientProvider.bind((HTTPClient)this.wms13Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-130");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_130);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
        WMSLayerInfo roadsWmsLayer = cb.buildWMSLayer("roads_wms_130");
        roadsWmsLayer.setName("roads_wms_130");
        roadsWmsLayer.reset();
        roadsWmsLayer.setPreferredFormat("image/jpeg");
        roadsWmsLayer.setForcedRemoteStyle("line1");
        this.getCatalog().add((ResourceInfo)roadsWmsLayer);
        LayerInfo wmsRaodsLayer = cb.buildLayer(roadsWmsLayer);
        this.getCatalog().add(wmsRaodsLayer);
        String mockPNGUrl = this.wms13BaseURL + "?&SERVICE=WMS&LAYERS=roads_wms_130&CRS=EPSG:26713&FORMAT=image%2Fpng&HEIGHT=90&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=180&STYLES=line1&VERSION=1.3.0";
        String mockJpegUrl = this.wms13BaseURL + "?&SERVICE=WMS&LAYERS=roads_wms_130&CRS=EPSG:26713&FORMAT=image%2Fjpeg&HEIGHT=90&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=180&STYLES=line1&VERSION=1.3.0";
        URL pngRoadsImage = WMSTestSupport.class.getResource("roads_wms.png");
        URL gifRoadsImage = WMSTestSupport.class.getResource("roads_wms.gif");
        this.wms13Client.expectGet(new URL(mockPNGUrl), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        this.wms13Client.expectGet(new URL(mockJpegUrl), (HTTPResponse)new MockHttpResponse(gifRoadsImage, "image/gif", new String[0]));
        String jsonResponse = "{\"Legend\": [{\n  \"layerName\": \"roads22\",\n  \"title\": \"roads\",\n  \"rules\": [  {\n    \"name\": \"Rule 1\",\n    \"title\": \"Green Line\",\n    \"abstract\": \"A green line with a 2 pixel width\",\n    \"symbolizers\": [{\"Line\":     {\n      \"stroke\": \"#0000FF\",\n      \"stroke-width\": 1,\n      \"stroke-opacity\": \"1\",\n      \"stroke-linecap\": \"butt\",\n      \"stroke-linejoin\": \"miter\"\n    }}]\n  }]\n}]}";
        String mockCascadedJSONUrl = this.wms13BaseURL + "?REQUEST=GetLegendGraphic&LAYER=roads_wms_130&FORMAT=application/json&VERSION=1.3.0&SERVICE=WMS";
        this.wms13Client.expectGet(new URL(mockCascadedJSONUrl), (HTTPResponse)new MockHttpResponse(jsonResponse, "application/json", new String[0]));
        WMSLayerInfo styleLessroadsWmsLayer = cb.buildWMSLayer("roads_styleless_130");
        styleLessroadsWmsLayer.setName("roads_styleless_130");
        styleLessroadsWmsLayer.reset();
        this.getCatalog().add((ResourceInfo)styleLessroadsWmsLayer);
        LayerInfo styleLessroadsWmsLayerLayer = cb.buildLayer(styleLessroadsWmsLayer);
        this.getCatalog().add(styleLessroadsWmsLayerLayer);
        LayerGroupInfo roadsGroup = this.getCatalog().getFactory().createLayerGroup();
        roadsGroup.setName("roads_group_130");
        roadsGroup.getLayers().add(wmsRaodsLayer);
        roadsGroup.getLayers().add(styleLessroadsWmsLayerLayer);
        try {
            cb.calculateLayerGroupBounds(roadsGroup);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(roadsGroup);
        String mockLayergroupRequest = this.wms13BaseURL + "?SERVICE=WMS&LAYERS=roads_wms_130,roads_styleless_130&CRS=EPSG:26713&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=768&STYLES=line1,&VERSION=1.3.0";
        this.wms13Client.expectGet(new URL(mockLayergroupRequest), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        WMSLayerInfo group_lyr_1 = cb.buildWMSLayer("group_lyr_130");
        group_lyr_1.setName("group_lyr_130");
        group_lyr_1.reset();
        group_lyr_1.setMetadataBBoxRespected(true);
        this.getCatalog().add((ResourceInfo)group_lyr_1);
        LayerInfo layer1 = cb.buildLayer(group_lyr_1);
        this.getCatalog().add(layer1);
        WMSLayerInfo group_lyr_2 = cb.buildWMSLayer("group_lyr_230");
        group_lyr_2.setName("group_lyr_230");
        group_lyr_2.reset();
        group_lyr_2.setMetadataBBoxRespected(true);
        this.getCatalog().add((ResourceInfo)group_lyr_2);
        LayerInfo layer2 = cb.buildLayer(group_lyr_2);
        this.getCatalog().add(layer2);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("cascaded_group_130");
        group.getLayers().add(layer1);
        group.getLayers().add(layer2);
        try {
            cb.calculateLayerGroupBounds(group);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(group);
        String mockBothLayerUrl = this.wms13BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_130,group_lyr_230&CRS=EPSG:4326&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=0.0,0.0,20.0,20.0&WIDTH=768&STYLES=,&VERSION=1.3.0";
        this.wms13Client.expectGet(new URL(mockBothLayerUrl), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        String mockSingleLayerUrl = this.wms13BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_130&CRS=EPSG:4326&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=-10.0,0.0,-5.0,5.0&WIDTH=768&STYLES=&VERSION=1.3.0";
        this.wms13Client.expectGet(new URL(mockSingleLayerUrl), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        String mockURLWithSingleLayerInsideBounds = this.wms13BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_230&CRS=EPSG:4326&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=0.0,0.0,20.0,20.0&WIDTH=768&STYLES=&VERSION=1.3.0";
        this.wms13Client.expectGet(new URL(mockURLWithSingleLayerInsideBounds), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        WMSLayerInfo legacy_group_lyr = cb.buildWMSLayer("legacy_group_lyr_130");
        legacy_group_lyr.setName("legacy_group_lyr_130");
        this.getCatalog().add((ResourceInfo)legacy_group_lyr);
        LayerInfoImpl legacy_lyr = (LayerInfoImpl)cb.buildLayer(legacy_group_lyr);
        StyleInfo defaultRaster = this.getCatalog().getStyleByName(CiteTestData.DEFAULT_RASTER_STYLE);
        legacy_lyr.setDefaultStyle(defaultRaster);
        this.getCatalog().add((LayerInfo)legacy_lyr);
        LayerGroupInfo legacyCascadedGroup = this.getCatalog().getFactory().createLayerGroup();
        legacyCascadedGroup.setName("cascaded_legacy_group_130");
        legacyCascadedGroup.getLayers().add(legacy_lyr);
        try {
            cb.calculateLayerGroupBounds(legacyCascadedGroup);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(legacyCascadedGroup);
        String mockURLWithLegacyLayers = this.wms13BaseURL + "?SERVICE=WMS&LAYERS=legacy_group_lyr_130&CRS=EPSG:4326&FORMAT=image/png&HEIGHT=90&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=-90.0,-180.0,90.0,180.0&WIDTH=180&STYLES=&VERSION=1.3.0";
        this.wms13Client.expectGet(new URL(mockURLWithLegacyLayers), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
    }

    private void setupWMS110Layer() throws MalformedURLException, IOException {
        this.wms11Client = new MockHttpClient();
        this.wms11BaseURL = new URL("http://mock.test.geoserver.org/wms11");
        URL capsDocument = WMSTestSupport.class.getResource("caps111.xml");
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&version=1.1.1&request=GetMap&layers=world4326&styles&bbox=-180.0,-90.0,180.0,90.0&srs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=180&height=90"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        URL featureInfo = WMSTestSupport.class.getResource("wms-features.xml");
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?Y=50&X=50&SERVICE=WMS&INFO_FORMAT=application/vnd.ogc.gml&LAYERS=world4326&FEATURE_COUNT=50&FORMAT=image%2Fpng&HEIGHT=101&TRANSPARENT=TRUE&REQUEST=GetFeatureInfo&WIDTH=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679&STYLES=&SRS=EPSG:4326&QUERY_LAYERS=world4326&VERSION=1.1.1"), (HTTPResponse)new MockHttpResponse(featureInfo, "application/vnd.ogc.gml", new String[0]));
        String caps = this.wms11BaseURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)this.wms11Client, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-110");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_110);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
        WMSLayerInfo roadsWmsLayer = cb.buildWMSLayer("roads_wms");
        roadsWmsLayer.setName("roads_wms");
        roadsWmsLayer.reset();
        roadsWmsLayer.setPreferredFormat("image/jpeg");
        roadsWmsLayer.setForcedRemoteStyle("line1");
        this.getCatalog().add((ResourceInfo)roadsWmsLayer);
        LayerInfo wmsRoadsLayer = cb.buildLayer(roadsWmsLayer);
        this.getCatalog().add(wmsRoadsLayer);
        String mockPNGUrl = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=roads_wms&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=768&STYLES=line1&SRS=EPSG:26713&VERSION=1.1.1";
        String mockJpegUrl = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=roads_wms&FORMAT=image%2Fjpeg&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=768&STYLES=line1&SRS=EPSG:26713&VERSION=1.1.1";
        URL pngRoadsImage = WMSTestSupport.class.getResource("roads_wms.png");
        URL gifRoadsImage = WMSTestSupport.class.getResource("roads_wms.gif");
        this.wms11Client.expectGet(new URL(mockPNGUrl), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        this.wms11Client.expectGet(new URL(mockJpegUrl), (HTTPResponse)new MockHttpResponse(gifRoadsImage, "image/gif", new String[0]));
        String jsonResponse = "{\"Legend\": [{\n  \"layerName\": \"roads22\",\n  \"title\": \"roads\",\n  \"rules\": [  {\n    \"name\": \"Rule 1\",\n    \"title\": \"Green Line\",\n    \"abstract\": \"A green line with a 2 pixel width\",\n    \"symbolizers\": [{\"Line\":     {\n      \"stroke\": \"#0000FF\",\n      \"stroke-width\": 1,\n      \"stroke-opacity\": \"1\",\n      \"stroke-linecap\": \"butt\",\n      \"stroke-linejoin\": \"miter\"\n    }}]\n  }]\n}]}";
        String mockCascadedJSONUrl = this.wms11BaseURL + "?REQUEST=GetLegendGraphic&LAYER=roads_wms&FORMAT=application/json&VERSION=1.0.0&SERVICE=WMS";
        this.wms11Client.expectGet(new URL(mockCascadedJSONUrl), (HTTPResponse)new MockHttpResponse(jsonResponse, "application/json", new String[0]));
        WMSLayerInfo styleLessroadsWmsLayer = cb.buildWMSLayer("styleless_roads");
        styleLessroadsWmsLayer.setName("styleless_roads");
        styleLessroadsWmsLayer.reset();
        this.getCatalog().add((ResourceInfo)styleLessroadsWmsLayer);
        LayerInfo styleLessroadsWmsLayerLayer = cb.buildLayer(styleLessroadsWmsLayer);
        this.getCatalog().add(styleLessroadsWmsLayerLayer);
        LayerGroupInfo roadsGroup = this.getCatalog().getFactory().createLayerGroup();
        roadsGroup.setName("roads_group");
        roadsGroup.getLayers().add(wmsRoadsLayer);
        roadsGroup.getLayers().add(styleLessroadsWmsLayerLayer);
        try {
            cb.calculateLayerGroupBounds(roadsGroup);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(roadsGroup);
        String mockLayerGroupRequest = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=roads_wms,styleless_roads&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&WIDTH=768&STYLES=line1,&SRS=EPSG:26713&VERSION=1.1.1";
        this.wms11Client.expectGet(new URL(mockLayerGroupRequest), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        WMSLayerInfo group_lyr_1 = cb.buildWMSLayer("group_lyr_1");
        group_lyr_1.setName("group_lyr_1");
        group_lyr_1.reset();
        group_lyr_1.setMetadataBBoxRespected(true);
        this.getCatalog().add((ResourceInfo)group_lyr_1);
        LayerInfo layer1 = cb.buildLayer(group_lyr_1);
        this.getCatalog().add(layer1);
        WMSLayerInfo group_lyr_2 = cb.buildWMSLayer("group_lyr_2");
        group_lyr_2.setName("group_lyr_2");
        group_lyr_2.reset();
        group_lyr_2.setMetadataBBoxRespected(true);
        this.getCatalog().add((ResourceInfo)group_lyr_2);
        LayerInfo layer2 = cb.buildLayer(group_lyr_2);
        this.getCatalog().add(layer2);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("cascaded_group");
        group.getLayers().add(layer1);
        group.getLayers().add(layer2);
        try {
            cb.calculateLayerGroupBounds(group);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(group);
        String mockURLWithBothLayers = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_1,group_lyr_2&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=0.0,0.0,20.0,20.0&WIDTH=768&STYLES=,&SRS=EPSG:4326&VERSION=1.1.1";
        this.wms11Client.expectGet(new URL(mockURLWithBothLayers), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        String mockURLWithSingleLayer = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_1&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=-10.0,0.0,-5.0,5.0&WIDTH=768&STYLES=&SRS=EPSG:4326&VERSION=1.1.1";
        this.wms11Client.expectGet(new URL(mockURLWithSingleLayer), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        String mockURLWithSingleLayerInsideBounds = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=group_lyr_2&FORMAT=image%2Fpng&HEIGHT=537&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=0.0,0.0,20.0,20.0&WIDTH=768&STYLES=&SRS=EPSG:4326&VERSION=1.1.1";
        this.wms11Client.expectGet(new URL(mockURLWithSingleLayerInsideBounds), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
        WMSLayerInfo legacy_group_lyr = cb.buildWMSLayer("legacy_group_lyr");
        legacy_group_lyr.setName("legacy_group_lyr");
        this.getCatalog().add((ResourceInfo)legacy_group_lyr);
        LayerInfoImpl legacy_lyr = (LayerInfoImpl)cb.buildLayer(legacy_group_lyr);
        StyleInfo defaultRaster = this.getCatalog().getStyleByName(CiteTestData.DEFAULT_RASTER_STYLE);
        legacy_lyr.setDefaultStyle(defaultRaster);
        this.getCatalog().add((LayerInfo)legacy_lyr);
        LayerGroupInfo legacyCascadedGroup = this.getCatalog().getFactory().createLayerGroup();
        legacyCascadedGroup.setName("cascaded_legacy_group");
        legacyCascadedGroup.getLayers().add(legacy_lyr);
        try {
            cb.calculateLayerGroupBounds(legacyCascadedGroup);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.getCatalog().add(legacyCascadedGroup);
        String mockURLWithLegacyLayers = this.wms11BaseURL + "?SERVICE=WMS&LAYERS=legacy_group_lyr&FORMAT=image%2Fpng&HEIGHT=90&TRANSPARENT=FALSE&BGCOLOR=0xFFFFFF&REQUEST=GetMap&BBOX=-180.0,-90.0,180.0,90.0&WIDTH=180&STYLES=&SRS=EPSG:4326&VERSION=1.1.1";
        this.wms11Client.expectGet(new URL(mockURLWithLegacyLayers), (HTTPResponse)new MockHttpResponse(pngRoadsImage, "image/png", new String[0]));
    }

    private void setupWMS110NfiLayer() throws MalformedURLException, IOException {
        this.wms11ClientNfi = new MockHttpClient();
        this.wms11BaseNfiURL = new URL("http://mock.test.geoserver.org/wms11_nfi");
        URL capsDocument = WMSTestSupport.class.getResource("caps111_no_feature_info.xml");
        this.wms11ClientNfi.expectGet(new URL(this.wms11BaseNfiURL + "?service=WMS&request=GetCapabilities&version=1.1.1"), (HTTPResponse)new MockHttpResponse(capsDocument, "text/xml", new String[0]));
        String caps = this.wms11BaseNfiURL + "?service=WMS&request=GetCapabilities&version=1.1.1";
        TestHttpClientProvider.bind((HTTPClient)this.wms11ClientNfi, (String)caps);
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        WMSStoreInfo store = cb.buildWMSStore("mock-wms-store-110-nfi");
        this.getCatalog().add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        store.setCapabilitiesURL(caps);
        WMSLayerInfo wmsLayer = cb.buildWMSLayer("world4326");
        wmsLayer.setName(WORLD4326_110_NFI);
        this.getCatalog().add((ResourceInfo)wmsLayer);
        LayerInfo gsLayer = cb.buildLayer(wmsLayer);
        this.getCatalog().add(gsLayer);
    }
}

