/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class WMSDimensionsTestSupport
extends WMSTestSupport {
    protected static final long MILLIS_IN_DAY = 86400000L;
    protected static final long MILLIS_IN_MINUTE = 60000L;
    protected QName V_TIME_ELEVATION = new QName(MockData.SF_URI, "TimeElevation", MockData.SF_PREFIX);
    protected QName V_TIME_ELEVATION_EMPTY = new QName(MockData.SF_URI, "TimeElevationEmpty", MockData.SF_PREFIX);
    protected QName V_TIME_ELEVATION_STACKED = new QName(MockData.SF_URI, "TimeElevationStacked", MockData.SF_PREFIX);
    protected static QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    protected static QName TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    protected static QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);
    protected static final String UNITS = "foot";
    protected static final String UNIT_SYMBOL = "ft";
    CoverageInfo wattemp;
    FeatureTypeInfo te;
    FeatureTypeInfo teEmpty;
    private CoverageInfo timeranges;

    @Before
    public void saveOriginalInfoObjects() throws Exception {
        this.wattemp = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        this.timeranges = this.getCatalog().getCoverageByName(TIMERANGES.getLocalPart());
        this.te = this.getCatalog().getFeatureTypeByName(this.V_TIME_ELEVATION.getLocalPart());
        this.teEmpty = this.getCatalog().getFeatureTypeByName(this.V_TIME_ELEVATION_EMPTY.getLocalPart());
    }

    @After
    public void restoreOriginalInfoObjects() throws Exception {
        this.wattemp.getMetadata().clear();
        this.getCatalog().save((ResourceInfo)this.wattemp);
        this.timeranges.getMetadata().clear();
        this.getCatalog().save((ResourceInfo)this.timeranges);
        this.te.getMetadata().clear();
        this.getCatalog().save((ResourceInfo)this.te);
        this.teEmpty.getMetadata().clear();
        this.getCatalog().save((ResourceInfo)this.teEmpty);
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("", "http://www.opengis.net/wms");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
        namespaces.put("ows", "http://www.opengis.net/kml/2.2");
        namespaces.put("sf", "http://cite.opengeospatial.org/gmlsf");
        SystemTestData cfr_ignored_0 = (SystemTestData)this.getTestData();
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        this.getGeoServer().save((ServiceInfo)wms);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("style", "TimeElevation");
        Catalog catalog = this.getCatalog();
        testData.addStyle("TimeElevation", "TimeElevation.sld", WMSDimensionsTestSupport.class, catalog);
        testData.addVectorLayer(this.V_TIME_ELEVATION, map, "TimeElevation.properties", WMSDimensionsTestSupport.class, catalog);
        testData.addVectorLayer(this.V_TIME_ELEVATION_EMPTY, map, "TimeElevationEmpty.properties", WMSDimensionsTestSupport.class, catalog);
        map.put("style", "TimeElevationStacked");
        testData.addStyle("TimeElevationStacked", "TimeElevationStacked.sld", WMSDimensionsTestSupport.class, catalog);
        testData.addVectorLayer(this.V_TIME_ELEVATION_STACKED, map, "TimeElevationStacked.properties", WMSDimensionsTestSupport.class, catalog);
        testData.addStyle("temperature", "temperature.sld", WMSDimensionsTestSupport.class, catalog);
        HashMap<SystemTestData.LayerProperty, String> propertyMap = new HashMap<SystemTestData.LayerProperty, String>();
        propertyMap.put(SystemTestData.LayerProperty.STYLE, "temperature");
        testData.addRasterLayer(TIMESERIES, "timeseries.zip", null, null, SystemTestData.class, catalog);
        testData.addRasterLayer(WATTEMP, "watertemp.zip", null, propertyMap, SystemTestData.class, catalog);
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, catalog);
    }

    protected static void assertDateEquals(Date d1, Date d2, long tolerance) {
        long difference = Math.abs(d1.getTime() - d2.getTime());
        Assert.assertTrue((difference <= tolerance ? 1 : 0) != 0);
    }

    protected void setupVectorDimension(String metadata, String attribute, DimensionPresentation presentation, Double resolution, String units, String unitSymbol) {
        this.setupVectorDimension("TimeElevation", metadata, attribute, presentation, resolution, units, unitSymbol);
    }

    protected void setupResourceDimensionDefaultValue(QName name, String dimensionName, DimensionDefaultValueSetting defaultValue, String ... startEndAttribute) {
        ResourceInfo info = this.getCatalog().getResourceByName(name.getLocalPart(), ResourceInfo.class);
        if (info == null) {
            throw new RuntimeException("Unable to get resource by name " + name.getLocalPart());
        }
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(DimensionPresentation.LIST);
        di.setDefaultValue(defaultValue);
        if (startEndAttribute != null && startEndAttribute.length > 0) {
            di.setAttribute(startEndAttribute[0]);
            if (startEndAttribute.length > 1) {
                di.setEndAttribute(startEndAttribute[1]);
            }
        }
        info.getMetadata().put(dimensionName, (Serializable)di);
        this.getCatalog().save(info);
    }

    protected void assertWarningCount(int expectedValue) {
        MockHttpServletResponse response = this.getLastResponse();
        List values = response.getHeaderValues("Warning");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((String)"Expected to find a different number of warnings", (long)expectedValue, (long)values.size());
    }

    protected void assertNearestTimeWarning(String layerId, String expectedValue) {
        String expected = "99 Nearest value used: time=" + expectedValue + " " + "ISO8601" + " (" + layerId + ")";
        MockHttpServletResponse response = this.getLastResponse();
        List values = response.getHeaderValues("Warning");
        Object found = values.stream().filter(v -> expected.equals(v)).findFirst().orElse(null);
        Assert.assertNotNull((String)("Could not find\n" + expected + "\n among the following warnings:\n" + values), found);
    }

    protected void assertNoNearestWarning(String layerId, String dimension) {
        String expected = "99 No nearest value found on " + layerId + ": " + dimension;
        MockHttpServletResponse response = this.getLastResponse();
        List values = response.getHeaderValues("Warning");
        Object found = values.stream().filter(v -> expected.equals(v)).findFirst().orElse(null);
        Assert.assertNotNull((String)("Could not find\n" + expected + "\n among the following warnings:\n" + values), found);
    }
}

