/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;

public class WMSTest
extends WMSTestSupport {
    static final QName TIME_WITH_START_END = new QName(MockData.SF_URI, "TimeWithStartEnd", MockData.SF_PREFIX);
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(TIME_WITH_START_END, Collections.EMPTY_MAP, "TimeElevationWithStartEnd.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    protected void setupStartEndTimeDimension(String featureTypeName, String dimension, String start, String end) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(featureTypeName);
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute(start);
        di.setEndAttribute(end);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put(dimension, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    @Before
    public void setWMS() throws Exception {
        this.wms = new WMS(this.getGeoServer());
    }

    @Test
    public void testGetTimeElevationToFilterStartEndDate() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "time", "startTime", "endTime");
        this.setupStartEndTimeDimension(TIME_WITH_START_END.getLocalPart(), "elevation", "startElevation", "endElevation");
        this.doTimeElevationFilter(Date.valueOf("2012-02-10"), null, new Integer[0]);
        this.doTimeElevationFilter(Date.valueOf("2012-02-11"), null, 0, 2);
        this.doTimeElevationFilter(Date.valueOf("2012-02-12"), null, 0, 1, 2);
        this.doTimeElevationFilter(Date.valueOf("2012-02-13"), null, 1, 2);
        this.doTimeElevationFilter(Date.valueOf("2012-02-15"), null, new Integer[0]);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-09"), (java.util.Date)Date.valueOf("2012-02-10")), null, new Integer[0]);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-09"), (java.util.Date)Date.valueOf("2012-02-11")), null, 0, 2);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-11"), (java.util.Date)Date.valueOf("2012-02-13")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-09"), (java.util.Date)Date.valueOf("2012-02-14")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-13"), (java.util.Date)Date.valueOf("2012-02-14")), null, 1, 2);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-12"), (java.util.Date)Date.valueOf("2012-02-13")), null, 0, 1, 2);
        this.doTimeElevationFilter(new DateRange((java.util.Date)Date.valueOf("2012-02-15"), (java.util.Date)Date.valueOf("2012-02-16")), null, new Integer[0]);
        this.doTimeElevationFilter(null, 0, new Integer[0]);
        this.doTimeElevationFilter(null, 1, 0, 2);
        this.doTimeElevationFilter(null, 2, 0, 1, 2);
        this.doTimeElevationFilter(null, 3, 1, 2);
        this.doTimeElevationFilter(null, 4, new Integer[0]);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)0), new Integer[0]);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)1), 0, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)1, (Number)3), 0, 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)-1, (Number)4), 0, 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)3, (Number)4), 1, 2);
        this.doTimeElevationFilter(null, new NumberRange(Integer.class, (Number)4, (Number)5), new Integer[0]);
        this.doTimeElevationFilter(Date.valueOf("2012-02-12"), 2, 0, 1, 2);
        this.doTimeElevationFilter(Date.valueOf("2012-02-11"), 3, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTimeElevationFilter(Object time, Object elevation, Integer ... expectedIds) throws Exception {
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        FeatureSource fs = timeWithStartEnd.getFeatureSource(null, null);
        List<Object> times = time == null ? null : Arrays.asList(time);
        List<Object> elevations = elevation == null ? null : Arrays.asList(elevation);
        Filter filter = this.wms.getTimeElevationToFilter(times, elevations, timeWithStartEnd);
        FeatureCollection features = fs.getFeatures(filter);
        HashSet<Integer> results = new HashSet<Integer>();
        try (FeatureIterator it = features.features();){
            while (it.hasNext()) {
                results.add((Integer)it.next().getProperty("id").getValue());
            }
        }
        Assert.assertTrue((String)("expected " + Arrays.toString((Object[])expectedIds) + " but got " + results), (boolean)results.containsAll(Arrays.asList(expectedIds)));
        Assert.assertTrue((String)("expected " + Arrays.toString((Object[])expectedIds) + " but got " + results), (boolean)Arrays.asList(expectedIds).containsAll(results));
    }

    @Test
    public void testWMSLifecycleHandlerGraphicCacheReset() throws Exception {
        Iterator it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
        Map imageCache = null;
        while (it.hasNext()) {
            ExternalGraphicFactory egf = (ExternalGraphicFactory)it.next();
            if (!(egf instanceof ImageGraphicFactory)) continue;
            Field cache = egf.getClass().getDeclaredField("imageCache");
            cache.setAccessible(true);
            imageCache = (Map)cache.get(egf);
            URL u = new URL("http://boundless.org");
            BufferedImage b = new BufferedImage(6, 6, 8);
            imageCache.put(u, b);
        }
        Assert.assertNotEquals((long)0L, (long)imageCache.size());
        this.getGeoServer().reload();
        Assert.assertEquals((long)0L, (long)imageCache.size());
    }

    @Test
    public void testCacheConfiguration() {
        Assert.assertFalse((boolean)this.wms.isRemoteStylesCacheEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isRemoteStylesCacheEnabled());
    }

    @Test
    public void testProjectionDensification() {
        Assert.assertFalse((boolean)this.wms.isAdvancedProjectionDensificationEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isAdvancedProjectionDensificationEnabled());
    }

    @Test
    public void testWrappingHeuristic() {
        Assert.assertFalse((boolean)this.wms.isDateLineWrappingHeuristicDisabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.DATELINE_WRAPPING_HEURISTIC_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertTrue((boolean)this.wms.isDateLineWrappingHeuristicDisabled());
    }

    @Test
    public void testRootLayerInCapabilitiesEanbled() {
        Assert.assertTrue((boolean)this.wms.isRootLayerInCapabilitesEnabled());
        WMSInfo info = this.wms.getServiceInfo();
        info.getMetadata().put(WMS.ROOT_LAYER_IN_CAPABILITIES_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Assert.assertFalse((boolean)this.wms.isRootLayerInCapabilitesEnabled());
    }
}

