/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import org.geoserver.wms.decoration.DecorationTestSupport;
import org.geoserver.wms.decoration.ScaleLineDecoration;
import org.junit.Test;

public class ScaleLineDecorationTest
extends DecorationTestSupport {
    @Test
    public void testTransparency() throws Exception {
        ScaleLineDecoration d = new ScaleLineDecoration();
        BufferedImage bi = this.paintOnImage(d);
        this.assertPixel(bi, 180, 160, Color.WHITE);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("transparent", "true");
        d.loadOptions(options);
        BufferedImage bi2 = this.paintOnImage(d);
        this.assertPixel(bi2, 180, 160, new Color(0, 0, 0, 0));
    }

    @Test
    public void testMeasurementOption() throws Exception {
        ScaleLineDecoration d = new ScaleLineDecoration();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("measurement-system", "metric");
        d.loadOptions(options);
        BufferedImage bi = this.paintOnImage(d);
        this.assertPixel(bi, 109, 139, Color.black);
        this.assertPixel(bi, 109, 157, Color.white);
        options.clear();
        options.put("measurement-system", "imperial");
        d.loadOptions(options);
        bi = this.paintOnImage(d);
        this.assertPixel(bi, 109, 157, Color.black);
        this.assertPixel(bi, 109, 139, Color.white);
        options.clear();
        options.put("measurement-system", "both");
        d.loadOptions(options);
        bi = this.paintOnImage(d);
        this.assertPixel(bi, 109, 157, Color.black);
        this.assertPixel(bi, 109, 139, Color.black);
        options.clear();
        d.loadOptions(options);
        bi = this.paintOnImage(d);
        this.assertPixel(bi, 109, 157, Color.black);
        this.assertPixel(bi, 109, 139, Color.black);
    }

    private BufferedImage paintOnImage(ScaleLineDecoration d) throws Exception {
        BufferedImage bi = new BufferedImage(300, 300, 6);
        Graphics2D g2d = bi.createGraphics();
        d.paint(g2d, new Rectangle(300, 300), this.createMapContent(300.0));
        g2d.dispose();
        return bi;
    }
}

