/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.util.HashMap;
import org.geoserver.wms.decoration.DecorationTestSupport;
import org.geoserver.wms.decoration.ScaleRatioDecoration;
import org.junit.Assert;
import org.junit.Test;

public class ScaleRatioDecorationTest
extends DecorationTestSupport {
    @Test
    public void testRatio() throws Exception {
        ScaleRatioDecoration d = new ScaleRatioDecoration();
        Assert.assertEquals((double)3975.0, (double)d.getScale(this.createMapContent(-1.0)), (double)1.0);
        Assert.assertEquals((double)3975.0, (double)d.getScale(this.createMapContent(90.7142857142857)), (double)1.0);
        Assert.assertEquals((double)13147.0, (double)d.getScale(this.createMapContent(300.0)), (double)1.0);
        Assert.assertEquals((double)26295.0, (double)d.getScale(this.createMapContent(600.0)), (double)1.0);
        Assert.assertEquals((double)78887.0, (double)d.getScale(this.createMapContent(1800.0)), (double)1.0);
    }

    @Test
    public void testDefaultFormat() throws Exception {
        ScaleRatioDecoration d = new ScaleRatioDecoration();
        Assert.assertEquals((Object)"1 : 13148", (Object)d.getScaleText(this.createMapContent(300.0)));
    }

    @Test
    public void testCustomFormat() throws Exception {
        ScaleRatioDecoration d = new ScaleRatioDecoration();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("format", "#,###");
        options.put("formatLanguage", "en");
        d.loadOptions(options);
        Assert.assertEquals((Object)"1 : 13,148", (Object)d.getScaleText(this.createMapContent(300.0)));
        options.put("formatLanguage", "it");
        d.loadOptions(options);
        Assert.assertEquals((Object)"1 : 13.148", (Object)d.getScaleText(this.createMapContent(300.0)));
    }
}

