/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wms.decoration.WatermarkDecoration;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;

public class WatermarkDecorationTest
extends GeoServerSystemTestSupport {
    @Test
    public void testAbsolutePath() throws Exception {
        WatermarkDecoration d = new WatermarkDecoration();
        HashMap<String, String> options = new HashMap<String, String>();
        File file = new File("src/test/resources/org/geoserver/wms/world.png");
        options.put("url", URLs.fileToUrl((File)file.getAbsoluteFile().getCanonicalFile()).toExternalForm());
        d.loadOptions(options);
        BufferedImage logo = d.getLogo();
        Assert.assertNotNull((Object)logo);
        Assert.assertEquals((long)180L, (long)logo.getWidth());
        Assert.assertEquals((long)90L, (long)logo.getHeight());
    }

    @Test
    public void testRelativePath() throws Exception {
        WatermarkDecoration d = new WatermarkDecoration();
        HashMap<String, String> options = new HashMap<String, String>();
        File file = new File("src/test/resources/org/geoserver/wms/world.png");
        File styles = this.getDataDirectory().findOrCreateDir(new String[]{"styles"});
        File logoFile = new File(styles, "world.png").getAbsoluteFile();
        FileUtils.copyFile((File)file, (File)logoFile);
        options.put("url", "file:styles/world.png");
        d.loadOptions(options);
        BufferedImage logo = d.getLogo();
        Assert.assertNotNull((Object)logo);
        Assert.assertEquals((long)180L, (long)logo.getWidth());
        Assert.assertEquals((long)90L, (long)logo.getHeight());
    }

    @Test
    public void testRelativeUnqualifiedPath() throws Exception {
        WatermarkDecoration d = new WatermarkDecoration();
        HashMap<String, String> options = new HashMap<String, String>();
        File file = new File("src/test/resources/org/geoserver/wms/world.png");
        File styles = this.getDataDirectory().findOrCreateDir(new String[]{"styles"});
        File logoFile = new File(styles, "world.png").getAbsoluteFile();
        FileUtils.copyFile((File)file, (File)logoFile);
        options.put("url", "styles/world.png");
        d.loadOptions(options);
        BufferedImage logo = d.getLogo();
        Assert.assertNotNull((Object)logo);
        Assert.assertEquals((long)180L, (long)logo.getWidth());
        Assert.assertEquals((long)90L, (long)logo.getHeight());
    }
}

