/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;

public class CustomDimensionTimeAndNumberTest
extends WMSTestSupport {
    private static final QName WATTEMP_TIME = new QName(MockData.SF_URI, "watertemp_time", MockData.SF_PREFIX);
    private static final QName WATTEMP_DEPTH = new QName(MockData.SF_URI, "watertemp_depth", MockData.SF_PREFIX);
    private static SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addRasterLayer(WATTEMP_TIME, "custwatertemp_time.zip", null, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
        ((SystemTestData)testData).addRasterLayer(WATTEMP_DEPTH, "custwatertemp_depth.zip", null, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testTimeDimension() throws Exception {
        MapLayerInfo mapLayerInfo = new MapLayerInfo(this.getCatalog().getLayerByName(WATTEMP_TIME.getLocalPart()));
        GridCoverage2DReader reader = (GridCoverage2DReader)mapLayerInfo.getCoverageReader();
        GetMapRequest req = new GetMapRequest();
        req.setRawKvp(new HashMap());
        req.getRawKvp().put("DIM_MY_DIMENSION", "2001-05-01T00:00:00.000Z, 2001-05-02T00:00:00.000Z");
        GeneralParameterValue[] readParam = this.wms.getWMSReadParameters(req, mapLayerInfo, (Filter)Filter.INCLUDE, null, null, null, reader, false);
        ParameterValue val = (ParameterValue)readParam[readParam.length - 1];
        Assert.assertEquals((long)2L, (long)((List)val.getValue()).size());
        Assert.assertEquals((Object)DF.parse("2001-05-01 00:00:00"), ((List)val.getValue()).get(0));
        Assert.assertEquals((Object)DF.parse("2001-05-02 00:00:00"), ((List)val.getValue()).get(1));
    }

    @Test
    public void testCustomDepthIntervalDimension() throws Exception {
        MapLayerInfo mapLayerInfo = new MapLayerInfo(this.getCatalog().getLayerByName(WATTEMP_DEPTH.getLocalPart()));
        GridCoverage2DReader reader = (GridCoverage2DReader)mapLayerInfo.getCoverageReader();
        GetMapRequest req = new GetMapRequest();
        req.setRawKvp(new HashMap());
        req.getRawKvp().put("DIM_MY_DIMENSION", "10/50");
        GeneralParameterValue[] readParam = this.wms.getWMSReadParameters(req, mapLayerInfo, (Filter)Filter.INCLUDE, null, null, null, reader, false);
        ParameterValue val = (ParameterValue)readParam[readParam.length - 1];
        Assert.assertEquals((Object)new NumberRange(Double.class, (Number)10.0, (Number)50.0), ((List)val.getValue()).get(0));
    }

    @Test
    public void testCustomDepthListDimension() throws Exception {
        MapLayerInfo mapLayerInfo = new MapLayerInfo(this.getCatalog().getLayerByName(WATTEMP_DEPTH.getLocalPart()));
        GridCoverage2DReader reader = (GridCoverage2DReader)mapLayerInfo.getCoverageReader();
        GetMapRequest req = new GetMapRequest();
        req.setRawKvp(new HashMap());
        req.getRawKvp().put("DIM_MY_DIMENSION", "10,50");
        GeneralParameterValue[] readParam = this.wms.getWMSReadParameters(req, mapLayerInfo, (Filter)Filter.INCLUDE, null, null, null, reader, false);
        ParameterValue val = (ParameterValue)readParam[readParam.length - 1];
        Assert.assertEquals((double)10.0, (double)((Double)((List)val.getValue()).get(0)), (double)1.0E-6);
        Assert.assertEquals((double)50.0, (double)((Double)((List)val.getValue()).get(1)), (double)1.0E-6);
    }

    static {
        DF.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

