/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.util.Calendar;
import java.util.Collections;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.type.DateUtil;
import org.geotools.util.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class VectorTimeDimensionDefaultValueTest
extends WMSDimensionsTestSupport {
    static final QName TIME_WITH_START_END = new QName(MockData.SF_URI, "TimeWithStartEnd", MockData.SF_PREFIX);
    static final QName TIME_ELEVATION_TRUNCATED = new QName(MockData.SF_URI, "TimeElevationTruncated", MockData.SF_PREFIX);
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addVectorLayer(TIME_WITH_START_END, Collections.emptyMap(), "TimeElevationWithStartEnd.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        ((SystemTestData)testData).addVectorLayer(TIME_ELEVATION_TRUNCATED, Collections.emptyMap(), "TimeElevationTruncated.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testDefaultTimeVectorSelector() throws Exception {
        int fid = 1000;
        this.setupFeatureTimeDimension(null);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == twoDaysAgo.getTime() ? 1 : 0) != 0);
        Date dayAfterTomorrow = this.addFeatureWithTimeDayAfterTomorrow(fid++);
        this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == dayAfterTomorrow.getTime() ? 1 : 0) != 0);
        Date todayMidnight = this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == todayMidnight.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitCurrentTimeVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(DimensionDefaultValueSetting.TIME_CURRENT);
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == twoDaysAgo.getTime() ? 1 : 0) != 0);
        Date dayAfterTomorrow = this.addFeatureWithTimeDayAfterTomorrow(fid++);
        this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == dayAfterTomorrow.getTime() ? 1 : 0) != 0);
        Date todayMidnight = this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == todayMidnight.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMinTimeVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date smallest = Date.valueOf("2012-02-11");
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the smallest one", (d.getTime() == smallest.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeDayAfterTomorrow(fid++);
        this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the smallest one", (d.getTime() == smallest.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the smallest one", (d.getTime() == smallest.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMaxTimeVectorSelector() throws Exception {
        int fid = 1000;
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the biggest one", (d.getTime() == twoDaysAgo.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeDayAfterTomorrow(fid++);
        Date oneYearFromNow = this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the biggest one", (d.getTime() == oneYearFromNow.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the biggest one", (d.getTime() == oneYearFromNow.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitFixedTimeVectorSelector() throws Exception {
        int fid = 1000;
        String fixedTimeStr = "2012-06-01T03:00:00.000Z";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue(fixedTimeStr);
        long fixedTime = DateUtil.parseDateTime((String)fixedTimeStr);
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the fixed one", (d.getTime() == fixedTime ? 1 : 0) != 0);
        this.addFeatureWithTimeDayAfterTomorrow(fid++);
        this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the fixed one", (d.getTime() == fixedTime ? 1 : 0) != 0);
        this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the fixed one", (d.getTime() == fixedTime ? 1 : 0) != 0);
    }

    @Test
    public void testFixedRange() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        java.util.Date curr = new java.util.Date();
        Range d = (Range)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Returns a valid Default range", (d != null ? 1 : 0) != 0);
        VectorTimeDimensionDefaultValueTest.assertDateEquals(curr, (java.util.Date)d.getMaxValue(), 60000L);
        VectorTimeDimensionDefaultValueTest.assertDateEquals(new Date(curr.getTime() - 2592000000L), (java.util.Date)d.getMinValue(), 60000L);
    }

    @Test
    public void testExplicitNearestToGivenTimeVectorSelector() throws Exception {
        int fid = 1000;
        String preferredTimeStr = "2012-06-01T03:00:00.000Z";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(preferredTimeStr);
        Date expected = Date.valueOf("2012-02-12");
        this.setupFeatureTimeDimension(defaultValueSetting);
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        Date twoDaysAgo = this.addFeatureWithTimeTwoDaysAgo(fid++);
        this.addFeature(fid++, twoDaysAgo, 0.0);
        java.util.Date d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == expected.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeDayAfterTomorrow(fid++);
        this.addFeatureWithTimeOneYearFromNow(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == expected.getTime() ? 1 : 0) != 0);
        this.addFeatureWithTimeTodayMidnight(fid++);
        d = (java.util.Date)this.wms.getDefaultTime((ResourceInfo)timeWithStartEnd);
        Assert.assertTrue((String)"Default time is null", (d != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default time should be the closest one", (d.getTime() == expected.getTime() ? 1 : 0) != 0);
    }

    @Test
    public void testNearestOnTruncatedDataset() throws Exception {
        String preferredTimeStr = "2020-06-01T03:00:00.000Z";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(preferredTimeStr);
        this.setupFeatureTimeDimensionOnTruncated(defaultValueSetting);
        BufferedImage image = this.getAsImage(MockData.SF_PREFIX + "/wms??service=WMS&version=1.1.0&request=GetMap&layers=sf:TimeElevationTruncated&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=image/png", "image/png");
        Assert.assertNotNull((Object)image);
    }

    protected void setupFeatureTimeDimension(DimensionDefaultValueSetting defaultValue) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute("startTime");
        di.setDefaultValue(defaultValue);
        di.setPresentation(DimensionPresentation.LIST);
        info.getMetadata().put("time", (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void setupFeatureTimeDimensionOnTruncated(DimensionDefaultValueSetting defaultValue) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(TIME_ELEVATION_TRUNCATED.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setAttribute("time");
        di.setDefaultValue(defaultValue);
        di.setNearestMatchEnabled(true);
        di.setAcceptableInterval("PT98M/PT0H");
        di.setPresentation(DimensionPresentation.DISCRETE_INTERVAL);
        info.getMetadata().put("time", (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }

    protected void addFeature(int id, Date time, Double elevation) throws IOException {
        FeatureTypeInfo timeWithStartEnd = this.getCatalog().getFeatureTypeByName(TIME_WITH_START_END.getLocalPart());
        FeatureStore fs = (FeatureStore)timeWithStartEnd.getFeatureSource(null, null);
        SimpleFeatureType type = (SimpleFeatureType)timeWithStartEnd.getFeatureType();
        MemoryFeatureCollection coll = new MemoryFeatureCollection(type);
        StringBuffer content = new StringBuffer();
        content.append(id);
        content.append('|');
        content.append(time.toString());
        content.append("||");
        content.append(elevation);
        content.append('|');
        SimpleFeature f = DataUtilities.createFeature((SimpleFeatureType)type, (String)content.toString());
        coll.add(f);
        Transaction tx = fs.getTransaction();
        fs.addFeatures((FeatureCollection)coll);
        tx.commit();
    }

    private Date addFeatureWithTimeTodayMidnight(int fid) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        Date todayMidnight = new Date(cal.getTimeInMillis());
        this.addFeature(fid, todayMidnight, 0.0);
        return todayMidnight;
    }

    private Date addFeatureWithTimeTwoDaysAgo(int fid) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        cal.set(5, cal.get(5) - 2);
        Date twoDaysAgo = new Date(cal.getTimeInMillis());
        this.addFeature(fid, twoDaysAgo, 0.0);
        return twoDaysAgo;
    }

    private Date addFeatureWithTimeDayAfterTomorrow(int fid) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        cal.set(5, cal.get(5) + 2);
        Date tomorrow = new Date(cal.getTimeInMillis());
        this.addFeature(fid++, tomorrow, 0.0);
        return tomorrow;
    }

    private Date addFeatureWithTimeOneYearFromNow(int fid) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        cal.set(1, cal.get(1) + 1);
        Date oneYearFromNow = new Date(cal.getTimeInMillis());
        this.addFeature(fid++, oneYearFromNow, 0.0);
        return oneYearFromNow;
    }
}

