/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.featureinfo.GeoJSONFeatureInfoResponse;
import org.geoserver.wms.wms_1_1_1.GetFeatureInfoTest;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class GetFeatureInfoJSONTest
extends GetFeatureInfoTest {
    public static final QName TEMPORAL_DATA = new QName(CiteTestData.CITE_URI, "TemporalData", CiteTestData.CITE_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(TEMPORAL_DATA, Collections.EMPTY_MAP, "TemporalData.properties", SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testSimpleJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "text/javascript";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("parseResponse"));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("parseResponse".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testCustomJSONP() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "text/javascript" + "&format_options=" + "callback" + ":custom";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        JSONType.setJsonpEnabled((boolean)false);
        Assert.assertEquals((Object)"text/javascript", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.startsWith("custom("));
        Assert.assertTrue((boolean)result.endsWith(")"));
        Assert.assertTrue((result.indexOf("Green Forest") > 0 ? 1 : 0) != 0);
        result = result.substring(0, result.length() - 1);
        result = result.substring("custom".length() + 1, result.length());
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testSimpleJSON() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertEquals((Object)aFeature.getString("geometry_name"), (Object)"the_geom");
    }

    @Test
    public void testPropertySelection() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?service=wms&version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json" + "&propertyName=NAME";
        MockHttpServletResponse response = this.getAsServletResponse(request, "");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
        String result = response.getContentAsString();
        Assert.assertNotNull((Object)result);
        JSONObject rootObject = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
        JSONArray featureCol = rootObject.getJSONArray("features");
        JSONObject aFeature = featureCol.getJSONObject(0);
        Assert.assertTrue((boolean)aFeature.getJSONObject("geometry").isNullObject());
        JSONObject properties = aFeature.getJSONObject("properties");
        Assert.assertTrue((boolean)properties.getJSONObject("FID").isNullObject());
        Assert.assertEquals((Object)"Green Forest", (Object)properties.get("NAME"));
    }

    @Test
    public void testReprojectedLayer() throws Exception {
        String layer = this.getLayerId(MockData.MPOLYGONS);
        String request = "wms?version=1.1.1&bbox=500525,500025,500575,500050&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONObject feature = (JSONObject)json.getJSONArray("features").get(0);
        JSONObject geom = feature.getJSONObject("geometry");
        JSONArray coords = geom.getJSONArray("coordinates").getJSONArray(0).getJSONArray(0).getJSONArray(0);
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500525.0, (Number)500575.0).contains((Number)coords.getDouble(0)));
        Assert.assertTrue((boolean)new NumberRange(Double.class, (Number)500025.0, (Number)500050.0).contains((Number)coords.getDouble(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCQLFilter() throws Exception {
        String layer = this.getLayerId(MockData.FORESTS);
        String request = "wms?version=1.1.1&bbox=-0.002,-0.002,0.002,0.002&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=20&height=20&x=10&y=10&info_format=" + "application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertTrue((features.size() > 0 ? 1 : 0) != 0);
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(layer);
        try {
            info.setCqlFilter("NAME LIKE 'Red%'");
            this.getCatalog().save((ResourceInfo)info);
            json = (JSONObject)this.getAsJSON(request);
            features = json.getJSONArray("features");
            Assert.assertEquals((long)0L, (long)features.size());
        }
        finally {
            info = this.getCatalog().getFeatureTypeByName(layer);
            info.setCqlFilter(null);
            this.getCatalog().save((ResourceInfo)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateTimeFormattingEnabled() throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
        try {
            System.getProperties().remove("org.geotools.dateTimeFormatHandling");
            System.setProperty("org.geotools.localDateTimeHandling", "true");
            Hints.scanSystemProperties();
            String layer = this.getLayerId(TEMPORAL_DATA);
            String request = "wms?version=1.1.1&bbox=39.73245,2.00342,39.732451,2.003421&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=10&height=10&x=5&y=5&info_format=" + "application/json";
            MockHttpServletResponse response = this.getAsServletResponse(request, "");
            Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
            Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
            String result = response.getContentAsString();
            Assert.assertNotNull((Object)result);
            JSONObject rootObject = JSONObject.fromObject((Object)result);
            Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
            JSONArray featureCol = rootObject.getJSONArray("features");
            JSONObject aFeature = featureCol.getJSONObject(0);
            JSONObject properties = aFeature.getJSONObject("properties");
            Assert.assertNotNull((Object)properties);
            Assert.assertEquals((Object)"2006-06-27T22:00:00-05:00", (Object)properties.getString("dateTimeProperty"));
            Assert.assertEquals((Object)"2006-12-12", (Object)properties.getString("dateProperty"));
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
            System.getProperties().remove("org.geotools.localDateTimeHandling");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateTimeFormattingDisabled() throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
            System.setProperty("org.geotools.dateTimeFormatHandling", "false");
            System.setProperty("org.geotools.localDateTimeHandling", "true");
            Hints.scanSystemProperties();
            String layer = this.getLayerId(TEMPORAL_DATA);
            String request = "wms?version=1.1.1&bbox=39.73245,2.00342,39.732451,2.003421&styles=&format=jpeg&request=GetFeatureInfo&layers=" + layer + "&query_layers=" + layer + "&width=10&height=10&x=5&y=5&info_format=" + "application/json";
            MockHttpServletResponse response = this.getAsServletResponse(request, "");
            Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
            Assert.assertTrue((boolean)"UTF-8".equals(response.getCharacterEncoding()));
            String result = response.getContentAsString();
            Assert.assertNotNull((Object)result);
            JSONObject rootObject = JSONObject.fromObject((Object)result);
            Assert.assertEquals((Object)rootObject.get("type"), (Object)"FeatureCollection");
            JSONArray featureCol = rootObject.getJSONArray("features");
            JSONObject aFeature = featureCol.getJSONObject(0);
            JSONObject properties = aFeature.getJSONObject("properties");
            Assert.assertNotNull((Object)properties);
            Assert.assertEquals((Object)"2006-06-28T03:00:00Z", (Object)properties.getString("dateTimeProperty"));
            Assert.assertEquals((Object)"2006-12-12", (Object)properties.getString("dateProperty"));
        }
        finally {
            System.getProperties().remove("org.geotools.dateTimeFormatHandling");
            System.getProperties().remove("org.geotools.localDateTimeHandling");
            Hints.scanSystemProperties();
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    @Test
    public void testJSONFreeMarkerTemplate() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix(), "cite", TEMPORAL_DATA.getLocalPart()}));
        Resource workspace = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix()}));
        File fileHeader = new File(workspace.dir(), "header_json.ftl");
        File fileFooter = new File(workspace.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(TEMPORAL_DATA.getPrefix(), TEMPORAL_DATA.getLocalPart());
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfo layerInfo = this.getCatalog().getLayerByName(TEMPORAL_DATA.getLocalPart());
        MapLayerInfo mapLayerInfo = new MapLayerInfo(layerInfo);
        queryLayers.add(mapLayerInfo);
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", mapLayerInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        FeatureCollection fc = ft.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject featureInfo = (JSONObject)featuresInfo.get(0);
        Assert.assertEquals((Object)featureInfo.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)featureInfo.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)featureInfo.get("id"), (Object)"Points.0");
        Assert.assertNotNull((Object)featureInfo.get("geometry"));
        JSONObject props = featureInfo.getJSONObject("properties");
        Assert.assertEquals((Object)props.get("id"), (Object)"t0000");
        Assert.assertEquals((Object)props.get("altitude"), (Object)"500");
        Assert.assertNotNull((Object)props.get("dateTimeProperty"));
        Assert.assertNotNull((Object)props.get("dateProperty"));
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContent.delete();
        fileFooter.delete();
    }

    @Test
    public void testJSONFreeMarkerTemplateLayerGroup() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource templates = loader.get(Paths.path((String[])new String[]{"templates"}));
        Resource resForest = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.FORESTS.getPrefix(), "cite", MockData.FORESTS.getLocalPart()}));
        Resource resLake = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.LAKES.getPrefix(), "cite", MockData.LAKES.getLocalPart()}));
        File fileHeader = new File(templates.dir(), "header_json.ftl");
        File fileFooter = new File(templates.dir(), "footer_json.ftl");
        File fileContentForest = new File(resForest.dir(), "content_json.ftl");
        File fileContentLake = new File(resLake.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContentForest);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContentLake);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerGroupInfo lgInfo = this.getCatalog().getLayerGroupByName("nature");
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        for (PublishedInfo info : lgInfo.getLayers()) {
            layers.add((LayerInfo)info);
            queryLayers.add(new MapLayerInfo((LayerInfo)info));
        }
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", lgInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        for (LayerInfo l : layers) {
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(l.getName());
            fct.getFeature().add((Object)fti.getFeatureSource(null, null).getFeatures());
        }
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject fiLake = (JSONObject)featuresInfo.get(0);
        Assert.assertEquals((Object)fiLake.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiLake.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiLake.get("id"), (Object)"Lakes.1107531835962");
        JSONObject geomLake = fiLake.getJSONObject("geometry");
        Assert.assertEquals((Object)geomLake.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomLake.getJSONArray("coordinates"));
        JSONObject lakeProps = fiLake.getJSONObject("properties");
        Assert.assertEquals((Object)lakeProps.get("NAME"), (Object)"Blue Lake");
        Assert.assertEquals((Object)lakeProps.get("FID"), (Object)"101");
        JSONObject fiForest = (JSONObject)featuresInfo.get(1);
        Assert.assertEquals((Object)fiForest.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiForest.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiForest.get("id"), (Object)"Forests.1107531798144");
        JSONObject geomForest = fiForest.getJSONObject("geometry");
        Assert.assertEquals((Object)geomForest.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomForest.getJSONArray("coordinates"));
        JSONObject forestProps = fiForest.getJSONObject("properties");
        Assert.assertEquals((Object)forestProps.get("NAME"), (Object)"Green Forest");
        Assert.assertEquals((Object)forestProps.get("FID"), (Object)"109");
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContentForest.delete();
        fileContentLake.delete();
        fileFooter.delete();
    }

    @Test
    public void testJSONFreeMarkerTemplateLayerGroupMixed() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL headerUrl = ((Object)((Object)this)).getClass().getResource("../header_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource templates = loader.get(Paths.path((String[])new String[]{"templates"}));
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", MockData.FORESTS.getPrefix(), "cite", MockData.FORESTS.getLocalPart()}));
        File fileHeader = new File(templates.dir(), "header_json.ftl");
        File fileFooter = new File(templates.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)headerUrl, (File)fileHeader);
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerGroupInfo lgInfo = this.getCatalog().getLayerGroupByName("nature");
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        for (PublishedInfo info : lgInfo.getLayers()) {
            layers.add((LayerInfo)info);
            queryLayers.add(new MapLayerInfo((LayerInfo)info));
        }
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", lgInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        for (LayerInfo l : layers) {
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(l.getName());
            fct.getFeature().add((Object)fti.getFeatureSource(null, null).getFeatures());
        }
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertEquals((Object)response.get("header"), (Object)"this is the header");
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject fiLake = (JSONObject)featuresInfo.get(0);
        Assert.assertNull((Object)fiLake.get("content"));
        Assert.assertEquals((Object)fiLake.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiLake.get("id"), (Object)"Lakes.1107531835962");
        JSONObject geomLake = fiLake.getJSONObject("geometry");
        Assert.assertEquals((Object)geomLake.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomLake.getJSONArray("coordinates"));
        JSONObject lakeProps = fiLake.getJSONObject("properties");
        Assert.assertEquals((Object)lakeProps.get("NAME"), (Object)"Blue Lake");
        Assert.assertEquals((Object)lakeProps.get("FID"), (Object)"101");
        JSONObject fiForest = (JSONObject)featuresInfo.get(1);
        Assert.assertEquals((Object)fiForest.get("content"), (Object)"this is the content");
        Assert.assertEquals((Object)fiForest.get("type"), (Object)"Feature");
        Assert.assertEquals((Object)fiForest.get("id"), (Object)"Forests.1107531798144");
        JSONObject geomForest = fiForest.getJSONObject("geometry");
        Assert.assertEquals((Object)geomForest.get("type"), (Object)"MultiPolygon");
        Assert.assertNotNull((Object)geomForest.getJSONArray("coordinates"));
        JSONObject forestProps = fiForest.getJSONObject("properties");
        Assert.assertEquals((Object)forestProps.get("NAME"), (Object)"Green Forest");
        Assert.assertEquals((Object)forestProps.get("FID"), (Object)"109");
        Assert.assertEquals((Object)response.get("footer"), (Object)"this is the footer");
        fileHeader.delete();
        fileContent.delete();
        fileFooter.delete();
    }

    @Test
    public void testJSONWithFreeMarkerWithMissingTemplate() throws Exception {
        URL contentUrl = ((Object)((Object)this)).getClass().getResource("../content_json.ftl");
        URL footerUrl = ((Object)((Object)this)).getClass().getResource("../footer_json.ftl");
        GeoJSONFeatureInfoResponse geoJsonResp = new GeoJSONFeatureInfoResponse(this.getWMS(), this.getCatalog().getResourceLoader(), "application/json");
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(TEMPORAL_DATA.getPrefix(), TEMPORAL_DATA.getLocalPart());
        GeoServerResourceLoader loader = this.getDataDirectory().getResourceLoader();
        Resource resource = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix(), "cite", TEMPORAL_DATA.getLocalPart()}));
        Resource workspace = loader.get(Paths.path((String[])new String[]{"workspaces", TEMPORAL_DATA.getPrefix()}));
        File fileFooter = new File(workspace.dir(), "footer_json.ftl");
        File fileContent = new File(resource.dir(), "content_json.ftl");
        FileUtils.copyURLToFile((URL)contentUrl, (File)fileContent);
        FileUtils.copyURLToFile((URL)footerUrl, (File)fileFooter);
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>();
        LayerInfo layerInfo = this.getCatalog().getLayerByName(TEMPORAL_DATA.getLocalPart());
        MapLayerInfo mapLayerInfo = new MapLayerInfo(layerInfo);
        queryLayers.add(mapLayerInfo);
        GetFeatureInfoRequest getFeatureInfoRequest = new GetFeatureInfoRequest();
        getFeatureInfoRequest.setQueryLayers(queryLayers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("LAYER", mapLayerInfo.getName());
        Request request = new Request();
        request.setKvp(parameters);
        Dispatcher.REQUEST.set(request);
        FeatureCollection fc = ft.getFeatureSource(null, null).getFeatures();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        geoJsonResp.write(fct, getFeatureInfoRequest, (OutputStream)outStream);
        String result = new String(outStream.toByteArray());
        JSONObject response = JSONObject.fromObject((Object)result);
        Assert.assertNull((Object)response.get("header"));
        JSONArray featuresInfo = response.getJSONArray("features");
        JSONObject featureInfo = (JSONObject)featuresInfo.get(0);
        Assert.assertNull((Object)featureInfo.get("content"));
        Assert.assertNotNull((Object)featureInfo.get("id"));
        JSONObject properties = (JSONObject)featureInfo.get("properties");
        Assert.assertNotNull((Object)properties.get("altitude"));
        Assert.assertNotNull((Object)properties.get("dateTimeProperty"));
        Assert.assertNotNull((Object)properties.get("dateProperty"));
        Assert.assertNull((Object)response.get("footer"));
        fileFooter.delete();
        fileContent.delete();
    }
}

